/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.html;

import com.streamscape.Trace;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.html.AbstractHtmlPage;
import com.streamscape.sef.network.http.server.html.AbstractHtmlTable;
import com.streamscape.sef.network.http.server.html.EventPrototypesHtmlTable;
import com.streamscape.sef.network.http.server.html.ExtendedRowMetaData;
import com.streamscape.sef.network.http.server.html.HtmlTokenFormatter;
import com.streamscape.sef.network.http.server.html.PropertiesHtmlTable;
import com.streamscape.sef.network.http.server.html.SemanticTypeLink;
import com.streamscape.sef.network.http.server.servlet.SorServletCss;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import com.streamscape.slex.slang.SLSession;

public class EventPrototypeHtml
extends AbstractHtmlPage {
    private PropertiesHtmlTable propertiesTable;
    private AbstractHtmlTable eventPropertiesTable;
    private String eventId;

    @Override
    public String getTitle() {
        return "Event Prototype";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
        if (connection == null) {
            throw new Exception("Authorization required to perform this operation.");
        }
        this.eventId = url.getUriParameterOrThrowException("eventId");
        if (this.eventId == null) {
            throw new Exception("Parameter eventId is missing.");
        }
        try (SLSession slSession = connection.createSLSession();){
            SLResponse slResponse = slSession.slangRequest("describe event prototype [" + this.eventId + "]", 30000L);
            if (slResponse.isOK()) {
                this.propertiesTable = new PropertiesHtmlTable();
                RowSet rowSet = slResponse.getRowSet();
                while (slResponse.getRowSet().next()) {
                    String name = rowSet.getString(1);
                    Object value = rowSet.getObject(2);
                    if (name.equalsIgnoreCase("Semantic Type") && value != null && value instanceof String && ((String)value).length() > 0) {
                        this.propertiesTable.addIfNotNull(name, new SemanticTypeLink((String)value));
                        continue;
                    }
                    this.propertiesTable.addIfNotNull(name, value);
                }
            } else {
                throw new Exception(EventPrototypeHtml.getSLResponseError(slResponse));
            }
            slResponse = slSession.slangRequest("describe event prototype properties [" + this.eventId + "]", 30000L);
            if (slResponse.isOK() && slResponse.getRowSet() != null) {
                this.eventPropertiesTable = new EventPropertiesHtmlTable(slResponse.getRowSet());
            }
        }
    }

    protected static String getSLResponseError(SLResponse response) {
        if (response.isOK()) {
            return null;
        }
        if (response.getText() != null) {
            return response.getText();
        }
        if (response.getException() != null) {
            return response.getException().getMessage();
        }
        return null;
    }

    @Override
    public String getHtml() {
        return this.getHeaderHtml() + this.propertiesTable.getHtml() + (String)(this.eventPropertiesTable != null ? "<br>" + this.eventPropertiesTable.getHtml() : "") + this.getSerializationHtml();
    }

    public String getSerializationHtml() {
        StringBuilder builder = new StringBuilder();
        builder.append("<div class=\"").append(SorServletCss.DEFAULT_DIV_STYLE).append("\">\n");
        HtmlTokenFormatter formatter = new HtmlTokenFormatter();
        builder.append(new EventPrototypesHtmlTable.EventSerializationLink(this.eventId, "XML", "XML Preview").addStyle(SorServletCss.LINK_BUTTON_STYLE).format(formatter)).append("\n");
        builder.append(new EventPrototypesHtmlTable.EventSerializationLink(this.eventId, "JSON", "JSON Preview").addStyle(SorServletCss.LINK_BUTTON_STYLE).format(formatter)).append("\n");
        builder.append("</div>\n");
        return builder.toString();
    }

    private static class EventPropertiesHtmlTable
    extends AbstractHtmlTable {
        EventPropertiesHtmlTable(RowSet rowSet) {
            try {
                ExtendedRowMetaData meta = new ExtendedRowMetaData();
                for (int i = 1; i <= rowSet.getRowMetaData().getColumnCount(); ++i) {
                    meta.addColumn(rowSet.getRowMetaData().getColumnName(i), ExtendedRowMetaData.Align.LEFT);
                }
                this.table = new RowSet(meta);
                while (rowSet.next()) {
                    Object[] rowValues = new Object[meta.getColumnCount()];
                    for (int i = 1; i <= meta.getColumnCount(); ++i) {
                        rowValues[i - 1] = rowSet.getObject(i);
                    }
                    this.table.addToRowSet(rowValues);
                }
            }
            catch (Exception exception) {
                Trace.logException(this, exception, true);
            }
        }

        @Override
        public String getTitle() {
            return null;
        }

        @Override
        public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
            throw new Exception("init method not allowed for EventPropertiesHtmlTable");
        }
    }
}

