/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.html;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.omf.odata.v4.server.jdbc.ODataHelper;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.http.HTTPRequest;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dataspace.DataspaceComponent;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptorConfiguration;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerConfiguration;
import com.streamscape.sef.network.http.server.apicustomizer.CustomizedRequestBuilder;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.AbstractDataspaceRule;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.AbstractDataspaceRuleParametersResolver;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceAnyStatementRule;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceAnyStatementRuleParametersResolver;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceAnyStatementRuleWrapper;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceCollectionRule;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceCollectionRuleParametersResolver;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceCollectionRuleWrapper;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceFunctionRule;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceFunctionRuleParametersResolver;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceFunctionRuleWrapper;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceODataRule;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceODataRuleParametersResolver;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceODataRuleWrapper;
import com.streamscape.sef.network.http.server.authentication.XSessionAuthenticator;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.html.AbstractHtmlPage;
import com.streamscape.sef.network.http.server.html.AbstractHtmlTable;
import com.streamscape.sef.network.http.server.html.ComplexToken;
import com.streamscape.sef.network.http.server.html.ExtendedRowMetaData;
import com.streamscape.sef.network.http.server.html.HTTPRequestHtmlBuilder;
import com.streamscape.sef.network.http.server.html.HtmlCodeToken;
import com.streamscape.sef.network.http.server.html.HtmlTokenFormatter;
import com.streamscape.sef.network.http.server.html.ImageToken;
import com.streamscape.sef.network.http.server.html.LinkToken;
import com.streamscape.sef.network.http.server.html.PropertiesHtmlTable;
import com.streamscape.sef.network.http.server.html.RowSetHtmlFormatter;
import com.streamscape.sef.network.http.server.html.SemanticTypeLink;
import com.streamscape.sef.network.http.server.html.ServiceHtml;
import com.streamscape.sef.network.http.server.html.SorHtml;
import com.streamscape.sef.network.http.server.html.Token;
import com.streamscape.sef.network.http.server.servlet.SorServletCss;
import com.streamscape.sef.network.http.server.servlet.SorUriRegistry;
import com.streamscape.sef.network.http.server.swagger.clientgen.SwaggerClientGenResource;
import com.streamscape.sef.network.http.server.swagger.clientgen.SwaggerClientGenServiceIml;
import com.streamscape.sef.network.http.server.uri.UriUtils;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import java.util.Base64;
import java.util.List;
import java.util.Map;

public class DataspacesHtmlTable
extends AbstractHtmlTable {
    public static String COLUMN_DATASPACE_NAME = "Name";
    public static String COLUMN_DATASPACE_TYPE = "Type";
    public static String COLUMN_DATASPACE_METADATA = "Open Data";
    public static String COLUMN_DATASPACE_SWAGGER = "Swagger.io";
    public static String COLUMN_DATASPACE_SWAGGER_CUSTOMIZED = "Customized Swagger.io";
    public static ImageToken ODATA_V4_IMAGE = new ImageToken("/public/images/odata_v4.png");
    public static ImageToken SWAGGER_IMAGE = new ImageToken("/public/images/swagger.png");

    public DataspacesHtmlTable() throws Exception {
        ExtendedRowMetaData meta = new ExtendedRowMetaData();
        meta.addColumn(COLUMN_DATASPACE_NAME, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_DATASPACE_TYPE, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_DATASPACE_METADATA, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_DATASPACE_SWAGGER, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_DATASPACE_SWAGGER_CUSTOMIZED, ExtendedRowMetaData.Align.LEFT);
        this.table = new RowSet(meta);
    }

    @Override
    public String getTitle() {
        return "Dataspaces";
    }

    @Override
    public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
        String tokenId = DataspacesHtmlTable.getXSessionTokenId(url);
        for (DataspaceComponent component : runtime.getDataspaceManager().getDataspaces()) {
            if (component.getDataspaceType() == DataspaceType.TSPACE && (component.getName().equalsIgnoreCase("SDS") || component.getName().equalsIgnoreCase("SCH") || component.getName().equalsIgnoreCase("SYS") || component.getName().equalsIgnoreCase("SYS_LOBS") || component.getName().equalsIgnoreCase("SYS_FLOBS"))) continue;
            String dataspaceFullName = component.getDataspaceType().toString() + "." + component.getName();
            this.table.addToRowSet(new Object[]{new DataspaceLink(dataspaceFullName, component.getName()), component.getDataspaceType().toString(), new DataspaceOdataLinksWithImage(dataspaceFullName, tokenId), new DataspaceSwaggerLinkWithImage(dataspaceFullName, tokenId, false), new DataspaceSwaggerLinkWithImage(dataspaceFullName, tokenId, true)});
        }
    }

    private static String getXSessionTokenId(FabricHTTPRequest url) {
        return XSessionAuthenticator.getTokenIfAuthenticated(url.getRequest());
    }

    protected static String getSLResponseError(SLResponse response) {
        if (response.isOK()) {
            return null;
        }
        if (response.getText() != null) {
            return response.getText();
        }
        if (response.getException() != null) {
            return response.getException().getMessage();
        }
        return null;
    }

    private static RowSet convertRowSetResolveTypeLinks(RuntimeContext runtime, RowSet rowSet) {
        try {
            RowMetaData meta = rowSet.getMeta();
            RowMetaData newMeta = new RowMetaData();
            for (int i = 1; i <= meta.getColumnCount(); ++i) {
                if (meta.getColumnName(i).equalsIgnoreCase("Type")) {
                    newMeta.addColumn(meta.getColumnName(i), Object.class);
                    continue;
                }
                newMeta.addColumn(meta.getColumnDescriptor(i));
            }
            RowSet newRowSet = new RowSet(newMeta);
            while (rowSet.next()) {
                Row row = rowSet.getCurrentRow();
                Row newRow = newRowSet.newRow();
                for (int i = 1; i <= row.getColumnCount(); ++i) {
                    Object value = row.getColumn(i);
                    if (meta.getColumnName(i).equalsIgnoreCase("Type") && runtime.getSemanticTypeCache().existsSemanticType((String)value)) {
                        value = new SemanticTypeLink((String)value);
                    }
                    newRow.setColumn(i, value);
                }
                newRowSet.addToRowSet(newRow);
            }
            return newRowSet;
        }
        catch (Exception exception) {
            Trace.logError(DataspacesHtmlTable.class, "Failed to convert row set. Cause: " + exception.getMessage());
            return rowSet;
        }
    }

    static RowSet createRowSetForCalls() {
        return DataspacesHtmlTable.createRowSetForCalls(false);
    }

    private static RowSet createRowSetForCallsWithDesc() {
        return DataspacesHtmlTable.createRowSetForCalls(true);
    }

    private static RowSet createRowSetForCalls(boolean withDesc) {
        ExtendedRowMetaData meta = new ExtendedRowMetaData();
        if (withDesc) {
            meta.addColumn("Description", ExtendedRowMetaData.Align.LEFT);
        }
        meta.addColumn("Method", ExtendedRowMetaData.Align.LEFT);
        meta.addColumn("Uri", ExtendedRowMetaData.Align.LEFT);
        return new RowSet(meta);
    }

    static void addCallToRowSet(RowSet rowSet, HTTPRequest request) {
        DataspacesHtmlTable.addCallToRowSet(rowSet, request, null);
    }

    private static void addCallToRowSet(RowSet rowSet, HTTPRequest request, String description) {
        DataspacesHtmlTable.addCallToRowSet(rowSet, request.getMethod(), new HTTPRequestHtmlBuilder().buildToken(request), description);
    }

    static void addCallToRowSet(RowSet rowSet, String method, Object uri) {
        DataspacesHtmlTable.addCallToRowSet(rowSet, method, uri, null);
    }

    private static void addCallToRowSet(RowSet rowSet, String method, Object uri, String description) {
        try {
            Row row = rowSet.newRow();
            if (description != null) {
                row.setColumn("Description", (Object)description);
            }
            row.setColumn("Method", (Object)method.toUpperCase());
            row.setColumn("Uri", uri);
            rowSet.addToRowSet(row);
        }
        catch (Exception exception) {
            Trace.logError(DataspacesHtmlTable.class, "Failed to add row to row set.");
            Trace.logException(DataspacesHtmlTable.class, exception, true);
        }
    }

    private static String makeCallsDiv(String header, RowSet rowSet) {
        StringBuilder builder = new StringBuilder();
        builder.append("<div class=\"" + SorServletCss.DEFAULT_DIV_STYLE + "\">\n");
        builder.append("<br>").append(SorServletCss.bold(header)).append("<br><br>");
        builder.append(DataspacesHtmlTable.makeCallsTable(rowSet));
        builder.append("</div>");
        return builder.toString();
    }

    static String makeCallsTable(RowSet rowSet) {
        return new RowSetHtmlFormatter(SorServletCss.TABLE_DATASPACE_REST_CALL_STYLE, SorServletCss.TABLE_DATASPACE_REST_CALL_STYLE_ALT).formatHorizontal(rowSet, false);
    }

    @Override
    public String getHtml() {
        return super.getHtml() + DataspacesHtmlTable.getOdataUrlPopupStyles();
    }

    private static String getOdataUrlPopupStyles() {
        return "<style>\n.b-popup{\nwidth:100%;\nmin-height:100%;\nbackground-color: rgba(0,0,0,0.5);\noverflow:hidden;\nposition:fixed;\ntop:0px;\n}\n.b-popup .b-popup-content{\nposition: absolute;top: 200px;left: 200px;width:300px;\nheight: 30px;\npadding:10px;\nbackground-color: #c5c5c5;\nborder-radius:5px;\nbox-shadow: 0px 0px 10px #000;\n}\n.b-popup .close{\nposition: absolute;\ntop: 180px;\nleft: 500px;\ntransition: all 200ms;\nfont-size: 20px;\ntext-decoration: none;\ncolor: #333;\n}\n</style>\n<div class='b-popup' id='odata-url-popup' style='display:none'>\n<a class='close' onclick='odataUrlPopupHide()' href='javascript:return false;'>x</a>\n<input class='b-popup-content' type='text' id='odata-url-popup-content-url' readonly></input>\n</div>\n<script type='text/javascript'>\nodataUrlPopupHide();\nfunction odataUrlPopupShow(text){\ndocument.getElementById('odata-url-popup').style.display = 'block';\ndocument.getElementById('odata-url-popup-content-url').value = text;\n}\nfunction odataUrlPopupHide(){\ndocument.getElementById('odata-url-popup').style.display = 'none';\n}\n</script>\n";
    }

    public static class DataspaceLink
    extends LinkToken {
        public DataspaceLink(String dataspaceName) {
            this(dataspaceName, dataspaceName);
        }

        public DataspaceLink(String dataspaceName, String displayName) {
            super(SorUriRegistry.registry().formatFullUri(DataspaceHtml.class, dataspaceName), displayName);
        }
    }

    public static class DataspaceOdataLinksWithImage
    extends ComplexToken {
        public DataspaceOdataLinksWithImage(String dataspaceName, String tokenId) {
            this.append(ODATA_V4_IMAGE);
            this.append(new DataspaceOdataLink(dataspaceName).addXSessionTokenParameter(tokenId)).append(" ");
            this.append(new DataspaceOdataUrl(dataspaceName)).append(" ");
            this.append(new DataspaceOdataMetadataLink(dataspaceName).addXSessionTokenParameter(tokenId));
        }
    }

    public static class DataspaceSwaggerLinkWithImage
    extends SwaggerLinkWithImage {
        public DataspaceSwaggerLinkWithImage(String dataspaceName, String tokenId, boolean customized) {
            super(new DataspaceSwaggerJsonLink(dataspaceName, customized).addXSessionTokenParameter(tokenId), new DataspaceSwaggerYamlLink(dataspaceName, customized).addXSessionTokenParameter(tokenId), new DataspaceSwaggerUiLink(dataspaceName, tokenId, customized), new SwaggerClientDownloadLink(new DataspaceSwaggerJsonLink(dataspaceName, customized).addXSessionTokenParameter(tokenId), dataspaceName));
        }
    }

    public static class DataspaceActorHtml
    extends AbstractDataspaceHtml {
        protected String actorName;
        protected String actorDefinition;
        protected String actorDescription;
        protected RowSet actorProperties;
        protected RowSet actorEvents;

        @Override
        public String getTitle() {
            return "Actor: " + this.actorName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
            block11: {
                super.init(runtime, connection, url);
                this.actorName = url.getUriParameterOrThrowException("actorName");
                DataspaceAccessor accessor = DataspaceParsedName.getDataspaceAccessor(connection, url);
                try {
                    SLResponse response = accessor.invokeLanguageRequest("describe actor " + this.actorName + " definition no doc");
                    if (!response.isOK()) {
                        throw new Exception(DataspacesHtmlTable.getSLResponseError(response));
                    }
                    response.getRowSet().next();
                    this.actorDefinition = response.getRowSet().getString(1);
                    response = accessor.invokeLanguageRequest("describe actor " + this.actorName + " doc");
                    if (!response.isOK()) {
                        throw new Exception(DataspacesHtmlTable.getSLResponseError(response));
                    }
                    response.getRowSet().next();
                    this.actorDescription = response.getRowSet().getString(1);
                    response = accessor.invokeLanguageRequest("describe actor " + this.actorName + " properties");
                    if (!response.isOK()) {
                        throw new Exception(DataspacesHtmlTable.getSLResponseError(response));
                    }
                    this.actorProperties = response.getRowSet();
                    response = accessor.invokeLanguageRequest("describe actor " + this.actorName + " events");
                    if (response.isOK()) {
                        this.actorEvents = response.getRowSet();
                        break block11;
                    }
                    throw new Exception(DataspacesHtmlTable.getSLResponseError(response));
                }
                finally {
                    try {
                        accessor.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        @Override
        public String getHtml() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getHeaderHtml());
            PropertiesHtmlTable properties = new PropertiesHtmlTable();
            properties.initFrom(this.actorProperties);
            builder.append(properties.getHtml());
            builder.append(SorServletCss.subheader("Documentation"));
            builder.append(SorServletCss.makeJavaDocHtm(this.actorDescription, this.dataspaceParsedName.dataspaceType, this.dataspaceParsedName.dataspaceName));
            builder.append(SorServletCss.subheader("Events"));
            builder.append(new RowSetHtmlFormatter(SorServletCss.TABLE_LIST_STYLE, SorServletCss.TABLE_LIST_STYLE_ALT).formatHorizontal(this.actorEvents));
            builder.append(SorServletCss.subheader("Definition"));
            builder.append(SorServletCss.hightlightCodeSQL(this.actorDefinition)).append("\n");
            return builder.toString();
        }
    }

    public static class DataspaceActorsHtmlTable
    extends AbstractDataspaceHtmlTable {
        @Override
        public String getTitle() {
            return super.getTitle() + " Actors";
        }

        @Override
        protected void onInit(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url, DataspaceAccessor accessor) throws Exception {
            SLResponse response = accessor.invokeLanguageRequest("list actors");
            if (!response.isOK()) {
                throw new Exception(DataspacesHtmlTable.getSLResponseError(response));
            }
            RowSet rowSet = response.getRowSet();
            this.initTableDataFrom(rowSet);
            this.table.beforeFirst();
            while (this.table.next()) {
                Row row = this.table.getCurrentRow();
                row.setColumn(1, (Object)new DataspaceActorLink(this.dataspaceParsedName.dataspaceFullName, this.table.getString(1)));
            }
            this.table.beforeFirst();
        }

        public static class DataspaceActorLink
        extends LinkToken {
            public DataspaceActorLink(String dataspaceName, String actorName) {
                super(SorUriRegistry.registry().formatFullUri(DataspaceActorHtml.class, dataspaceName, actorName), actorName);
            }
        }
    }

    public static class DataspaceEventTriggerHtml
    extends AbstractDataspaceHtml {
        protected String triggerName;
        protected String triggerDefinition;
        protected String triggerDescription;
        protected RowSet triggerProperties;
        protected RowSet triggerEvents;

        @Override
        public String getTitle() {
            return "Event Trigger: " + this.triggerName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
            block11: {
                super.init(runtime, connection, url);
                this.triggerName = url.getUriParameterOrThrowException("triggerName");
                DataspaceAccessor accessor = DataspaceParsedName.getDataspaceAccessor(connection, url);
                try {
                    SLResponse response = accessor.invokeLanguageRequest("describe event trigger " + this.triggerName + " definition no doc");
                    if (!response.isOK()) {
                        throw new Exception(DataspacesHtmlTable.getSLResponseError(response));
                    }
                    response.getRowSet().next();
                    this.triggerDefinition = response.getRowSet().getString(1);
                    response = accessor.invokeLanguageRequest("describe event trigger " + this.triggerName + " doc");
                    if (!response.isOK()) {
                        throw new Exception(DataspacesHtmlTable.getSLResponseError(response));
                    }
                    response.getRowSet().next();
                    this.triggerDescription = response.getRowSet().getString(1);
                    response = accessor.invokeLanguageRequest("describe event trigger " + this.triggerName + " properties");
                    if (!response.isOK()) {
                        throw new Exception(DataspacesHtmlTable.getSLResponseError(response));
                    }
                    this.triggerProperties = response.getRowSet();
                    response = accessor.invokeLanguageRequest("describe event trigger " + this.triggerName + " events");
                    if (response.isOK()) {
                        this.triggerEvents = response.getRowSet();
                        break block11;
                    }
                    throw new Exception(DataspacesHtmlTable.getSLResponseError(response));
                }
                finally {
                    try {
                        accessor.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        @Override
        public String getHtml() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getHeaderHtml());
            PropertiesHtmlTable properties = new PropertiesHtmlTable();
            properties.initFrom(this.triggerProperties);
            builder.append(properties.getHtml());
            builder.append(SorServletCss.subheader("Documentation"));
            builder.append(SorServletCss.makeJavaDocHtm(this.triggerDescription, this.dataspaceParsedName.dataspaceType, this.dataspaceParsedName.dataspaceName));
            builder.append(SorServletCss.subheader("Events"));
            builder.append(new RowSetHtmlFormatter(SorServletCss.TABLE_LIST_STYLE, SorServletCss.TABLE_LIST_STYLE_ALT).formatHorizontal(this.triggerEvents));
            builder.append(SorServletCss.subheader("Definition"));
            builder.append(SorServletCss.hightlightCodeSQL(this.triggerDefinition)).append("\n");
            return builder.toString();
        }
    }

    public static class DataspaceEventTriggersHtmlTable
    extends AbstractDataspaceHtmlTable {
        @Override
        public String getTitle() {
            return super.getTitle() + " event triggers";
        }

        @Override
        protected void onInit(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url, DataspaceAccessor accessor) throws Exception {
            SLResponse response = accessor.invokeLanguageRequest("list event triggers");
            if (!response.isOK()) {
                throw new Exception(DataspacesHtmlTable.getSLResponseError(response));
            }
            RowSet rowSet = response.getRowSet();
            this.initTableDataFrom(rowSet);
            this.table.beforeFirst();
            while (this.table.next()) {
                Row row = this.table.getCurrentRow();
                row.setColumn(1, (Object)new DataspaceEventTriggerLink(this.dataspaceParsedName.dataspaceFullName, this.table.getString(1)));
            }
            this.table.beforeFirst();
        }

        public static class DataspaceEventTriggerLink
        extends LinkToken {
            public DataspaceEventTriggerLink(String dataspaceName, String triggerName) {
                super(SorUriRegistry.registry().formatFullUri(DataspaceEventTriggerHtml.class, dataspaceName, triggerName), triggerName);
            }
        }
    }

    public static class DataspaceTimerHtml
    extends AbstractDataspaceHtml {
        protected String timerName;
        protected PropertiesHtmlTable properties;

        @Override
        public String getTitle() {
            return "Timer: " + this.timerName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
            super.init(runtime, connection, url);
            this.timerName = url.getUriParameterOrThrowException("timerName");
            DataspaceAccessor accessor = DataspaceParsedName.getDataspaceAccessor(connection, url);
            try {
                SLResponse response = accessor.invokeLanguageRequest("describe timer " + this.timerName);
                if (!response.isOK()) {
                    throw new Exception(DataspacesHtmlTable.getSLResponseError(response));
                }
                this.properties = new PropertiesHtmlTable();
                RowSet rowSet = response.getRowSet();
                while (rowSet.next()) {
                    this.properties.addIfNotNull(rowSet.getString(1), rowSet.getString(2));
                }
                this.properties.addIfNotNull("Dataspace Name", this.dataspaceParsedName.dataspaceName);
                this.properties.addIfNotNull("Dataspace Type", this.dataspaceParsedName.dataspaceType.toString());
            }
            finally {
                try {
                    accessor.close();
                }
                catch (Exception exception) {}
            }
        }

        @Override
        public String getHtml() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getHeaderHtml());
            builder.append(this.properties.getHtml());
            return builder.toString();
        }
    }

    public static class DataspaceTimersHtmlTable
    extends AbstractDataspaceHtmlTable {
        public static String COLUMN_DATASPACE_TIMER_NAME = "Name";
        public static String COLUMN_DATASPACE_TIMER_GROUP = "Group";

        public DataspaceTimersHtmlTable() throws Exception {
            ExtendedRowMetaData meta = new ExtendedRowMetaData();
            meta.addColumn(COLUMN_DATASPACE_TIMER_NAME, ExtendedRowMetaData.Align.LEFT);
            meta.addColumn(COLUMN_DATASPACE_TIMER_GROUP, ExtendedRowMetaData.Align.LEFT);
            this.table = new RowSet(meta);
        }

        @Override
        public String getTitle() {
            return super.getTitle() + " timers";
        }

        @Override
        protected void onInit(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url, DataspaceAccessor accessor) throws Exception {
            SLResponse response = accessor.invokeLanguageRequest("list timers");
            if (!response.isOK()) {
                throw new Exception(DataspacesHtmlTable.getSLResponseError(response));
            }
            RowSet rowSet = response.getRowSet();
            while (response.getRowSet().next()) {
                this.table.addToRowSet(new Object[]{new DataspaceTimerLink(this.dataspaceParsedName.dataspaceFullName, rowSet.getString(1)), rowSet.getString(2)});
            }
        }

        public static class DataspaceTimerLink
        extends LinkToken {
            public DataspaceTimerLink(String dataspaceName, String timerName) {
                super(SorUriRegistry.registry().formatFullUri(DataspaceTimerHtml.class, dataspaceName, timerName), timerName);
            }
        }
    }

    public static class DataspaceCollectionHtml
    extends AbstractDataspaceHtml {
        protected String collectionName;
        protected String collectionType;
        protected String collectionMemoryModel;
        protected RowSet tuples;

        @Override
        public String getTitle() {
            return "Collection: " + this.collectionName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
            super.init(runtime, connection, url);
            this.collectionName = url.getUriParameterOrThrowException("collectionName");
            DataspaceAccessor accessor = DataspaceParsedName.getDataspaceAccessor(connection, url);
            try {
                SLResponse response = accessor.invokeLanguageRequest("describe collection [" + this.collectionName + "]");
                if (!response.isOK()) {
                    throw new Exception(DataspacesHtmlTable.getSLResponseError(response));
                }
                response.getRowSet().next();
                response.getRowSet().next();
                this.collectionType = response.getRowSet().getString(2);
                response.getRowSet().next();
                this.collectionMemoryModel = response.getRowSet().getString(2);
                response = accessor.invokeLanguageRequest("describe collection [" + this.collectionName + "] tuples");
                if (!response.isOK()) {
                    throw new Exception(DataspacesHtmlTable.getSLResponseError(response));
                }
                this.tuples = DataspacesHtmlTable.convertRowSetResolveTypeLinks(runtime, response.getRowSet());
            }
            finally {
                try {
                    accessor.close();
                }
                catch (Exception exception) {}
            }
        }

        @Override
        public String getHtml() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getHeaderHtml());
            PropertiesHtmlTable properties = new PropertiesHtmlTable();
            properties.addIfNotNull("Collection Name", this.collectionName);
            properties.addIfNotNull("Collection Type", this.collectionType);
            properties.addIfNotNull("Memory Model", this.collectionMemoryModel);
            properties.addIfNotNull("Dataspace Name", this.dataspaceParsedName.dataspaceName);
            properties.addIfNotNull("Dataspace Type", this.dataspaceParsedName.dataspaceType.toString());
            builder.append(properties.getHtml());
            builder.append(SorServletCss.subheader("Tuples"));
            builder.append(new RowSetHtmlFormatter(SorServletCss.TABLE_LIST_STYLE, SorServletCss.TABLE_LIST_STYLE_ALT).formatHorizontal(this.tuples));
            builder.append(this.makeDataspaceRestCallHtml());
            builder.append(this.makeDataspaceCustomizedCalls());
            builder.append(this.makeOdataCallHtml());
            builder.append(this.makeODataCustomizedCalls());
            return builder.toString();
        }

        private String makeDataspaceRestCallHtml() {
            RowSet rowSet = DataspacesHtmlTable.createRowSetForCallsWithDesc();
            try {
                String uri;
                String uriPrefix = "/ds/" + this.dataspaceParsedName.dataspaceFullName;
                if (this.collectionType.toLowerCase().endsWith("queue")) {
                    uri = uriPrefix + "/" + UriUtils.encode(this.collectionName) + "?responseFormat=json";
                    DataspacesHtmlTable.addCallToRowSet(rowSet, "GET", new LinkToken(uri, uri), "READ");
                } else {
                    uri = uriPrefix + "/" + UriUtils.encode(this.collectionName) + "?*&responseFormat=html";
                    DataspacesHtmlTable.addCallToRowSet(rowSet, "GET", new LinkToken(uri, uri), "SELECT");
                }
                uri = uriPrefix + "/dsql?q=delete from [" + this.collectionName + "]&responseFormat=json";
                DataspacesHtmlTable.addCallToRowSet(rowSet, "GET", new LinkToken(uri, uri), "DELETE");
                StringBuilder uriBuilder = new StringBuilder(uriPrefix + "/dsql?q=insert into [" + this.collectionName + "] (");
                StringBuilder valuesBuilder = new StringBuilder("values(");
                this.tuples.beforeFirst();
                boolean first = true;
                while (this.tuples.next()) {
                    if (!first) {
                        uriBuilder.append(",");
                        valuesBuilder.append(",");
                    }
                    first = false;
                    uriBuilder.append(this.tuples.getString(1));
                    valuesBuilder.append("<value>");
                }
                uriBuilder.append(") ");
                valuesBuilder.append(") ");
                uriBuilder.append(valuesBuilder.toString());
                DataspacesHtmlTable.addCallToRowSet(rowSet, "GET", new LinkToken(uriBuilder.toString(), uriBuilder.toString()), "INSERT");
            }
            catch (Exception exception) {
                Trace.logException(this, exception, false);
            }
            return DataspacesHtmlTable.makeCallsDiv("Native Dataspace REST Calls", rowSet);
        }

        private String makeDataspaceCustomizedCalls() {
            if (this.apiCustomizerConfiguration != null) {
                RowSet rowSet = DataspacesHtmlTable.createRowSetForCallsWithDesc();
                for (AbstractDataspaceRule rule : this.apiCustomizerConfiguration.listDataspaceRules()) {
                    AbstractDataspaceRuleParametersResolver resolver = null;
                    try {
                        if (rule instanceof DataspaceCollectionRule) {
                            wrapper = (DataspaceCollectionRuleWrapper)rule.createWrapper();
                            resolver = new DataspaceCollectionRuleParametersResolver((DataspaceCollectionRuleWrapper)wrapper){

                                @Override
                                protected String onGetDataspaceName() {
                                    return dataspaceParsedName.dataspaceFullName;
                                }

                                @Override
                                protected String onGetCollectionName(String parameterName) {
                                    return collectionName;
                                }

                                @Override
                                protected String onGetColumn(String name) {
                                    return "<column " + name + ">";
                                }

                                @Override
                                protected String onGetSelector(String parameterName) {
                                    return "<selector>";
                                }
                            };
                        } else if (rule instanceof DataspaceAnyStatementRule) {
                            wrapper = (DataspaceAnyStatementRuleWrapper)rule.createWrapper();
                            resolver = new DataspaceAnyStatementRuleParametersResolver((DataspaceAnyStatementRuleWrapper)wrapper){

                                @Override
                                protected String onGetDataspaceName() {
                                    return dataspaceParsedName.dataspaceFullName;
                                }

                                @Override
                                protected String onGetDsqlQuery() {
                                    return "<dsql query>";
                                }
                            };
                        }
                        if (resolver == null || !resolver.accepts()) continue;
                        HTTPRequest request = new CustomizedRequestBuilder(resolver.getWrapper()).build(resolver);
                        String description = rule instanceof DataspaceCollectionRule ? ((DataspaceCollectionRule)rule).getOperation().toString() : "Any Statement";
                        DataspacesHtmlTable.addCallToRowSet(rowSet, request, description);
                    }
                    catch (Exception exception) {
                        Trace.logError(this, "Failed to handle dataspace rule: " + String.valueOf(rule) + ". Cause: " + exception.getMessage());
                    }
                }
                if (rowSet.getRowCount() > 0) {
                    return DataspacesHtmlTable.makeCallsDiv("Public Dataspace REST Calls", rowSet);
                }
            }
            return "";
        }

        private String makeOdataCallHtml() {
            RowSet rowSet = DataspacesHtmlTable.createRowSetForCallsWithDesc();
            try {
                String uriPrefix = "/odata/v4/" + this.dataspaceParsedName.dataspaceFullName + "/" + ODataHelper.encodeEntityName((String)this.collectionName);
                DataspacesHtmlTable.addCallToRowSet(rowSet, "GET", new LinkToken(uriPrefix, uriPrefix), "SELECT ALL");
                String uri = uriPrefix + "?$top=1&$skip=1";
                DataspacesHtmlTable.addCallToRowSet(rowSet, "GET", new LinkToken(uri, uri), "SELECT TOP 1 SKIP 1");
                uri = uriPrefix + "?$select=";
                this.tuples.beforeFirst();
                while (this.tuples.next()) {
                    if (!uri.endsWith("=")) {
                        uri = uri + ",";
                    }
                    uri = uri + this.tuples.getString(1);
                }
                this.tuples.beforeFirst();
                DataspacesHtmlTable.addCallToRowSet(rowSet, "GET", new LinkToken(uri, uri), "SELECT COLUMNS");
            }
            catch (Exception exception) {
                Trace.logException(ServiceHtml.class, exception, false);
            }
            return DataspacesHtmlTable.makeCallsDiv("OData Calls", rowSet);
        }

        private String makeODataCustomizedCalls() {
            if (this.apiCustomizerConfiguration != null) {
                RowSet rowSet = DataspacesHtmlTable.createRowSetForCallsWithDesc();
                for (AbstractDataspaceRule rule : this.apiCustomizerConfiguration.listDataspaceRules()) {
                    AbstractDataspaceRuleParametersResolver resolver = null;
                    try {
                        if (rule instanceof DataspaceODataRule) {
                            DataspaceODataRuleWrapper wrapper = (DataspaceODataRuleWrapper)rule.createWrapper();
                            resolver = new DataspaceODataRuleParametersResolver(wrapper){

                                @Override
                                protected String onGetDataspaceName() {
                                    return dataspaceParsedName.dataspaceFullName;
                                }

                                @Override
                                protected String onGetODataTail() {
                                    return "/" + collectionName;
                                }
                            };
                        }
                        if (resolver == null || !resolver.accepts()) continue;
                        HTTPRequest request = new CustomizedRequestBuilder(resolver.getWrapper()).build(resolver);
                        DataspacesHtmlTable.addCallToRowSet(rowSet, request, "SELECT");
                    }
                    catch (Exception exception) {
                        Trace.logError(this, "Failed to handle dataspace rule: " + String.valueOf(rule) + ". Cause: " + exception.getMessage());
                    }
                }
                if (rowSet.getRowCount() > 0) {
                    return DataspacesHtmlTable.makeCallsDiv("Public OData Calls", rowSet);
                }
            }
            return "";
        }
    }

    public static class DataspaceCollectionsHtmlTable
    extends AbstractDataspaceHtmlTable {
        public static String COLUMN_DATASPACE_COLLECTION_NAME = "Name";
        public static String COLUMN_DATASPACE_COLLECTION_TYPE = "Type";
        public static String COLUMN_DATASPACE_COLLECTION_MODEL = "Memory Model";

        public DataspaceCollectionsHtmlTable() throws Exception {
            ExtendedRowMetaData meta = new ExtendedRowMetaData();
            meta.addColumn(COLUMN_DATASPACE_COLLECTION_NAME, ExtendedRowMetaData.Align.LEFT);
            meta.addColumn(COLUMN_DATASPACE_COLLECTION_TYPE, ExtendedRowMetaData.Align.LEFT);
            meta.addColumn(COLUMN_DATASPACE_COLLECTION_MODEL, ExtendedRowMetaData.Align.LEFT);
            this.table = new RowSet(meta);
        }

        @Override
        public String getTitle() {
            return super.getTitle() + " collections";
        }

        @Override
        protected void onInit(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url, DataspaceAccessor accessor) throws Exception {
            for (String collectionName : accessor.listCollections()) {
                SLResponse response = accessor.invokeLanguageRequest("describe collection [" + collectionName + "]");
                if (!response.isOK()) {
                    throw new Exception(DataspacesHtmlTable.getSLResponseError(response));
                }
                response.getRowSet().next();
                response.getRowSet().next();
                String collectionType = response.getRowSet().getString(2);
                response.getRowSet().next();
                String collectionMemoryModel = response.getRowSet().getString(2);
                this.table.addToRowSet(new Object[]{new DataspaceCollectionLink(this.dataspaceParsedName.dataspaceFullName, collectionName), collectionType, collectionMemoryModel});
            }
        }

        public static class DataspaceCollectionLink
        extends LinkToken {
            public DataspaceCollectionLink(String dataspaceName, String collectionName) {
                super(SorUriRegistry.registry().formatFullUri(DataspaceCollectionHtml.class, dataspaceName, collectionName), collectionName);
            }
        }
    }

    public static class DataspaceFunctionHtml
    extends AbstractDataspaceHtml {
        protected String functionName;
        protected String functionDefinition;
        protected String functionDescription;
        protected RowSet parameters;

        @Override
        public String getTitle() {
            return "Function: " + this.functionName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
            super.init(runtime, connection, url);
            this.functionName = url.getUriParameterOrThrowException("functionName");
            DataspaceAccessor accessor = DataspaceParsedName.getDataspaceAccessor(connection, url);
            try {
                SLResponse response = accessor.invokeLanguageRequest("describe function " + this.functionName + " definition no doc");
                if (!response.isOK()) {
                    throw new Exception(DataspacesHtmlTable.getSLResponseError(response));
                }
                response.getRowSet().next();
                this.functionDefinition = response.getRowSet().getString(1);
                response = accessor.invokeLanguageRequest("describe function " + this.functionName + " doc");
                if (!response.isOK()) {
                    throw new Exception(DataspacesHtmlTable.getSLResponseError(response));
                }
                response.getRowSet().next();
                this.functionDescription = response.getRowSet().getString(1);
                response = accessor.invokeLanguageRequest("describe function " + this.functionName + " parameters");
                if (!response.isOK()) {
                    throw new Exception(DataspacesHtmlTable.getSLResponseError(response));
                }
                this.parameters = DataspacesHtmlTable.convertRowSetResolveTypeLinks(runtime, response.getRowSet());
            }
            finally {
                try {
                    accessor.close();
                }
                catch (Exception exception) {}
            }
        }

        @Override
        public String getHtml() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getHeaderHtml());
            PropertiesHtmlTable properties = new PropertiesHtmlTable();
            properties.addIfNotNull("Function Name", this.functionName);
            properties.addIfNotNull("Dataspace Name", this.dataspaceParsedName.dataspaceName);
            properties.addIfNotNull("Dataspace Type", this.dataspaceParsedName.dataspaceType.toString());
            builder.append(properties.getHtml());
            builder.append(SorServletCss.subheader("Documentation"));
            builder.append(SorServletCss.makeJavaDocHtm(this.functionDescription, this.dataspaceParsedName.dataspaceType, this.dataspaceParsedName.dataspaceName));
            builder.append(SorServletCss.subheader("Parameters"));
            builder.append(new RowSetHtmlFormatter(SorServletCss.TABLE_LIST_STYLE, SorServletCss.TABLE_LIST_STYLE_ALT).formatHorizontal(this.parameters));
            builder.append(SorServletCss.subheader("Definition"));
            builder.append(SorServletCss.hightlightCodeSQL(this.functionDefinition)).append("\n");
            builder.append(this.makeDataspaceFunctionNativeCallHtml());
            builder.append(this.makeDataspaceFunctionCustomizedCallsHtml());
            builder.append(this.makeDataspaceFunctionOdataCallHtml());
            builder.append(this.makeDataspaceFunctionOdataCustomizedCallsHtml());
            return builder.toString();
        }

        private String makeDataspaceFunctionNativeCallHtml() {
            RowSet rowSet = DataspacesHtmlTable.createRowSetForCalls();
            String uri = "/ds/" + this.dataspaceParsedName.dataspaceFullName + "/fn/" + this.functionName;
            try {
                this.parameters.beforeFirst();
                boolean first = true;
                while (this.parameters.next()) {
                    if (!this.parameters.getString(3).equalsIgnoreCase("IN")) continue;
                    if (first) {
                        uri = uri + "?";
                        first = false;
                    } else {
                        uri = uri + "&";
                    }
                    uri = uri + this.parameters.getString(1) + "=<value>";
                }
            }
            catch (Exception exception) {
                Trace.logError(this, exception.getMessage());
            }
            DataspacesHtmlTable.addCallToRowSet(rowSet, "GET", new LinkToken(uri, uri));
            return DataspacesHtmlTable.makeCallsDiv("Function REST Call", rowSet);
        }

        private String makeDataspaceFunctionCustomizedCallsHtml() {
            if (this.apiCustomizerConfiguration != null) {
                RowSet rowSet = DataspacesHtmlTable.createRowSetForCalls();
                for (AbstractDataspaceRule rule : this.apiCustomizerConfiguration.listDataspaceRules()) {
                    if (!(rule instanceof DataspaceFunctionRule)) continue;
                    try {
                        DataspaceFunctionRuleWrapper wrapper = (DataspaceFunctionRuleWrapper)rule.createWrapper();
                        DataspaceFunctionRuleParametersResolver resolver = new DataspaceFunctionRuleParametersResolver(wrapper){

                            @Override
                            protected String onGetDataspaceName() {
                                return dataspaceParsedName.dataspaceFullName;
                            }

                            @Override
                            protected String onGetFunctionName() {
                                return functionName;
                            }

                            @Override
                            protected String onGetParameter(String name) {
                                return "<parameter " + name + ">";
                            }
                        };
                        if (!resolver.accepts()) continue;
                        HTTPRequest request = new CustomizedRequestBuilder(wrapper).build(resolver);
                        DataspacesHtmlTable.addCallToRowSet(rowSet, request);
                    }
                    catch (Exception exception) {
                        Trace.logError(this, "Failed to handle dataspace function rule: " + String.valueOf(rule) + ". Cause: " + exception.getMessage());
                    }
                }
                if (rowSet.getRowCount() > 0) {
                    return DataspacesHtmlTable.makeCallsDiv("Function Customized Call" + (rowSet.getRowCount() > 1 ? "s" : ""), rowSet);
                }
            }
            return "";
        }

        private String makeDataspaceFunctionOdataCallHtml() {
            RowSet rowSet = DataspacesHtmlTable.createRowSetForCalls();
            String uri = "/odata/v4/" + this.dataspaceParsedName.dataspaceFullName + this.buildOdataFunctionUri();
            DataspacesHtmlTable.addCallToRowSet(rowSet, "GET", new LinkToken(uri, uri));
            return DataspacesHtmlTable.makeCallsDiv("Function OData Call", rowSet);
        }

        private String buildOdataFunctionUri() {
            String uri = "/" + ODataHelper.encodeEntityName((String)this.functionName) + "(";
            try {
                this.parameters.beforeFirst();
                boolean first = true;
                while (this.parameters.next()) {
                    if (!this.parameters.getString(3).equalsIgnoreCase("IN")) continue;
                    if (first) {
                        first = false;
                    } else {
                        uri = uri + ",";
                    }
                    uri = uri + ODataHelper.encodeEntityName((String)this.parameters.getString(1)) + "=<value>";
                }
            }
            catch (Exception exception) {
                Trace.logError(this, exception.getMessage());
            }
            uri = uri + ")";
            return uri;
        }

        private String makeDataspaceFunctionOdataCustomizedCallsHtml() {
            if (this.apiCustomizerConfiguration != null) {
                RowSet rowSet = DataspacesHtmlTable.createRowSetForCalls();
                for (AbstractDataspaceRule rule : this.apiCustomizerConfiguration.listDataspaceRules()) {
                    if (!(rule instanceof DataspaceODataRule)) continue;
                    try {
                        DataspaceODataRuleWrapper wrapper = (DataspaceODataRuleWrapper)rule.createWrapper();
                        DataspaceODataRuleParametersResolver resolver = new DataspaceODataRuleParametersResolver(wrapper){

                            @Override
                            protected String onGetDataspaceName() {
                                return dataspaceParsedName.dataspaceFullName;
                            }

                            @Override
                            protected String onGetODataTail() {
                                return this.buildOdataFunctionUri();
                            }
                        };
                        if (!resolver.accepts()) continue;
                        HTTPRequest request = new CustomizedRequestBuilder(wrapper).build(resolver);
                        DataspacesHtmlTable.addCallToRowSet(rowSet, request);
                    }
                    catch (Exception exception) {
                        Trace.logError(this, "Failed to handle dataspace odata rule: " + String.valueOf(rule) + ". Cause: " + exception.getMessage());
                    }
                }
                if (rowSet.getRowCount() > 0) {
                    return DataspacesHtmlTable.makeCallsDiv("Function OData Public Calls", rowSet);
                }
            }
            return "";
        }
    }

    public static class DataspaceFunctionsHtmlTable
    extends AbstractDataspaceHtmlTable {
        public static String COLUMN_DATASPACE_FUNCTION_NAME = "Name";

        public DataspaceFunctionsHtmlTable() throws Exception {
            ExtendedRowMetaData meta = new ExtendedRowMetaData();
            meta.addColumn(COLUMN_DATASPACE_FUNCTION_NAME, ExtendedRowMetaData.Align.LEFT);
            this.table = new RowSet(meta);
        }

        @Override
        public String getTitle() {
            return super.getTitle() + " functions";
        }

        @Override
        protected void onInit(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url, DataspaceAccessor accessor) throws Exception {
            SLResponse response = accessor.invokeLanguageRequest("list functions");
            if (response.isOK()) {
                RowSet rowSet = response.getRowSet();
                while (rowSet.next()) {
                    this.table.addToRowSet(new Object[]{new DataspaceFunctionLink(this.dataspaceParsedName.dataspaceFullName, rowSet.getString(1))});
                }
            } else {
                throw new Exception(DataspacesHtmlTable.getSLResponseError(response));
            }
        }

        public static class DataspaceFunctionLink
        extends LinkToken {
            public DataspaceFunctionLink(String dataspaceName, String functionName) {
                super(SorUriRegistry.registry().formatFullUri(DataspaceFunctionHtml.class, dataspaceName, functionName), functionName);
            }
        }
    }

    public static class DataspaceHtml
    extends AbstractDataspaceHtml {
        @Override
        public String getTitle() {
            return "Dataspace: " + this.dataspaceParsedName.dataspaceFullName;
        }

        @Override
        public String getHtml() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getHeaderHtml());
            HtmlTokenFormatter formatter = new HtmlTokenFormatter();
            builder.append(new SorHtml.PageLinkWithImage("User Functions", DataspaceFunctionsHtmlTable.class, this.dataspaceParsedName.dataspaceFullName).format(formatter)).append("<br>");
            builder.append(new SorHtml.PageLinkWithImage("Collections", DataspaceCollectionsHtmlTable.class, this.dataspaceParsedName.dataspaceFullName).format(formatter)).append("<br>");
            builder.append(new SorHtml.PageLinkWithImage("Event Triggers", DataspaceEventTriggersHtmlTable.class, this.dataspaceParsedName.dataspaceFullName).format(formatter)).append("<br>");
            builder.append(new SorHtml.PageLinkWithImage("Actors", DataspaceActorsHtmlTable.class, this.dataspaceParsedName.dataspaceFullName).format(formatter)).append("<br>");
            builder.append(new SorHtml.PageLinkWithImage("Timers", DataspaceTimersHtmlTable.class, this.dataspaceParsedName.dataspaceFullName).format(formatter)).append("<br>");
            return builder.toString();
        }
    }

    public static abstract class AbstractDataspaceHtmlTable
    extends AbstractHtmlTable {
        protected DataspaceParsedName dataspaceParsedName;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
            this.dataspaceParsedName = DataspaceParsedName.parse(url);
            DataspaceAccessor accessor = DataspaceParsedName.getDataspaceAccessor(connection, url);
            try {
                this.onInit(runtime, connection, url, accessor);
            }
            finally {
                try {
                    accessor.close();
                }
                catch (Exception exception) {}
            }
        }

        protected abstract void onInit(RuntimeContext var1, HTTPServerFabricConnection var2, FabricHTTPRequest var3, DataspaceAccessor var4) throws Exception;

        @Override
        public String getTitle() {
            return "Dataspace '" + this.dataspaceParsedName.dataspaceFullName + "'";
        }
    }

    public static abstract class AbstractDataspaceHtml
    extends AbstractHtmlPage {
        protected DataspaceParsedName dataspaceParsedName;
        protected APICustomizerConfiguration apiCustomizerConfiguration;
        protected RuntimeContext runtime;

        @Override
        public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
            this.dataspaceParsedName = DataspaceParsedName.parse(url);
            this.apiCustomizerConfiguration = ((HTTPAcceptorConfiguration)url.getRequest().getServletContext().getAttribute(HTTPAcceptorConfiguration.ATTRIBUTE)).getAPICustomizerConfiguration();
            this.runtime = runtime;
        }
    }

    static class DataspaceParsedName {
        protected String nodeName;
        protected String dataspaceName;
        protected DataspaceType dataspaceType;
        protected String dataspaceFullName;

        DataspaceParsedName() {
        }

        static DataspaceParsedName parse(FabricHTTPRequest url) throws Exception {
            DataspaceParsedName parsedName = new DataspaceParsedName();
            parsedName.dataspaceFullName = url.getUriParameterOrThrowException("dataspaceName");
            List<String> names = StringUtils.split(parsedName.dataspaceFullName, '.');
            if (names.size() > 3 || names.size() < 2) {
                throw new Exception("Invalid dataspace name '" + parsedName.dataspaceFullName + "'. Should be in format [<NodeName>.]<DataspaceType>.<DataspaceName>");
            }
            int index = 0;
            if (names.size() == 3) {
                index = 1;
                parsedName.nodeName = names.get(0);
            }
            try {
                parsedName.dataspaceType = DataspaceType.valueOf(names.get(index).toUpperCase());
            }
            catch (Exception exception) {
                throw new Exception("Invalid dataspace type '" + names.get(index) + "'.");
            }
            parsedName.dataspaceName = names.get(index + 1);
            return parsedName;
        }

        static DataspaceAccessor getDataspaceAccessor(FabricConnection connection, FabricHTTPRequest url) throws Exception {
            DataspaceParsedName parsedName = DataspaceParsedName.parse(url);
            if (connection == null) {
                throw new Exception("Authorization required to perform this operation.");
            }
            DataspaceAccessor accessor = connection.createDataspaceAccessor(parsedName.nodeName, parsedName.dataspaceType, parsedName.dataspaceName);
            if (!accessor.isAvailable() || !accessor.isOpened()) {
                throw new Exception("Dataspace '" + parsedName.dataspaceFullName + "' is not available.");
            }
            return accessor;
        }
    }

    public static class RemoteDataspacesHtmlTable
    extends AbstractHtmlTable {
        public static final String COLUMN_DATASPACE_NODE_NAME = "Node";

        public RemoteDataspacesHtmlTable() throws Exception {
            ExtendedRowMetaData meta = new ExtendedRowMetaData();
            meta.addColumn(COLUMN_DATASPACE_NODE_NAME, ExtendedRowMetaData.Align.LEFT);
            meta.addColumn(COLUMN_DATASPACE_NAME, ExtendedRowMetaData.Align.LEFT);
            meta.addColumn(COLUMN_DATASPACE_TYPE, ExtendedRowMetaData.Align.LEFT);
            meta.addColumn(COLUMN_DATASPACE_METADATA, ExtendedRowMetaData.Align.LEFT);
            meta.addColumn(COLUMN_DATASPACE_SWAGGER, ExtendedRowMetaData.Align.LEFT);
            meta.addColumn(COLUMN_DATASPACE_SWAGGER_CUSTOMIZED, ExtendedRowMetaData.Align.LEFT);
            this.table = new RowSet(meta);
        }

        @Override
        public String getTitle() {
            return "Remote Dataspaces";
        }

        @Override
        public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
            String tokenId = DataspacesHtmlTable.getXSessionTokenId(url);
            for (String dataspaceName : runtime.getDataspaceManager().listRemoteDataspaces()) {
                List<String> names = ModeratorUtils.splitComponentFullName(dataspaceName);
                String dataspaceFullName = names.get(0) + "." + names.get(1) + "." + names.get(2);
                this.table.addToRowSet(new Object[]{names.get(0), new DataspaceLink(dataspaceFullName, names.get(2)), names.get(1), new DataspaceOdataLinksWithImage(dataspaceFullName, tokenId), new DataspaceSwaggerLinkWithImage(dataspaceFullName, tokenId, false), new DataspaceSwaggerLinkWithImage(dataspaceFullName, tokenId, true)});
            }
        }

        @Override
        public String getHtml() {
            return super.getHtml() + DataspacesHtmlTable.getOdataUrlPopupStyles();
        }
    }

    public static class DataspaceSwaggerUiLink
    extends SwaggerUiLink {
        public DataspaceSwaggerUiLink(String dataspaceName, String tokenId) {
            this(dataspaceName, tokenId, false);
        }

        public DataspaceSwaggerUiLink(String dataspaceName, String tokenId, boolean customized) {
            super(new DataspaceSwaggerJsonLink(dataspaceName, customized).addXSessionTokenParameter(tokenId));
        }
    }

    public static class DataspaceSwaggerYamlLink
    extends AbstractDataspaceSwaggerJsonYamlLink {
        public DataspaceSwaggerYamlLink(String dataspaceName) {
            this(dataspaceName, false);
        }

        public DataspaceSwaggerYamlLink(String dataspaceName, boolean customized) {
            super(dataspaceName, "yaml", customized);
        }
    }

    public static class DataspaceSwaggerJsonLink
    extends AbstractDataspaceSwaggerJsonYamlLink {
        public DataspaceSwaggerJsonLink(String dataspaceName) {
            this(dataspaceName, false);
        }

        public DataspaceSwaggerJsonLink(String dataspaceName, boolean customized) {
            super(dataspaceName, "json", customized);
        }
    }

    public static class AbstractDataspaceSwaggerJsonYamlLink
    extends SwaggerJsonYamlLink {
        public AbstractDataspaceSwaggerJsonYamlLink(String dataspaceName, Object formatName) {
            this(dataspaceName, formatName, false);
        }

        public AbstractDataspaceSwaggerJsonYamlLink(String dataspaceName, Object formatName, boolean customized) {
            super((customized ? API_CUSTOMIZER_SWAGGER_PREFIX : "") + "/ds/" + dataspaceName, formatName);
            this.setDownload("swagger_" + (customized ? "customized_" : "") + HTTPUtils.htmlEncode(dataspaceName, false) + "." + String.valueOf(formatName));
        }
    }

    public static class SwaggerLinkWithImage
    extends ComplexToken {
        public SwaggerLinkWithImage(LinkToken jsonLink, LinkToken yamlLink, SwaggerUiLink uiLink, Token clientDownloadLink) {
            this.append(SWAGGER_IMAGE);
            this.append(jsonLink).append(" ");
            this.append(yamlLink).append(" ");
            this.append(uiLink);
            this.append(clientDownloadLink);
        }
    }

    public static class SwaggerClientDownloadLink
    extends ComplexToken {
        public SwaggerClientDownloadLink(LinkToken link, String name) {
            this(link, name, SwaggerClientGenServiceIml.isGeneratorServiceImplExists());
        }

        public SwaggerClientDownloadLink(LinkToken link, String name, boolean enabled) {
            enabled = enabled && SwaggerClientGenServiceIml.isGeneratorServiceImplExists();
            String id = name;
            String selectId = "client_language_" + id;
            String linkId = "download_link_" + id;
            StringBuilder selectHtmlBuilder = new StringBuilder();
            selectHtmlBuilder.append("<select id='" + selectId + "'" + (enabled ? "" : "class='sor-link-inactive'") + ">\n");
            for (Map.Entry<String, String> entry : SwaggerClientGenResource.allowableLanguagesMap.entrySet()) {
                selectHtmlBuilder.append("  <option value='").append(entry.getKey()).append("'>").append(entry.getValue()).append("</option>\n");
            }
            selectHtmlBuilder.append("</select>\n<script>\n    document.getElementById('" + selectId + "').onchange = function() \n    {\n        var link1 = document.getElementById('" + linkId + "');\n        link1.href = link1.href.replace(/language=[a-z]*/i, 'language=' + this.value);\n        link1.href = link1.href.replace(/client=[a-z]*&language/i, 'client=' + this.value + '&language');\n        link1.download = link1.download.replace(/[a-z]*\\.zip/i, this.value + '.zip');    };\n</script>\n");
            HtmlCodeToken selectHtmlToken = new HtmlCodeToken(selectHtmlBuilder.toString());
            ImageToken linkImageToken = new ImageToken("/public/images/download.png");
            linkImageToken.setTitle("download client");
            LinkToken linkToken = new LinkToken("/swagger/v2/client/gen/generate?url=" + HTTPUtils.encodeString(link.getLinkTo()) + "&client=java&language=java", linkImageToken);
            linkToken.setId(linkId);
            linkToken.setDownload("swagger_client_" + name + "_java.zip");
            linkToken.setTitle("download client");
            if (!enabled) {
                linkToken.addStyle("sor-link-inactive");
                linkImageToken.addStyle("sor-link-inactive");
                linkImageToken.setTitle("stswagger-client-gen.jar is not found on classpath. Please add it as ext or lib jar to download client.");
                linkToken.setTitle("stswagger-client-gen.jar is not found on classpath. Please add it as ext or lib jar to download client.");
            }
            this.append(" | ");
            this.append(selectHtmlToken);
            this.append(linkToken);
        }
    }

    public static class SwaggerUiLink
    extends LinkToken {
        public SwaggerUiLink(LinkToken link) {
            this(link, true);
        }

        public SwaggerUiLink(LinkToken link, boolean enabled) {
            super("/swagger/ui/index.html?url=" + HTTPUtils.encodeString(link.getLinkTo()), "explore");
            if (!enabled) {
                this.addStyle("sor-link-inactive");
            }
        }
    }

    public static class SwaggerJsonYamlLink
    extends LinkToken {
        public static String API_CUSTOMIZER_SWAGGER_PREFIX = "/apicustomizer";

        public SwaggerJsonYamlLink(String uriPrefix, Object formatName) {
            super("/swagger/v2" + uriPrefix + "/swagger." + String.valueOf(formatName), formatName);
        }

        public SwaggerJsonYamlLink addXSessionTokenParameter(String tokenId) {
            try {
                String encodedToken = tokenId != null ? new String(Base64.getEncoder().encodeToString(tokenId.getBytes())) : null;
                this.setLinkTo(this.getLinkTo() + "?h=" + encodedToken);
            }
            catch (Exception exception) {
                Trace.logException(this, exception, true);
            }
            return this;
        }
    }

    public static class DataspaceOdataMetadataLink
    extends LinkToken {
        public DataspaceOdataMetadataLink(String dataspaceName) {
            this(dataspaceName, "metadata");
        }

        public DataspaceOdataMetadataLink(String dataspaceName, Object displayName) {
            super(new DataspaceOdataLink(dataspaceName).getLinkTo() + "$metadata", displayName);
            this.setDownload("odata_" + HTTPUtils.htmlEncode(dataspaceName, false) + ".xml");
        }

        public DataspaceOdataMetadataLink addXSessionTokenParameter(String tokenId) {
            this.setLinkTo(this.getLinkTo() + "?x-session-token=" + tokenId);
            return this;
        }
    }

    public static class DataspaceOdataUrl
    extends LinkToken {
        public DataspaceOdataUrl(String dataspaceName) {
            this(dataspaceName, "URL");
        }

        public DataspaceOdataUrl(String dataspaceName, Object displayName) {
            super("javascript:return false;", displayName);
            this.setOnClick("odataUrlPopupShow(window.location.protocol + '//' + window.location.hostname + (window.location.port ? ':' + window.location.port : '') + '/odata/v4/" + dataspaceName + "/')");
        }
    }

    public static class DataspaceOdataLink
    extends LinkToken {
        public DataspaceOdataLink(String dataspaceName) {
            this(dataspaceName, "OData v4");
        }

        public DataspaceOdataLink(String dataspaceName, Object displayName) {
            super("/odata/v4/" + dataspaceName + "/", displayName);
        }

        public DataspaceOdataLink addXSessionTokenParameter(String tokenId) {
            this.setLinkTo(this.getLinkTo() + "?x-session-token=" + tokenId);
            return this;
        }
    }
}

