/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.html;

import com.streamscape.Trace;
import com.streamscape.omf.mapper.ConverterPluginDescriptor;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.html.AbstractHtmlPage;
import com.streamscape.sef.network.http.server.html.AbstractHtmlTable;
import com.streamscape.sef.network.http.server.html.ExtendedRowMetaData;
import com.streamscape.sef.network.http.server.html.LinkToken;
import com.streamscape.sef.network.http.server.html.PropertiesHtmlTable;
import com.streamscape.sef.network.http.server.html.SemanticTypeHtml;
import com.streamscape.sef.network.http.server.html.SemanticTypeLink;
import com.streamscape.sef.network.http.server.servlet.SorUriRegistry;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import java.util.Collections;
import java.util.List;

public class ConvertersHtmlTable
extends AbstractHtmlTable {
    public static String COLUMN_CONVERTER_NAME = "Converter Name";
    public static String COLUMN_CLASS_NAME = "Class Name";
    public static String COLUMN_INBOUND_SEMANTIC_TYPE = "Inbound Semantic Type";
    public static String COLUMN_OUTBOUND_SEMANTIC_TYPE = "Outbound Semantic Type";
    public static String COLUMN_DESCRIPTION = "Description";

    public ConvertersHtmlTable() {
        ExtendedRowMetaData meta = new ExtendedRowMetaData();
        meta.addColumn(COLUMN_CONVERTER_NAME, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_CLASS_NAME, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_INBOUND_SEMANTIC_TYPE, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_OUTBOUND_SEMANTIC_TYPE, ExtendedRowMetaData.Align.CENTER);
        meta.addColumn(COLUMN_DESCRIPTION, ExtendedRowMetaData.Align.CENTER);
        this.table = new RowSet(meta);
    }

    @Override
    public String getTitle() {
        return "Converters";
    }

    @Override
    public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
        List<String> converters = runtime.getConverterPluginManager().listConverterPlugins();
        Collections.sort(converters);
        for (String converter : converters) {
            try {
                ConverterPluginDescriptor cnvDesc = runtime.getConverterPluginManager().getConverterPluginDescriptor(converter);
                Row row = this.table.newRow();
                row.setColumn(COLUMN_CONVERTER_NAME, (Object)new ConverterLink(cnvDesc.getName()));
                row.setColumn(COLUMN_CLASS_NAME, (Object)cnvDesc.getPluginClassName());
                row.setColumn(COLUMN_INBOUND_SEMANTIC_TYPE, (Object)new SemanticTypeLink(cnvDesc.getInboundSemanticType()));
                row.setColumn(COLUMN_OUTBOUND_SEMANTIC_TYPE, (Object)new SemanticTypeLink(cnvDesc.getOutboundSemanticType()));
                row.setColumn(COLUMN_DESCRIPTION, (Object)cnvDesc.getDescription());
                this.table.addToRowSet(row);
            }
            catch (Exception exception) {
                Trace.logException(this, exception, false);
            }
        }
    }

    public static class ConverterLink
    extends LinkToken {
        public ConverterLink(String converterName, String displayName) {
            super(SorUriRegistry.registry().formatFullUri(ConverterHtml.class, converterName), displayName);
        }

        public ConverterLink(String converterName) {
            this(converterName, converterName);
        }
    }

    public static class ConverterHtml
    extends AbstractHtmlPage {
        private String converterName;
        ConverterPluginDescriptor converter;

        @Override
        public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
            this.converterName = url.getUriParameterOrThrowException("converterName");
            this.converter = runtime.getConverterPluginManager().getConverterPluginDescriptor(this.converterName);
            if (this.converter == null) {
                Trace.logError(this, "Converter '" + this.converterName + "' doesn't exist.");
                throw new Exception("Converter '" + this.converterName + "' doesn't exist.");
            }
        }

        @Override
        public String getTitle() {
            return "Converter: " + this.converterName;
        }

        @Override
        public String getHtml() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getHeaderHtml());
            PropertiesHtmlTable properties = new PropertiesHtmlTable();
            properties.addIfNotNull(COLUMN_CONVERTER_NAME, this.converter.getName());
            properties.addIfNotNull(COLUMN_CLASS_NAME, this.converter.getPluginClassName());
            properties.addIfNotNull(COLUMN_INBOUND_SEMANTIC_TYPE, new SemanticTypeHtml.SemanticTypeImageLink(this.converter.getInboundSemanticType()));
            properties.addIfNotNull(COLUMN_OUTBOUND_SEMANTIC_TYPE, new SemanticTypeHtml.SemanticTypeImageLink(this.converter.getOutboundSemanticType()));
            properties.addIfNotNull(COLUMN_DESCRIPTION, this.converter.getDescription());
            builder.append(properties.getHtml());
            return builder.toString();
        }
    }
}

