/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.html;

import com.streamscape.Trace;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.factory.DescribeConnectionFactoryOperation;
import com.streamscape.runtime.mf.operation.factory.ListConnectionFactoriesOperation;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.html.AbstractHtmlPage;
import com.streamscape.sef.network.http.server.html.AbstractHtmlTable;
import com.streamscape.sef.network.http.server.html.ExtendedRowMetaData;
import com.streamscape.sef.network.http.server.html.LinkToken;
import com.streamscape.sef.network.http.server.html.PropertiesHtmlTable;
import com.streamscape.sef.network.http.server.servlet.SorUriRegistry;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;

public class ConnectionFactoriesHtmlTable
extends AbstractHtmlTable {
    public static String COLUMN_FACTORY_NAME = "Name";
    public static String COLUMN_FACTORY_SCOPE = "Scope";

    public ConnectionFactoriesHtmlTable() throws Exception {
        ExtendedRowMetaData meta = new ExtendedRowMetaData();
        meta.addColumn(COLUMN_FACTORY_NAME, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_FACTORY_SCOPE, ExtendedRowMetaData.Align.LEFT);
        this.table = new RowSet(meta);
    }

    @Override
    public String getTitle() {
        return "Connection Factories";
    }

    @Override
    public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
        this.addNewRows(runtime, ListConnectionFactoriesOperation.FactoryScope.DB);
        this.addNewRows(runtime, ListConnectionFactoriesOperation.FactoryScope.TRANSPORT);
        this.addNewRows(runtime, ListConnectionFactoriesOperation.FactoryScope.CLIENT);
    }

    private void addNewRows(RuntimeContext runtime, ListConnectionFactoriesOperation.FactoryScope scope) throws Exception {
        for (String name : ListConnectionFactoriesOperation.listConnectionFactories(runtime, scope, false)) {
            Row row = this.table.newRow();
            row.setColumn(COLUMN_FACTORY_NAME, (Object)new ConnectionFactoryLink(name, name));
            row.setColumn(COLUMN_FACTORY_SCOPE, (Object)scope.toString().toLowerCase());
            this.table.addToRowSet(row);
        }
    }

    public static class ConnectionFactoryLink
    extends LinkToken {
        public ConnectionFactoryLink(String factoryName, String displayName) {
            super(SorUriRegistry.registry().formatFullUri(ConnectionFactoryHtml.class, factoryName), displayName);
        }
    }

    public static class ConnectionFactoryHtml
    extends AbstractHtmlPage {
        private String factoryName;
        private RowSet resultRowSet;

        @Override
        public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
            this.factoryName = url.getUriParameterOrThrowException("factoryName");
            int dot = this.factoryName.indexOf(46);
            if (dot == -1) {
                throw new Exception("Specified factory name '" + this.factoryName + "' is wrong, it should be in format <Type>.<Name>.");
            }
            String type = this.factoryName.substring(0, dot);
            String name = this.factoryName.substring(dot + 1);
            this.resultRowSet = DescribeConnectionFactoryOperation.getResultRowSet(runtime, type, name);
            if (this.resultRowSet == null) {
                Trace.logError(this, "Failed to get connection factory '" + this.factoryName + "' from .tfcache.");
                throw new Exception("Failed to get connection factory '" + this.factoryName + "' from .tfcache.");
            }
        }

        @Override
        public String getTitle() {
            return "Connection Factory: " + this.factoryName;
        }

        @Override
        public String getHtml() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getHeaderHtml());
            PropertiesHtmlTable properties = new PropertiesHtmlTable();
            for (int i = 1; i <= this.resultRowSet.getRowCount(); ++i) {
                try {
                    Row row = this.resultRowSet.getRowAt(i);
                    properties.addIfNotNull((String)row.getColumn(1), row.getColumn(2));
                    continue;
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, false);
                }
            }
            builder.append(properties.getHtml());
            return builder.toString();
        }
    }
}

