/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.html;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.sef.network.http.server.authentication.XSessionAuthenticator;
import com.streamscape.sef.network.http.server.authentication.runtime.model.Application;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApplicationService;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.html.AbstractHtmlPage;
import com.streamscape.sef.network.http.server.html.AbstractHtmlTable;
import com.streamscape.sef.network.http.server.html.DataspacesHtmlTable;
import com.streamscape.sef.network.http.server.html.ExtendedRowMetaData;
import com.streamscape.sef.network.http.server.html.LinkToken;
import com.streamscape.sef.network.http.server.html.PropertiesHtmlTable;
import com.streamscape.sef.network.http.server.html.RowSetHtmlFormatter;
import com.streamscape.sef.network.http.server.servlet.SorServletCss;
import com.streamscape.sef.network.http.server.servlet.SorUriRegistry;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import java.sql.SQLException;
import java.util.stream.Collectors;

public class ApiKeyWebApplicationsHtmlTable
extends AbstractHtmlTable {
    public static String COLUMN_APPLICATION_NAME = "Name";
    public static String COLUMN_APPLICATION_OWNER = "Owner";
    public static String COLUMN_APPLICATION_CREATED_AT = "Created At";
    public static String COLUMN_APPLICATION_GLOBAL = "Global";
    public static String COLUMN_APPLICATION_MASTER_NODE = "Master Node";
    public static String COLUMN_APPLICATION_SWAGGER = "Swagger.io";

    public ApiKeyWebApplicationsHtmlTable() {
        ExtendedRowMetaData meta = new ExtendedRowMetaData();
        meta.addColumn(COLUMN_APPLICATION_NAME, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_APPLICATION_OWNER, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_APPLICATION_CREATED_AT, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_APPLICATION_GLOBAL, ExtendedRowMetaData.Align.CENTER);
        meta.addColumn(COLUMN_APPLICATION_MASTER_NODE, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_APPLICATION_SWAGGER, ExtendedRowMetaData.Align.LEFT);
        this.table = new RowSet(meta);
    }

    @Override
    public String getTitle() {
        return "Web Applications";
    }

    @Override
    public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
        ApplicationService service = ApiKeyWebApplicationsHtmlTable.getApplicationService(runtime, url);
        for (Application application : service.getAll("*", null, false, false)) {
            Row row = this.table.newRow();
            row.setColumn(COLUMN_APPLICATION_NAME, (Object)new ApiKeyApplicationLink(application.getName(), application.getApplicationId()));
            row.setColumn(COLUMN_APPLICATION_OWNER, (Object)application.getOwner());
            row.setColumn(COLUMN_APPLICATION_CREATED_AT, (Object)AbstractOperation.formatDate(application.getCreatedAt()));
            row.setColumn(COLUMN_APPLICATION_GLOBAL, (Object)(application.isGlobal() ? "x" : ""));
            row.setColumn(COLUMN_APPLICATION_MASTER_NODE, (Object)application.getMasterNode());
            row.setColumn(COLUMN_APPLICATION_SWAGGER, (Object)new ApiKeyApplicationSwaggerLinkWithImage(application.getApplicationId(), XSessionAuthenticator.getTokenIfAuthenticated(url.getRequest()), application.getName() + "_" + application.getOwner()));
            this.table.addToRowSet(row);
        }
    }

    private static ApplicationService getApplicationService(RuntimeContext runtime, FabricHTTPRequest url) {
        return runtime.getHTTPAuthenticationManager().authorize(url.getRequest()).getApiKeyServiceFactory().getApplicationService();
    }

    public static class ApiKeyApplicationLink
    extends LinkToken {
        public ApiKeyApplicationLink(String applicationName, String applicationId) {
            super(SorUriRegistry.registry().formatFullUri(ApiKeyWebApplicationHtml.class, applicationId), applicationName);
        }
    }

    public static class ApiKeyApplicationSwaggerLinkWithImage
    extends DataspacesHtmlTable.SwaggerLinkWithImage {
        public ApiKeyApplicationSwaggerLinkWithImage(String applicationName, String tokenId, String name) {
            super(new ApiKeyApplicationSwaggerJsonLink(applicationName, name).addXSessionTokenParameter(tokenId), new ApiKeyApplicationSwaggerYamlLink(applicationName, name).addXSessionTokenParameter(tokenId), new ApiKeyApplicationSwaggerUiLink(applicationName, tokenId, name), new DataspacesHtmlTable.SwaggerClientDownloadLink(new ApiKeyApplicationSwaggerJsonLink(applicationName, name).addXSessionTokenParameter(tokenId), applicationName));
        }
    }

    public static class ApiKeyWebApplicationHtml
    extends AbstractHtmlPage {
        private Application application;

        @Override
        public String getTitle() {
            return "Web Application: " + this.application.getName();
        }

        @Override
        public void init(RuntimeContext runtime, HTTPServerFabricConnection connection, FabricHTTPRequest url) throws Exception {
            this.application = ApiKeyWebApplicationsHtmlTable.getApplicationService(runtime, url).get(url.getUriParameterOrThrowException("applicationId"), true);
            if (this.application == null) {
                throw new Exception("Web Application with specified id not found.");
            }
        }

        @Override
        public String getHtml() {
            return SorServletCss.header(this.application.getName()) + "\n" + this.getPropertiesHtml() + "\n" + this.getResourcesHtml();
        }

        protected String getPropertiesHtml() {
            PropertiesHtmlTable properties = new PropertiesHtmlTable();
            properties.addIfNotNull("Name", this.application.getName());
            properties.addIfNotNull("Description", this.application.getDescription());
            properties.addIfNotNull("Owner", this.application.getOwner());
            properties.addIfNotNull("ID", this.application.getApplicationId());
            properties.addIfNotNull("Created At", AbstractOperation.formatDate(this.application.getCreatedAt()));
            properties.addIfNotNull("Global", this.application.isGlobal());
            properties.addIfNotNull("Master Node", this.application.getMasterNode());
            properties.addIfNotNull("Security Bindings", this.application.getSecurityBindings() != null && this.application.getSecurityBindings().size() > 0 ? "[" + this.application.getSecurityBindings().stream().map(b -> b.toString()).collect(Collectors.joining(",")) + "]" : "none");
            return properties.getHtml();
        }

        private String getResourcesHtml() {
            ExtendedRowMetaData meta = new ExtendedRowMetaData();
            meta.addColumn("HTTP Method", ExtendedRowMetaData.Align.LEFT);
            meta.addColumn("URI", ExtendedRowMetaData.Align.LEFT);
            meta.addColumn("Name", ExtendedRowMetaData.Align.LEFT);
            meta.addColumn("Description", ExtendedRowMetaData.Align.LEFT);
            RowSet table = new RowSet(meta);
            for (Application.Resource resource : this.application.getResources()) {
                try {
                    table.addToRowSet(new Object[]{resource.getMethod(), resource.getUrl(), resource.getName() != null ? resource.getName() : "", resource.getDescription() != null ? resource.getDescription() : ""});
                }
                catch (SQLException sQLException) {}
            }
            return SorServletCss.subheader("Resources") + new RowSetHtmlFormatter(SorServletCss.TABLE_LIST_STYLE, SorServletCss.TABLE_LIST_STYLE_ALT).formatHorizontal(table);
        }
    }

    public static class ApiKeyApplicationSwaggerUiLink
    extends DataspacesHtmlTable.SwaggerUiLink {
        public ApiKeyApplicationSwaggerUiLink(String applicationId, String tokenId, String name) {
            super(new ApiKeyApplicationSwaggerJsonLink(applicationId, name).addXSessionTokenParameter(tokenId));
        }
    }

    public static class ApiKeyApplicationSwaggerYamlLink
    extends AbstractApiKeyApplicationSwaggerJsonYamlLink {
        public ApiKeyApplicationSwaggerYamlLink(String applicationId, String name) {
            super(applicationId, name, "yaml");
        }
    }

    public static class ApiKeyApplicationSwaggerJsonLink
    extends AbstractApiKeyApplicationSwaggerJsonYamlLink {
        public ApiKeyApplicationSwaggerJsonLink(String applicationId, String name) {
            super(applicationId, name, "json");
        }
    }

    public static class AbstractApiKeyApplicationSwaggerJsonYamlLink
    extends DataspacesHtmlTable.SwaggerJsonYamlLink {
        public AbstractApiKeyApplicationSwaggerJsonYamlLink(String applicationId, String name, String formatName) {
            super("/apikeyapplication/" + applicationId, formatName);
            this.setDownload("swagger_" + HTTPUtils.htmlEncode(name, false) + "." + formatName);
        }
    }
}

