/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.html;

import com.streamscape.Trace;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.network.http.server.html.AbstractHtmlPage;
import com.streamscape.sef.network.http.server.html.ExtendedRowMetaData;
import com.streamscape.sef.network.http.server.html.RowSetHtmlFormatter;
import com.streamscape.sef.network.http.server.servlet.SorServletCss;
import java.sql.SQLException;

public abstract class AbstractHtmlTable
extends AbstractHtmlPage {
    protected RowSet table;

    public RowSet getRowSet() {
        return this.table;
    }

    protected void initTableMetaFrom(RowSet rowSet) {
        ExtendedRowMetaData meta = new ExtendedRowMetaData();
        for (String columnName : rowSet.getMeta().getColumnNames()) {
            meta.addColumn(columnName, ExtendedRowMetaData.Align.LEFT);
        }
        this.table = new RowSet(meta);
    }

    protected void initTableDataFrom(RowSet rowSet) {
        this.initTableMetaFrom(rowSet);
        try {
            while (rowSet.next()) {
                this.table.addToRowSet(rowSet.getCurrentRow());
            }
        }
        catch (SQLException exception) {
            Trace.logException(this, exception, false);
        }
    }

    @Override
    public String getHtml() {
        return this.getHeaderHtml() + this.getTableHtml();
    }

    protected String getTableHtml() {
        return new RowSetHtmlFormatter(SorServletCss.TABLE_LIST_STYLE, SorServletCss.TABLE_LIST_STYLE_ALT).formatHorizontal(this.table);
    }
}

