/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.fabric;

import com.streamscape.Trace;
import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.sef.network.http.server.fabric.AsyncReverseProcessor;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnectionImpl;
import com.streamscape.sef.network.http.server.fabric.ReverseProcessor;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import java.util.Arrays;
import java.util.Iterator;
import javax.servlet.http.HttpServletResponse;

public class SynchronousReverseProcessor
implements ReverseProcessor {
    private AsyncReverseProcessor.MessagesQueue messagesQueue;
    private final Object mutex = new Object();
    private HttpServletResponse reverseResponseStream;
    private long reverseResponseStreamSetTime;
    private TimesQueue timesQueue;
    private HTTPServerFabricConnectionImpl connection;
    private static final int MESSAGES_CHECK_TIMEOUT_MS = 1000;
    private static final int MESSAGES_SIZE_LIMIT_BYTES = 0xA00000;

    SynchronousReverseProcessor(HTTPServerFabricConnectionImpl connection) {
        this.connection = connection;
        this.messagesQueue = new AsyncReverseProcessor.MessagesQueue();
        this.timesQueue = new TimesQueue(20, 1000);
    }

    private AsyncReverseProcessor.MessagesQueue replaceMessagesQueue() {
        AsyncReverseProcessor.MessagesQueue result = this.messagesQueue;
        this.messagesQueue = new AsyncReverseProcessor.MessagesQueue();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendReverseMessage(String message, boolean direct) {
        this.messagesQueue.add(message);
        if (direct || !this.timesQueue.postAndCheckIsFrequently()) {
            Object object = this.mutex;
            synchronized (object) {
                this.mutex.notifyAll();
            }
        }
        if (this.messagesQueue.getMessagesSize() > 0xA00000L) {
            Object object = this.mutex;
            synchronized (object) {
                if (this.messagesQueue.getMessagesSize() > 0xA00000L) {
                    this.mutex.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void holdReverseConnection(FabricHTTPRequest url, HttpServletResponse response) throws FabricConnectionException {
        this.log(Trace.Level.DEBUG, "Holding HTTP reverse response stream...");
        Object object = this.mutex;
        synchronized (object) {
            block9: {
                if (!this.connection.isOpened()) {
                    throw new FabricConnectionException(1011, "Connection '" + this.connection.getName() + "' is not opened.");
                }
                if (Trace.isDebugEnabled(this.getClass())) {
                    this.log(Trace.Level.DEBUG, "Set new response stream: " + String.valueOf(response));
                }
                this.reverseResponseStreamSetTime = System.currentTimeMillis();
                HttpServletResponse localReverseResponseStream = this.reverseResponseStream = response;
                this.mutex.notifyAll();
                try {
                    this.sendMessages();
                    long startTime = System.currentTimeMillis();
                    while (this.reverseResponseStream != null && System.currentTimeMillis() - startTime < this.getReverseConnectionHoldTimeout()) {
                        this.mutex.wait(1000L);
                        if (localReverseResponseStream == this.reverseResponseStream) {
                            this.sendMessages();
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    if (!Trace.isDebugEnabled(this.getClass())) break block9;
                    this.log(Trace.Level.DEBUG, "Hold stream exception: " + exception.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessages() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.reverseResponseStream == null || this.messagesQueue.count() == 0) {
                return;
            }
            AsyncReverseProcessor.MessagesQueue messagesToSend = this.replaceMessagesQueue();
            if (messagesToSend.count() == 0) {
                return;
            }
            try {
                StringBuilder messages = new StringBuilder("[");
                Iterator<String> iterator = messagesToSend.iterator();
                if (iterator.hasNext()) {
                    messages.append(iterator.next());
                    while (iterator.hasNext()) {
                        messages.append(",");
                        messages.append(iterator.next());
                    }
                }
                messages.append("]");
                if (Trace.isDebugEnabled(this.getClass())) {
                    this.log(Trace.Level.DEBUG, "Sending reply using response stream: " + String.valueOf(this.reverseResponseStream) + ", response length: " + messages.length());
                }
                this.reverseResponseStream.setContentType("application/json; charset=UTF-8");
                this.reverseResponseStream.getOutputStream().print(messages.toString());
                this.reverseResponseStream.getOutputStream().flush();
                this.reverseResponseStream = null;
                this.mutex.notifyAll();
                this.log(Trace.Level.DEBUG, "Reply sent.");
            }
            catch (Exception exception) {
                this.log(Trace.Level.ERROR, "Reply failed. Cause: " + exception.getMessage());
                if (this.connection.isRemoved() || !this.connection.isOpened() || this.connection.isClosed()) {
                    if (!Trace.isBroadcastEnabled(this.getClass().getName())) {
                        this.log(Trace.Level.ERROR, "Connection is not opened(" + !this.connection.isOpened() + ") or removed(" + this.connection.isRemoved() + "). Clearing " + messagesToSend.count() + " of size " + messagesToSend.getMessagesSize() + " bytes reverse messages.");
                    }
                }
                if (this.connection.leasePeriod > 0L && System.currentTimeMillis() - this.reverseResponseStreamSetTime > this.getReverseConnectionHoldTimeout() * 3L) {
                    this.log(Trace.Level.ERROR, "Reverse response stream was set " + (System.currentTimeMillis() - this.reverseResponseStreamSetTime) + " ms ago (limit time " + this.getReverseConnectionHoldTimeout() * 3L + " ms). Accessed " + (System.currentTimeMillis() - this.connection.lastAccessTime) + " ms ago (lease period " + this.connection.leasePeriod + " ms). Clearing " + messagesToSend.count() + " of size " + messagesToSend.getMessagesSize() + " bytes reverse messages.");
                }
                this.messagesQueue.prepend(messagesToSend);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mutex;
        synchronized (object) {
            this.reverseResponseStream = null;
            this.mutex.notifyAll();
        }
    }

    private long getReverseConnectionHoldTimeout() {
        return this.connection.leasePeriod > 0L ? this.connection.leasePeriod / 2L : 30000L;
    }

    public void log(Trace.Level level, String message) {
        this.connection.log(level, message, new Object[0]);
    }

    public static class TimesQueue {
        private CirqularQueue<Long> queue;
        private int timeout;

        public TimesQueue(int capacity, int timeout) {
            this.queue = new CirqularQueue<Long>(capacity, -1L);
            this.timeout = timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean postAndCheckIsFrequently() {
            long timestamp = System.currentTimeMillis();
            TimesQueue timesQueue = this;
            synchronized (timesQueue) {
                this.queue.put(timestamp);
            }
            return timestamp - this.queue.first() < (long)this.timeout;
        }
    }

    public static class CirqularQueue<T> {
        private Object[] queue;
        private int top;
        private T defaultValue;

        public CirqularQueue(int capacity) {
            this(capacity, null);
        }

        public CirqularQueue(int capacity, T defaultValue) {
            this.queue = new Object[capacity];
            this.top = -1;
            this.defaultValue = defaultValue;
            Arrays.fill(this.queue, defaultValue);
        }

        public void put(T e) {
            ++this.top;
            if (this.top == this.queue.length) {
                this.top = 0;
            }
            this.queue[this.top] = e;
        }

        public T last() {
            if (this.top == -1) {
                return this.defaultValue;
            }
            return (T)this.queue[this.top];
        }

        public T first() {
            if (this.top == -1) {
                return this.defaultValue;
            }
            int firstIndex = this.top + 1;
            if (firstIndex >= this.queue.length) {
                firstIndex = 0;
            }
            return (T)this.queue[firstIndex];
        }

        public int capacity() {
            return this.queue.length;
        }

        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private int iteratorTop;
                private int iteratedCount;
                {
                    this.iteratorTop = top;
                    this.iteratedCount = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.iteratedCount < queue.length;
                }

                @Override
                public T next() {
                    if (this.hasNext()) {
                        ++this.iteratedCount;
                        ++this.iteratorTop;
                        if (this.iteratorTop == queue.length) {
                            this.iteratorTop = 0;
                        }
                        return queue[this.iteratorTop];
                    }
                    return defaultValue;
                }

                @Override
                public void remove() {
                }
            };
        }
    }
}

