/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.fabric;

import com.streamscape.Trace;
import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.sdo.operation.SLFileMessage;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnectionImpl;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationListener;
import org.eclipse.jetty.continuation.ContinuationSupport;

public class SLFileDownloadUploadRequestsHolder {
    public static final String FILENAME = "filename";
    public static final String SL_SESSION_NAME = "slSessionName";
    public static final String EVENT_UNIQUE_ID = "eventUniqueId";
    public static final String ATTRIBUTE_FILENAME_SL_SESSION_ID = "filenameSLSEssionId";
    public static final String ATTRIBUTE_URL = "url";
    private HTTPServerFabricConnectionImpl connection;
    private Map<String, Continuation> continuations = new ConcurrentHashMap<String, Continuation>();

    public SLFileDownloadUploadRequestsHolder(HTTPServerFabricConnectionImpl connection) {
        this.connection = connection;
    }

    public boolean hold(FabricHTTPRequest url, HttpServletResponse response) throws FabricConnectionException {
        String filename = url.getParameter(FILENAME);
        String slSessionName = url.getParameter(SL_SESSION_NAME);
        String uniqueId = url.getParameter(EVENT_UNIQUE_ID);
        if (filename == null || filename.length() == 0 || slSessionName == null || slSessionName.length() == 0 || uniqueId == null || uniqueId.length() == 0) {
            return false;
        }
        String filenameSLSessionId = this.makeFilenameSLSessionId(filename, slSessionName);
        Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)url.getRequest());
        continuation.setTimeout(this.getReverseConnectionHoldTimeout());
        continuation.addContinuationListener((ContinuationListener)new ContinuationListenerImpl());
        continuation.setAttribute(ATTRIBUTE_FILENAME_SL_SESSION_ID, (Object)filenameSLSessionId);
        continuation.setAttribute(ATTRIBUTE_URL, (Object)url);
        this.log(Trace.Level.DEBUG, continuation, " created.", new Object[0]);
        continuation.suspend((ServletResponse)response);
        this.continuations.put(filenameSLSessionId, continuation);
        this.connection.eventCompleted(Long.parseLong(uniqueId), url.getRequest().getContentLengthLong());
        return true;
    }

    public void write(SLFileMessage message) throws Exception {
        if (message.getOperation() != SLFileMessage.FileOperation.WRITE) {
            return;
        }
        Continuation continuation = this.getContinuationOrThrowException(message);
        continuation.getServletResponse().getOutputStream().write(message.getBytes());
        this.log(Trace.Level.DEBUG, continuation, "write message: {}", message);
    }

    public void read(SLFileMessage message) throws Exception {
        Continuation continuation = this.getContinuationOrThrowException(message);
        this.log(Trace.Level.DEBUG, continuation, "read message: {}", message);
        byte[] bytes = new byte[(int)message.getLength()];
        HttpServletRequest request = ((FabricHTTPRequest)continuation.getAttribute(ATTRIBUTE_URL)).getRequest();
        message.setLength(request.getInputStream().read(bytes, 0, bytes.length));
        if (message.getLength() == -1L) {
            bytes = null;
        } else if ((long)bytes.length > message.getLength()) {
            bytes = Arrays.copyOfRange(bytes, 0, (int)message.getLength());
        }
        message.setBytes(bytes);
    }

    public void skip(SLFileMessage message) throws Exception {
        HttpServletRequest request = ((FabricHTTPRequest)this.getContinuationOrThrowException(message).getAttribute(ATTRIBUTE_URL)).getRequest();
        message.setLength(request.getInputStream().skip(message.getLength()));
    }

    public void getAvailable(SLFileMessage message) throws Exception {
        HttpServletRequest request = ((FabricHTTPRequest)this.getContinuationOrThrowException(message).getAttribute(ATTRIBUTE_URL)).getRequest();
        message.setLength(request.getInputStream().available());
    }

    public void close(SLFileMessage message) throws Exception {
        Continuation continuation = this.getContinuationOrThrowException(message);
        this.log(Trace.Level.DEBUG, continuation, "close message: {}", message);
        continuation.complete();
        this.continuations.remove(this.makeFilenameSLSessionId(message));
    }

    public void close() {
        for (Continuation continuation : this.continuations.values()) {
            continuation.complete();
        }
        this.continuations.clear();
    }

    public boolean exists(SLFileMessage message) {
        return this.continuations.get(this.makeFilenameSLSessionId(message)) != null;
    }

    private Continuation getContinuationOrThrowException(SLFileMessage message) throws Exception {
        Continuation continuation = this.continuations.get(this.makeFilenameSLSessionId(message));
        if (continuation == null) {
            this.log(Trace.Level.ERROR, "Continuation for file {} not found.", message);
            throw new Exception("Continuation not found for file " + String.valueOf(message));
        }
        return continuation;
    }

    private String makeFilenameSLSessionId(SLFileMessage message) {
        return this.makeFilenameSLSessionId(message.getFilename(), message.getSLSessionName());
    }

    private String makeFilenameSLSessionId(String filename, String slSessionName) {
        return filename + ":" + slSessionName;
    }

    private long getReverseConnectionHoldTimeout() {
        return this.connection.getReverseConnectionHoldTimeout();
    }

    private void log(Trace.Level level, String message, Object ... args) {
        this.connection.log(level, message, args);
    }

    private void log(Trace.Level level, Continuation continuation, String message, Object ... args) {
        if (Trace.isEnabled(this.connection.getClass(), level)) {
            this.connection.log(level, "Continuation filename " + String.valueOf(continuation != null ? continuation.getAttribute(ATTRIBUTE_FILENAME_SL_SESSION_ID) : null) + ", " + message, args);
        }
    }

    class ContinuationListenerImpl
    implements ContinuationListener {
        ContinuationListenerImpl() {
        }

        public void onComplete(Continuation continuation) {
            SLFileDownloadUploadRequestsHolder.this.log(Trace.Level.DEBUG, continuation, " completed.", new Object[0]);
        }

        public void onTimeout(Continuation continuation) {
            SLFileDownloadUploadRequestsHolder.this.log(Trace.Level.ERROR, continuation, " timeout expired.", new Object[0]);
            continuation.complete();
            SLFileDownloadUploadRequestsHolder.this.continuations.remove((String)continuation.getAttribute(SLFileDownloadUploadRequestsHolder.ATTRIBUTE_FILENAME_SL_SESSION_ID));
        }
    }
}

