/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.fabric;

import com.streamscape.Trace;
import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.sdo.operation.SLAudioMessage;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnectionImpl;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletResponse;

public class SLAudioRequestsHolder {
    public static final String UNIQUE_STREAM_ID = "uniqueStreamId";
    public static final String SL_SESSION_NAME = "slSessionName";
    public static final String EVENT_UNIQUE_ID = "eventUniqueId";
    public static final String ATTRIBUTE_AUDIO_SL_SESSION_ID = "audioSLSessionId";
    public static final String ATTRIBUTE_URL = "url";
    public static final int READ_BUFFER_SIZE = 16384;
    private HTTPServerFabricConnectionImpl connection;
    private Map<String, ByteArrayOutputStream> activeStreams = new ConcurrentHashMap<String, ByteArrayOutputStream>();

    public SLAudioRequestsHolder(HTTPServerFabricConnectionImpl connection) {
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hold(FabricHTTPRequest url, HttpServletResponse response) throws FabricConnectionException {
        String uniqueStreamId = url.getParameter(UNIQUE_STREAM_ID);
        String slSessionName = url.getParameter(SL_SESSION_NAME);
        String uniqueId = url.getParameter(EVENT_UNIQUE_ID);
        if (uniqueStreamId == null || uniqueStreamId.length() == 0 || slSessionName == null || slSessionName.length() == 0 || uniqueId == null || uniqueId.length() == 0) {
            return false;
        }
        try {
            Trace.logInfo(this, uniqueStreamId + ": audio data received, length: ...");
            ByteArrayOutputStream activeStream = this.activeStreams.get(uniqueStreamId);
            if (activeStream != null) {
                ByteArrayOutputStream byteArrayOutputStream = activeStream;
                synchronized (byteArrayOutputStream) {
                    try {
                        FileIOUtils.copy((InputStream)url.getRequest().getInputStream(), (OutputStream)activeStream);
                    }
                    catch (UtilitiesException e) {
                        Trace.logInfo(this, uniqueStreamId + ": failed to copy data");
                        Trace.logException(this, e, true);
                    }
                }
                response.getOutputStream().write("{\"streamIsOk\": true}".getBytes());
            } else {
                Trace.logInfo(this, uniqueStreamId + ": audio data stream is closed. Return error to frontend.");
                response.getOutputStream().write("{\"streamIsOk\": false}".getBytes());
            }
            response.flushBuffer();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public void open(SLAudioMessage message) throws Exception {
        Trace.logInfo(this, message.getUniqueStreamId() + ": opening stream");
        this.activeStreams.putIfAbsent(message.getUniqueStreamId(), new ByteArrayOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(SLAudioMessage message) throws Exception {
        ByteArrayOutputStream activeStream = this.activeStreams.get(message.getUniqueStreamId());
        if (activeStream != null) {
            ByteArrayOutputStream byteArrayOutputStream = activeStream;
            synchronized (byteArrayOutputStream) {
                byte[] bytes = activeStream.toByteArray();
                activeStream.reset();
                if (bytes.length > message.getLength()) {
                    int newLength = message.getLength() > 16384 ? 16384 * (message.getLength() / 16384) : message.getLength();
                    activeStream.write(bytes, newLength, bytes.length - newLength);
                    bytes = Arrays.copyOf(bytes, newLength);
                }
                message.setBytes(bytes);
                message.setLength(bytes.length);
            }
        } else {
            Trace.logError(this, message.getUniqueStreamId() + ": error failed, stream is closed");
            throw new Exception("Stream is closed.");
        }
    }

    public void close(SLAudioMessage message) throws Exception {
        Trace.logInfo(this, message.getUniqueStreamId() + ": closing stream");
        this.activeStreams.remove(message.getUniqueStreamId());
    }

    public void close() {
        Trace.logInfo(this, "Closing all active audio stream: " + String.valueOf(this.activeStreams.keySet()));
        this.activeStreams.clear();
    }
}

