/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.fabric;

import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import java.math.BigDecimal;
import java.math.BigInteger;

public class RemoteMethodCall {
    private String methodName;
    private Object[] arguments;

    public RemoteMethodCall(String method, Object[] args) {
        this.methodName = method;
        this.arguments = args;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void updateMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Object[] getArguments() {
        if (this.arguments == null) {
            this.arguments = new Object[0];
        }
        return this.arguments;
    }

    public Class<?>[] getArgumentClasses() {
        int i;
        if (this.arguments == null) {
            this.arguments = new Object[0];
        }
        if (this.arguments.getClass() != Object[].class) {
            Object[] newArguments = new Object[this.arguments.length];
            for (i = 0; i < this.arguments.length; ++i) {
                newArguments[i] = this.arguments[i];
            }
            this.arguments = newArguments;
        }
        Class[] argumentClasses = new Class[this.arguments.length];
        for (i = 0; i < this.arguments.length; ++i) {
            if (this.arguments[i] == null) continue;
            argumentClasses[i] = this.arguments[i].getClass();
        }
        return argumentClasses;
    }

    public void applyTypes(Class<?>[] types) {
        if (types.length != this.arguments.length) {
            throw new IllegalArgumentException("Types count mismatch.");
        }
        if (this.arguments.length == 0) {
            return;
        }
        for (int i = 0; i < types.length; ++i) {
            if (this.arguments[i] == null) continue;
            Class<?> type = types[i];
            if (this.arguments[i].getClass() == type) continue;
            this.arguments[i] = this.castValueTo(this.arguments[i], type);
        }
    }

    private Object castValueTo(Object argument, Class<?> type) {
        if (Number.class.isAssignableFrom(type = TypeFactory.wrapPrimitive(type)) && argument instanceof Number) {
            if (type == Byte.class) {
                return ((Number)argument).byteValue();
            }
            if (type == Short.class) {
                return ((Number)argument).shortValue();
            }
            if (type == Integer.class) {
                return ((Number)argument).intValue();
            }
            if (type == Long.class) {
                return ((Number)argument).longValue();
            }
            if (type == Float.class) {
                return Float.valueOf(((Number)argument).floatValue());
            }
            if (type == Double.class) {
                return ((Number)argument).doubleValue();
            }
            if (type == BigDecimal.class) {
                return new BigDecimal(((Number)argument).doubleValue());
            }
            if (type == BigInteger.class) {
                return BigInteger.valueOf(((Number)argument).longValue());
            }
        }
        return argument;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.methodName);
        result.append("(");
        for (int i = 0; i < this.arguments.length; ++i) {
            if (i != 0) {
                result.append(", ");
            }
            if (this.arguments[i] == null) {
                result.append("null");
                continue;
            }
            result.append(this.arguments[i].getClass().getSimpleName());
        }
        result.append(")");
        return result.toString();
    }
}

