/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.fabric;

import com.streamscape.Trace;
import com.streamscape.Version;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.cli.service.ServiceAccessor;
import com.streamscape.cli.tlp.ClientId;
import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.cli.tlp.PingResult;
import com.streamscape.lib.fs.client.FileInfo;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.IAbstractExceptionEvent;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.OpaqueDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.advisory.HTTPClientAdvisory;
import com.streamscape.sdo.advisory.HTTPRestClientAdvisory;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.OpaqueDatagramFactory;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sdo.operation.SLAudioMessage;
import com.streamscape.sdo.operation.SLFileMessage;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sdo.vcard.vCard;
import com.streamscape.sef.DomainConstraint;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.FabricEventSourceException;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.sef.FabricRequestListener;
import com.streamscape.sef.FabricUnboundEventException;
import com.streamscape.sef.InvalidRangeBoundaryTypeException;
import com.streamscape.sef.RangeConstraint;
import com.streamscape.sef.accessor.FabricComponentAccessorException;
import com.streamscape.sef.dispatcher.AbstractHTTPServerFabricConnection;
import com.streamscape.sef.dispatcher.HTTPSLSessionImpl;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptor;
import com.streamscape.sef.network.http.server.authentication.AuthenticationHelper;
import com.streamscape.sef.network.http.server.fabric.AsyncReverseProcessor;
import com.streamscape.sef.network.http.server.fabric.HTTPEventCompletionWaiter;
import com.streamscape.sef.network.http.server.fabric.HTTPEventTransmitter;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnectionInfo;
import com.streamscape.sef.network.http.server.fabric.LinkMode;
import com.streamscape.sef.network.http.server.fabric.ReverseProcessor;
import com.streamscape.sef.network.http.server.fabric.SLAudioRequestsHolder;
import com.streamscape.sef.network.http.server.fabric.SLFileDownloadUploadRequestsHolder;
import com.streamscape.sef.network.http.server.jetty.WarDeployer;
import com.streamscape.sef.network.http.server.jetty.fabric.FabricConnectionsProvider;
import com.streamscape.sef.network.http.server.servlet.StaticMethodWrapper;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import com.streamscape.sef.security.AuthenticationType;
import com.streamscape.sef.security.Organization;
import com.streamscape.sef.security.SecurityManager;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.User;
import com.streamscape.slex.slang.SLSession;
import com.streamscape.slex.slang.SLSessionException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.sound.sampled.AudioFormat;
import org.eclipse.jetty.server.session.AbstractSession;

public class HTTPServerFabricConnectionImpl
extends AbstractHTTPServerFabricConnection
implements HTTPServerFabricConnection {
    protected long leasePeriod = 60000L;
    protected long sessionTimeout = 60000L;
    protected long reverseConnectionHoldTimeout = 10000L;
    protected long lastAccessTime;
    protected LinkMode openLinkMode = LinkMode.START;
    protected LinkMode closeLinkMode = LinkMode.STOP;
    protected boolean isRemoved = false;
    protected boolean isClosed = false;
    protected int timeZoneOffset;
    protected String timeZoneString = "";
    private transient Map<String, ServiceAccessor> serviceAccessors = new ConcurrentHashMap<String, ServiceAccessor>();
    private transient Map<String, DataspaceAccessor> dataspaceAccessors = new ConcurrentHashMap<String, DataspaceAccessor>();
    private transient Map<Long, HTTPEventCompletionWaiter> eventCompletionWaiters = new ConcurrentHashMap<Long, HTTPEventCompletionWaiter>();
    private transient long fileTransfersDirectConsumersTimeoutMs = 20000L;
    private transient FabricConnectionsProvider fabricConnectionsProvider;
    private transient ReverseProcessor reverseProcessor;
    private transient SLFileDownloadUploadRequestsHolder slFileDownloadUploadRequestsHolder;
    private transient SLAudioRequestsHolder slAudioRequestsHolder;
    private transient HTTPAcceptor acceptor;
    private transient HttpServletRequest request;
    private transient String httpSessionId;
    private transient String initialContextPath;
    protected boolean leasPeriodIsDefault = false;

    public HTTPServerFabricConnectionImpl(String type, String name, RuntimeContext context) {
        super(type, name, context);
        this.lastAccessTime = System.currentTimeMillis();
        this.reverseProcessor = new AsyncReverseProcessor(this);
        this.slFileDownloadUploadRequestsHolder = new SLFileDownloadUploadRequestsHolder(this);
        this.slAudioRequestsHolder = new SLAudioRequestsHolder(this);
    }

    public void init(HTTPAcceptor acceptor, HttpServletRequest request) {
        this.acceptor = acceptor;
        this.request = request;
        this.fabricConnectionsProvider = FabricConnectionsProvider.getProviderFromRequest(request);
        if (this.initialContextPath == null) {
            this.initialContextPath = AuthenticationHelper.getRequestContextPath(request);
        }
        this.initClientInfo(acceptor, request);
    }

    @Override
    public String getInitialContextPath() {
        return this.initialContextPath;
    }

    @Override
    public HTTPServerFabricConnectionInfo open(String name, String description, ClientId clientId, EventScope scope, long leasePeriod, LinkMode openMode) throws FabricConnectionException, SecurityManagerException {
        return this.open(name, null, description, clientId, scope, leasePeriod, openMode);
    }

    @Override
    public HTTPServerFabricConnectionInfo open(String name, String type, String description, ClientId clientId, EventScope scope, long leasePeriod, LinkMode openMode) throws FabricConnectionException, SecurityManagerException {
        HTTPServerFabricConnection c;
        if (clientId != null && (clientId.getDomain() == null || clientId.getDomain().length() == 0)) {
            clientId.setDomain(this.getSysplexDomain());
        }
        if (clientId != null) {
            clientId.add("node", this.context.getName());
        }
        if (!this.isRest() && clientId != null && (c = this.fabricConnectionsProvider.getConnectionForUserAndClientId(this.getUserName(), clientId)) != null && c.isOpened() && c != this && c.getClientId() != null && clientId.toString().equals(c.getClientId().toString())) {
            if (openMode == LinkMode.ATTACH) {
                c.getReverseProcessor().sendReverseMessage("{\"intercepted\" : true}", false);
                this.fabricConnectionsProvider.removeAndCloseConnection(c.getHttpSessionId(), false);
                Trace.logDebug(this, "{} connection intercepted.", c);
            } else {
                this.log(Trace.Level.ERROR, "User " + this.getUserName() + " already logged in session '" + c.getHttpSessionId() + "' with clientId '" + String.valueOf(c.getClientId()) + "'. Logout or use reconnect.", new Object[0]);
                throw new SecurityManagerException(6002, "User " + this.getUserName() + " already logged in another session. Logout or use reconnect.");
            }
        }
        if (openMode == LinkMode.ATTACH) {
            this.openLinkMode = LinkMode.ATTACH;
            if (this.isOpened()) {
                this.getReverseProcessor().close();
                this.getSLFileDownloadUploadRequestsHolder().close();
                this.getSLAudioRequestsHolder().close();
            }
        }
        if (name != null) {
            this.doSetName(name);
        }
        if (type != null) {
            this.doSetType(type);
        }
        if (description != null) {
            this.setDescription(description);
        }
        if (clientId != null) {
            this.setClientId(clientId);
        }
        if (scope != null) {
            this.setEventScope(scope);
        }
        this.setTimeZoneParams();
        this.open();
        AbstractSession session = (AbstractSession)this.request.getSession(false);
        if (session == null || !session.isValid()) {
            this.log(Trace.Level.ERROR, "It seems that session was expired or invalidated while opening a connection. Closing this connection.", new Object[0]);
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new FabricConnectionException(1015, "HTTP session was closed.");
        }
        this.setLeasePeriod(leasePeriod);
        this.sessionTimeout = this.acceptor.getConfiguration().getSessionTimeout() * 60 * 1000;
        HTTPServerFabricConnectionInfo info = new HTTPServerFabricConnectionInfo();
        info.component.fabricAddress = this.getFabricAddress();
        info.component.description = this.getDescription();
        info.component.eventScope = this.getEventScope();
        info.component.name = this.getName();
        info.component.type = this.getType();
        info.sessionId = (String)this.getURLs().iterator().next();
        info.clientId = this.getClientId();
        info.leasePeriod = this.leasePeriod;
        info.sessionTimeout = this.sessionTimeout;
        info.creationTime = this.getTimestamp();
        info.lastAccessTime = this.lastAccessTime;
        info.openLinkMode = this.openLinkMode;
        info.closeLinkMode = this.closeLinkMode;
        info.timeZoneOffset = this.timeZoneOffset;
        info.userName = this.getUserName();
        info.reverseConnectionHoldTimeout = this.reverseConnectionHoldTimeout;
        info.hostTimezone = this.getHostTimezone().getID();
        info.nodeTimezone = this.getNodeTimezone().getID();
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws FabricConnectionException, SecurityManagerException {
        this.lastAccessTime = System.currentTimeMillis();
        HTTPServerFabricConnectionImpl hTTPServerFabricConnectionImpl = this;
        synchronized (hTTPServerFabricConnectionImpl) {
            if (this.isClosed) {
                throw new FabricConnectionException(1002, "Cannot open already closed connection.");
            }
            super.open();
        }
        try {
            String eventId = this.isRest() ? "advisory.client.http.rest" : "advisory.client.http";
            this.bindProducerForSystem(eventId);
        }
        catch (FabricEventDispatcherException exception) {
            Trace.logException(this, exception, true);
        }
        this.log(Trace.Level.DEBUG, "New connection opened.", new Object[0]);
        this.raiseClientAdvisory(HTTPClientAdvisory.Type.CLIENT_CONNECTED, "HTTP Client connected.");
    }

    @Override
    public synchronized void close() throws FabricConnectionException {
        this.log(Trace.Level.DEBUG, "Closing connection.", new Object[0]);
        if (this.isOpened()) {
            if (!this.isLeasePeriodExpired()) {
                if (this.closeLinkMode == LinkMode.DETACH) {
                    return;
                }
                this.raiseClientAdvisory(HTTPClientAdvisory.Type.CLIENT_DISCONNECTED, "HTTP Client disconnected.");
            } else {
                this.raiseClientAdvisory(HTTPClientAdvisory.Type.LEASE_EXPIRED, "HTTP Client lease period expired, disconnecting.");
            }
        }
        this.isClosed = true;
        this.serviceAccessors.clear();
        this.dataspaceAccessors.clear();
        super.close();
        try {
            this.getReverseProcessor().close();
            this.getSLFileDownloadUploadRequestsHolder().close();
            this.getSLAudioRequestsHolder().close();
        }
        catch (Exception exception) {
            this.log(Trace.Level.DEBUG, "Error during connection close.", new Object[0]);
            Trace.logException(this, exception, true);
        }
        this.log(Trace.Level.DEBUG, "Connection closed.", new Object[0]);
    }

    @Override
    public User createUser(String name, String password, String description, String domain, vCard vcard) throws SecurityManagerException {
        User user;
        if (this.getUserName().equalsIgnoreCase("anonymous")) {
            if (!this.context.getExchange().anonymousRegistration() || this.acceptor != null && !this.acceptor.anonymousRegistration()) {
                throw new SecurityManagerException(6083, "Anonymous Registration is Currently Unavailable.");
            }
            if (domain == null) {
                domain = this.context.getDomain();
            }
            user = this.createUserAnonymous(name, password, description, domain, vcard, this.acceptor != null && this.acceptor.getConfiguration().isEnableDropBox());
        } else {
            try {
                SecurityManager security = this.getSecurityManager();
                user = security.createUser(name, password, description, vcard);
                if (domain != null) {
                    List<Organization> organizations = security.getOrganizations();
                    for (Organization organization : organizations) {
                        if (!organization.getDomain().equals(domain)) continue;
                        security.setUserOrganization(name, organization.getName().toString());
                        break;
                    }
                }
                security.addUserToGroup(name, "HTTP");
                if (this.acceptor.getConfiguration().isEnableDropBox()) {
                    user.setDropBoxOwner(true);
                    security.updateUser(user);
                }
            }
            catch (FabricConnectionException exception) {
                throw new SecurityManagerException(exception.getErrorCode(), (Throwable)exception);
            }
        }
        return user;
    }

    @Override
    public void createServiceAccessor(String nodeName, String serviceType, String serviceName, String uniqueName) throws FabricConnectionException, FabricComponentAccessorException {
        if (this.serviceAccessors.containsKey(uniqueName)) {
            throw new FabricComponentAccessorException(6000, "Service accessor with name '" + uniqueName + "' already exists.");
        }
        ServiceAccessor accessor = nodeName == null ? this.createServiceAccessor(serviceType, serviceName) : this.createServiceAccessor(nodeName, serviceType, serviceName);
        if (this.serviceAccessors.putIfAbsent(uniqueName, accessor) != null) {
            accessor.close();
            throw new FabricComponentAccessorException(6000, "Service accessor with name '" + uniqueName + "' already exists.");
        }
    }

    @Override
    public ServiceAccessor getOrCreateServiceAccessor(String serviceFullName, String uniqueName) throws FabricConnectionException, FabricComponentAccessorException {
        String serviceName;
        String serviceType;
        String nodeName;
        ServiceAccessor accessor = this.serviceAccessors.get(uniqueName);
        if (accessor != null && accessor.isOpened()) {
            return accessor;
        }
        List<String> parts = StringUtils.split(serviceFullName, '.');
        if (parts.size() > 2) {
            nodeName = parts.get(0);
            serviceType = parts.get(1);
            serviceName = parts.get(2);
        } else {
            serviceType = parts.get(0);
            serviceName = parts.get(1);
            nodeName = ModeratorUtils.extractNodeName(serviceType);
            if (nodeName != null) {
                serviceType = ModeratorUtils.extractComponentName(serviceType);
            }
        }
        accessor = nodeName == null ? this.createServiceAccessor(serviceType, serviceName) : this.createServiceAccessor(nodeName, serviceType, serviceName);
        ServiceAccessor existingAccessor = this.serviceAccessors.putIfAbsent(uniqueName, accessor);
        if (existingAccessor != null) {
            accessor.close();
            accessor = existingAccessor;
        }
        return accessor;
    }

    @Override
    public ServiceAccessor getServiceAccessor(String uniqueName) throws FabricConnectionException, FabricComponentAccessorException {
        ServiceAccessor accessor = this.serviceAccessors.get(uniqueName);
        if (accessor == null) {
            throw new FabricComponentAccessorException(6000, "Service accessor with name '" + uniqueName + "' doesn't exist.");
        }
        return accessor;
    }

    @Override
    public void createDataspaceAccessor(String nodeName, DataspaceType dataspaceType, String dataspaceName, String uniqueName) throws FabricConnectionException, FabricComponentAccessorException {
        if (this.dataspaceAccessors.containsKey(uniqueName)) {
            throw new FabricComponentAccessorException(6000, "Dataspace accessor with name '" + uniqueName + "' already exists.");
        }
        DataspaceAccessor accessor = nodeName == null ? this.createDataspaceAccessor(dataspaceType, dataspaceName) : this.createDataspaceAccessor(nodeName, dataspaceType, dataspaceName);
        if (this.dataspaceAccessors.putIfAbsent(uniqueName, accessor) != null) {
            accessor.close();
            throw new FabricComponentAccessorException(6000, "Dataspace accessor with name '" + uniqueName + "' already exists.");
        }
    }

    @Override
    public DataspaceAccessor getOrCreateDataspaceAccessor(String nodeName, DataspaceType dataspaceType, String dataspaceName, String uniqueName) throws FabricConnectionException, FabricComponentAccessorException {
        DataspaceAccessor accessor = this.dataspaceAccessors.get(uniqueName);
        if (accessor != null) {
            return accessor;
        }
        accessor = nodeName == null ? this.createDataspaceAccessor(dataspaceType, dataspaceName) : this.createDataspaceAccessor(nodeName, dataspaceType, dataspaceName);
        DataspaceAccessor existingAccessor = this.dataspaceAccessors.putIfAbsent(uniqueName, accessor);
        if (existingAccessor != null) {
            accessor.close();
            accessor = existingAccessor;
        }
        return accessor;
    }

    @Override
    public DataspaceAccessor getDataspaceAccessor(String uniqueName) throws FabricConnectionException, FabricComponentAccessorException {
        DataspaceAccessor accessor = this.dataspaceAccessors.get(uniqueName);
        if (accessor == null) {
            throw new FabricComponentAccessorException(6000, "Dataspace accessor with name '" + uniqueName + "' doesn't exist.");
        }
        return accessor;
    }

    @Override
    public SLSession getSLSession(String sessionName) throws FabricConnectionException {
        SLSession slSession = super.getSLSession(sessionName);
        if (slSession == null) {
            throw new FabricConnectionException(7009, "Session is closed.");
        }
        return slSession;
    }

    @Override
    public void authenticate() throws SecurityManagerException, FabricConnectionException {
        super.authenticate();
    }

    public void setLinkMode(LinkMode mode) {
        switch (mode) {
            case START: 
            case ATTACH: {
                this.openLinkMode = mode;
                break;
            }
            case STOP: 
            case DETACH: {
                this.closeLinkMode = mode;
            }
        }
    }

    @Override
    public EventDatagramFactory getEventDatagramFactory() {
        return EventDatagramFactory.getInstance();
    }

    @Override
    public OpaqueDatagramFactory getOpaqueDatagramFactory() {
        return OpaqueDatagramFactory.getInstance();
    }

    private void setTimeZoneParams() {
        this.timeZoneOffset = (Calendar.getInstance().get(15) + Calendar.getInstance().get(16)) / 60000;
        this.timeZoneString = TimeZone.getDefault().getDisplayName();
    }

    public int getServerTimeZoneOffset() {
        return this.timeZoneOffset;
    }

    public String getTimeZone() {
        return "";
    }

    @Override
    public void addURL(String url) {
        this.doAddURL(url);
    }

    @Override
    public PingResult ping() {
        this.log(Trace.Level.DEBUG, "Client is alive.", new Object[0]);
        return super.ping();
    }

    @Override
    public void touch() {
        this.lastAccessTime = System.currentTimeMillis();
    }

    @Override
    public void setLeasePeriod(long leasePeriod) {
        HttpSession session;
        this.leasPeriodIsDefault = false;
        if (leasePeriod == -1L) {
            leasePeriod = this.acceptor.getConfiguration().getSessionTimeout() * 1000 * 60;
        }
        this.leasePeriod = leasePeriod;
        if (this.reverseConnectionHoldTimeout > this.leasePeriod / 2L) {
            this.setReverseConnectionHoldTimeout(this.leasePeriod / 2L);
        }
        this.log(Trace.Level.DEBUG, "leasePeriod set to " + leasePeriod + " ms.", new Object[0]);
        if (this.request != null && (session = this.request.getSession(false)) != null) {
            session.setMaxInactiveInterval((int)(leasePeriod / 1000L));
        }
    }

    @Override
    public long getLeasePeriod() {
        return this.leasePeriod;
    }

    @Override
    public void setReverseConnectionHoldTimeout(long reverseConnectionHoldTimeout) {
        if (reverseConnectionHoldTimeout <= 0L) {
            reverseConnectionHoldTimeout = 10000L;
        }
        if (this.leasePeriod > 0L && reverseConnectionHoldTimeout * 2L > this.leasePeriod) {
            reverseConnectionHoldTimeout = this.leasePeriod / 2L;
            this.log(Trace.Level.ERROR, "reverseConnectionHoldTimeout should be at least two times less than leasePeriod. Setting reverseConnectionHoldTimeout to {} ms.", reverseConnectionHoldTimeout);
        }
        this.reverseConnectionHoldTimeout = reverseConnectionHoldTimeout;
        this.log(Trace.Level.DEBUG, "reverseConnectionHoldTimeout set to " + this.reverseConnectionHoldTimeout + " ms.", new Object[0]);
    }

    @Override
    public long getReverseConnectionHoldTimeout() {
        return this.reverseConnectionHoldTimeout;
    }

    @Override
    protected void setURL() {
        super.setURL();
        this.httpSessionId = this.getURL();
    }

    @Override
    public String getHttpSessionId() {
        return this.httpSessionId;
    }

    @Override
    public void setHttpSessionId(String httpSessionId) {
        this.httpSessionId = httpSessionId;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void setRemoved(boolean expired) {
        this.log(Trace.Level.DEBUG, "Set fabric connection to " + (expired ? "expired" : "removed") + ".", new Object[0]);
        if (expired) {
            this.leasePeriod = -1L;
        } else {
            this.isRemoved = true;
        }
    }

    @Override
    public boolean isRemoved() {
        return this.isRemoved || this.leasePeriod == -1L;
    }

    @Override
    public boolean isLeasePeriodExpired() {
        return this.leasePeriod == -1L;
    }

    @Override
    protected long getExpirationTime() {
        return this.leasePeriod > 0L ? (this.leasePeriod - (System.currentTimeMillis() - this.lastAccessTime)) / 1000L : -1L;
    }

    @Override
    public ImmutableEventDatagram raiseRequest(String consumerName, ImmutableEventDatagram request, long timeout) throws FabricConnectionException, FabricEventSourceException, FabricUnboundEventException, FabricRequestException {
        return this.raiseRequest(this.getModerator().lookupRequestConsumer(consumerName), request, timeout);
    }

    @Override
    public void raiseEvent(ImmutableEventDatagram event, EventScope eventScope, long timeToLive) throws FabricConnectionException, FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        if (event.getEventId().equals("event.xmpp.message")) {
            super.raiseSystemEvent(event, eventScope);
        } else {
            super.raiseEvent(event, eventScope, timeToLive);
        }
    }

    @Override
    public void bindProducerFor(String eventId) throws FabricConnectionException, FabricEventDispatcherException {
        if (!this.isBoundEventId(eventId)) {
            super.bindProducerFor(eventId);
        }
    }

    @Override
    public StaticMethodWrapper getStaticMethodWrapper(Class<?> staticMethodClass) {
        return new StaticMethodWrapper(staticMethodClass);
    }

    @Override
    public void setDomainConstraint(DomainConstraint domain) throws FabricConnectionException, FabricEventDispatcherException {
        this.dropDomainConstraint(domain.getName());
        DomainConstraint newDomain = this.createDomainConstraint(domain.getName(), domain.getDescription(), new HashSet<Object>(domain.listValues()));
        super.setDomainConstraint(newDomain);
    }

    @Override
    public void setRangeConstraint(RangeConstraint range) throws FabricConnectionException, FabricEventDispatcherException {
        RangeConstraint fabricRange = this.getRangeConstraint(range.getName());
        if (fabricRange != null) {
            try {
                fabricRange.setMinValue(range.getMinValue());
                fabricRange.setMaxValue(range.getMaxValue());
            }
            catch (InvalidRangeBoundaryTypeException exception) {
                throw new FabricEventDispatcherException(6011, "Update of range '" + range.getName() + "' failed.", exception);
            }
        } else {
            fabricRange = this.createRangeConstraint(range.getName(), range.getDescription(), range.getMinValue(), range.getMaxValue());
        }
        super.setRangeConstraint(fabricRange);
    }

    @Override
    public ReverseProcessor getReverseProcessor() {
        return this.reverseProcessor;
    }

    @Override
    public SLFileDownloadUploadRequestsHolder getSLFileDownloadUploadRequestsHolder() {
        return this.slFileDownloadUploadRequestsHolder;
    }

    @Override
    public SLAudioRequestsHolder getSLAudioRequestsHolder() {
        return this.slAudioRequestsHolder;
    }

    @Override
    public void setAuthenticationType(AuthenticationType type) throws FabricConnectionException {
        super.setAuthenticationType(type);
    }

    @Override
    public void setAuthenticationParameters(Map<String, String> parameters) throws FabricConnectionException {
        if (parameters == null) {
            parameters = new HashMap<String, String>();
        }
        super.setAuthenticationParameters(parameters);
    }

    @Override
    public HTTPEventCompletionWaiter createEventCompletionWaiter(long eventUniqueId) {
        this.log(Trace.Level.DEBUG, "Creating completion waiter, eventUniqueId: " + eventUniqueId, new Object[0]);
        HTTPEventCompletionWaiter waiter = new HTTPEventCompletionWaiter();
        this.eventCompletionWaiters.put(eventUniqueId, waiter);
        return waiter;
    }

    @Override
    public void removeEventCompletionWaiter(long eventUniqueId) {
        this.log(Trace.Level.DEBUG, "Removing completion waiter, eventUniqueId: " + eventUniqueId, new Object[0]);
        this.eventCompletionWaiters.remove(eventUniqueId);
    }

    @Override
    public void eventCompleted(long eventUniqueId, Object reply) {
        this.log(Trace.Level.DEBUG, "Event completion received, eventUniqueId: " + eventUniqueId, new Object[0]);
        HTTPEventCompletionWaiter waiter = this.eventCompletionWaiters.get(eventUniqueId);
        if (waiter != null) {
            waiter.setReply(reply);
            waiter.completed(true);
        }
    }

    public String getRuntimeVersion() {
        return Version.getVersion();
    }

    public String getSysplexDomain() {
        return this.context.getDomain();
    }

    public String getAcceptorName() {
        return this.acceptor.getName();
    }

    public List<String> listOrganizations() throws SecurityManagerException {
        return this.context.getSecurityManager().listOrganizations();
    }

    public boolean isApiKeyAuthenticationEnabled() throws SecurityManagerException {
        return this.acceptor.getConfiguration().getSessionAuthentication();
    }

    @Override
    protected void createSLFileRequestConsumer() {
        if (this.getClientId() != null && this.getClientId().getResource().equals("quilt") || this.isRest()) {
            super.createSLFileRequestConsumer();
        }
    }

    @Override
    protected FabricRequestListener createSLFileMessageListener() {
        if (this.isRest()) {
            return super.createSLFileMessageListener();
        }
        return new FabricRequestListener(){

            @Override
            public ImmutableEventDatagram onRequest(ImmutableEventDatagram event) throws FabricRequestException {
                if (event instanceof OpaqueDatagram) {
                    try {
                        SLFileMessage message = (SLFileMessage)((OpaqueDatagram)event).getData();
                        Trace.logDebug(this, "{} File operation '{}' received. SLSession name: {}", HTTPServerFabricConnectionImpl.this.toString(), message, message.getSLSessionName());
                        SLFileMessage response = new SLFileMessage();
                        response.setOperation(message.getOperation());
                        response.setFilename(message.getFilename());
                        response.setLengthProcessed(message.getLengthProcessed());
                        response.setLengthTotal(message.getLengthTotal());
                        response.setComponentName(message.getComponentName());
                        response.setSLSessionName(message.getSLSessionName());
                        response.setDstFilename(message.getDstFilename());
                        response.setRecursive(message.isRecursive());
                        response.setPermissions(message.getPermissions());
                        response.setUsername(message.getUsername());
                        response.setGroupname(message.getGroupname());
                        response.setOverwrite(message.isOverwrite());
                        switch (message.getOperation()) {
                            case CREATE: 
                            case OPEN_FOR_APPEND: 
                            case OPEN_FOR_WRITE: {
                                HTTPServerFabricConnectionImpl.this.sendSLFileMessage(message, HTTPServerFabricConnectionImpl.this.getFileTransfersDirectConsumersTimeout());
                                break;
                            }
                            case CLOSE_READING: 
                            case CLOSE_WRITING: {
                                HTTPServerFabricConnectionImpl.this.getSLFileDownloadUploadRequestsHolder().close(message);
                                break;
                            }
                            case WRITE: {
                                HTTPServerFabricConnectionImpl.this.getSLFileDownloadUploadRequestsHolder().write(message);
                                break;
                            }
                            case OPEN_FOR_READ: {
                                message.setTimeout(this.getTimeoutForSelectFiles(message));
                                Object reply = HTTPServerFabricConnectionImpl.this.sendSLFileMessage(message, message.getTimeout());
                                if (!(reply instanceof Long)) break;
                                response.setLength((Long)reply);
                                break;
                            }
                            case READ: {
                                response.setLength(message.getLength());
                                HTTPServerFabricConnectionImpl.this.getSLFileDownloadUploadRequestsHolder().read(response);
                                break;
                            }
                            case SKIP: {
                                response.setLength(message.getLength());
                                HTTPServerFabricConnectionImpl.this.getSLFileDownloadUploadRequestsHolder().skip(response);
                                break;
                            }
                            case AVAILABLE_FOR_READ: {
                                response.setLength(message.getLength());
                                HTTPServerFabricConnectionImpl.this.getSLFileDownloadUploadRequestsHolder().getAvailable(response);
                                break;
                            }
                            case LIST_DIRECTORY: {
                                message.setTimeout(this.getTimeoutForSelectFiles(message));
                                Object[] files = (Object[])HTTPServerFabricConnectionImpl.this.sendSLFileMessage(message, message.getTimeout());
                                response.setFiles(Arrays.stream(files).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList()));
                                break;
                            }
                            case FILE_SYSTEM_GET_FILE_INFO: 
                            case FILE_SYSTEM_LIST: {
                                message.setTimeout(this.getTimeoutForSelectFiles(message));
                                FileInfo[] fileInfos = (FileInfo[])HTTPServerFabricConnectionImpl.this.sendSLFileMessage(message, message.getTimeout());
                                response.setFileInfos(fileInfos);
                            }
                            case FILE_SYSTEM_COPY: 
                            case FILE_SYSTEM_MOVE: 
                            case FILE_SYSTEM_RENAME: 
                            case FILE_SYSTEM_SET_OWNER: 
                            case FILE_SYSTEM_SET_PERMISSIONS: 
                            case FILE_SYSTEM_CREATE_NEW_FILE: {
                                break;
                            }
                            case REMOVE: {
                                break;
                            }
                            case EXISTS: 
                            case IS_DIRECTORY: 
                            case CREATE_DIRECTORY: 
                            case COMPLETE: {
                                response.setNotSupported();
                            }
                        }
                        return SDOUtils.createOpaqueEvent("e.sys.sl.FileMessage", response);
                    }
                    catch (Exception exception) {
                        Trace.logException(this, exception, false);
                        throw new FabricRequestException(exception.getMessage());
                    }
                }
                throw new FabricRequestException("Wrong event datagram (received '" + event.getClass().getSimpleName() + "', expected 'OpaqueDatagram').");
            }

            private long getTimeoutForSelectFiles(SLFileMessage message) {
                long timeout = HTTPServerFabricConnectionImpl.this.getLeasePeriod() - 10000L;
                if (timeout <= 0L) {
                    timeout = 120000L;
                }
                if (message.getTimeout() != -1L) {
                    timeout = Math.min(timeout, message.getTimeout() - 3000L);
                }
                return timeout;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object sendSLFileMessage(Object message, long timeout) throws IAbstractExceptionEvent, SDOException, InterruptedException {
        HTTPEventTransmitter wrapper = null;
        try {
            wrapper = new HTTPEventTransmitter("", message);
            HTTPEventCompletionWaiter waiter = this.createEventCompletionWaiter(wrapper.getEventUniqueId());
            this.sendJson(wrapper, true);
            Trace.logDebug(this, "Waiting for confirmation on operation '" + String.valueOf(message) + "' (uid: " + wrapper.getEventUniqueId() + ").");
            waiter.waitForCompletion(timeout);
            if (!waiter.completed()) {
                throw new FabricRequestException("File operation confirmation not received from http client during " + timeout + " ms.");
            }
            Trace.logDebug(this, "Confirmation received on operation: " + String.valueOf(message) + ", unique id: " + wrapper.getEventUniqueId());
            Object reply = waiter.getReply();
            if (reply instanceof Exception) {
                throw new FabricRequestException("File operation '" + String.valueOf(message) + "' failed. Cause: " + ((Exception)reply).getMessage());
            }
            Object object = reply;
            return object;
        }
        finally {
            if (wrapper != null) {
                this.removeEventCompletionWaiter(wrapper.getEventUniqueId());
            }
        }
    }

    private void sendJson(Object object, boolean direct) throws IAbstractExceptionEvent {
        String reply = HTTPUtils.getJsonSerializerForFabric(this.getHttpRequest()).serialize(object);
        if (reply != null) {
            this.getReverseProcessor().sendReverseMessage(reply, direct);
        }
    }

    @Override
    protected void createSLAudioRequestConsumer() {
        if (this.getClientId() != null && this.getClientId().getResource().equals("quilt") || this.isRest()) {
            super.createSLAudioRequestConsumer();
        }
    }

    @Override
    protected FabricRequestListener createSLAudioMessageListener() {
        if (this.isRest()) {
            return super.createSLAudioMessageListener();
        }
        return new FabricRequestListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ImmutableEventDatagram onRequest(ImmutableEventDatagram event) throws FabricRequestException {
                if (event instanceof OpaqueDatagram) {
                    try {
                        SLAudioMessage message = (SLAudioMessage)((OpaqueDatagram)event).getData();
                        Trace.logDebug(this, "{} Audio operation '{}' received. SLSession name: {}", HTTPServerFabricConnectionImpl.this.toString(), message, message.getSLSessionName());
                        SLAudioMessage response = new SLAudioMessage();
                        response.setOperation(message.getOperation());
                        response.setComponentName(message.getComponentName());
                        response.setSLSessionName(message.getSLSessionName());
                        response.setLength(message.getLength());
                        response.setUniqueStreamId(message.getUniqueStreamId());
                        response.setBytes(message.getBytes());
                        response.setAudioFormat(message.getAudioFormat());
                        response.setResourceName(message.getResourceName());
                        switch (message.getOperation()) {
                            case CLOSE_READING: {
                                try {
                                    HTTPServerFabricConnectionImpl.this.sendSLAudioMessage(message, message.getTimeout());
                                    break;
                                }
                                finally {
                                    HTTPServerFabricConnectionImpl.this.getSLAudioRequestsHolder().close(message);
                                }
                            }
                            case OPEN_FOR_READ: {
                                HTTPServerFabricConnectionImpl.this.getSLAudioRequestsHolder().open(message);
                                try {
                                    message.setTimeout(this.getTimeoutForSelectAudio(message));
                                    Object openResponse = HTTPServerFabricConnectionImpl.this.sendSLAudioMessage(message, message.getTimeout());
                                    if (!(openResponse instanceof Object[]) || ((Object[])openResponse).length <= 0 || !(((Object[])openResponse)[0] instanceof SLAudioMessage)) break;
                                    AudioFormat audioFormat = ((SLAudioMessage)((Object[])openResponse)[0]).getAudioFormat();
                                    response.setAudioFormat(audioFormat);
                                    break;
                                }
                                catch (Exception exception) {
                                    HTTPServerFabricConnectionImpl.this.getSLAudioRequestsHolder().close(message);
                                    throw exception;
                                }
                            }
                            case READ: {
                                response.setLength(message.getLength());
                                HTTPServerFabricConnectionImpl.this.getSLAudioRequestsHolder().read(response);
                                break;
                            }
                        }
                        return SDOUtils.createOpaqueEvent("e.sys.sl.AudioMessage", response);
                    }
                    catch (Exception exception) {
                        Trace.logException(this, exception, false);
                        throw new FabricRequestException(exception.getMessage());
                    }
                }
                throw new FabricRequestException("Wrong event datagram (received '" + event.getClass().getSimpleName() + "', expected 'OpaqueDatagram').");
            }

            private long getTimeoutForSelectAudio(SLAudioMessage message) {
                long timeout = HTTPServerFabricConnectionImpl.this.getLeasePeriod() - 10000L;
                if (timeout <= 0L) {
                    timeout = 120000L;
                }
                if (message.getTimeout() != -1L) {
                    timeout = Math.min(timeout, message.getTimeout() - 3000L);
                }
                return timeout;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object sendSLAudioMessage(Object message, long timeout) throws IAbstractExceptionEvent, SDOException, InterruptedException {
        HTTPEventTransmitter wrapper = null;
        try {
            wrapper = new HTTPEventTransmitter("", message);
            HTTPEventCompletionWaiter waiter = this.createEventCompletionWaiter(wrapper.getEventUniqueId());
            this.sendJson(wrapper, true);
            Trace.logDebug(this, "Waiting for confirmation on operation '" + String.valueOf(message) + "' (uid: " + wrapper.getEventUniqueId() + ").");
            waiter.waitForCompletion(timeout);
            if (!waiter.completed()) {
                throw new FabricRequestException("Audio operation confirmation not received from http client during " + timeout + " ms.");
            }
            Trace.logDebug(this, "Confirmation received on operation: " + String.valueOf(message) + ", unique id: " + wrapper.getEventUniqueId());
            Object reply = waiter.getReply();
            if (reply instanceof Exception) {
                throw new FabricRequestException("File operation '" + String.valueOf(message) + "' failed. Cause: " + ((Exception)reply).getMessage());
            }
            Object object = reply;
            return object;
        }
        finally {
            if (wrapper != null) {
                this.removeEventCompletionWaiter(wrapper.getEventUniqueId());
            }
        }
    }

    protected User createUserAnonymous(String name, String password, String description, String domain, vCard vcard, boolean dropBoxOwner) throws SecurityManagerException {
        return super.createUserAnonymous(name, password, description, vcard, "HTTP", "Group of HTTP users", domain, dropBoxOwner);
    }

    protected boolean isRest() {
        return false;
    }

    protected HTTPClientAdvisory createAdvisory(HTTPClientAdvisory.Type type, String text) {
        return this.isRest() ? new HTTPRestClientAdvisory(type, this.getHttpSessionId(), text) : new HTTPClientAdvisory(type, this.getHttpSessionId(), text);
    }

    private void raiseClientAdvisory(HTTPClientAdvisory.Type type, String text) {
        HTTPClientAdvisory advisory = this.createAdvisory(type, text);
        try {
            this.raiseSystemAdvisory(advisory, EventScope.INHERITED);
            this.log(Trace.Level.DEBUG, "Raising client advisory " + advisory.toString(), new Object[0]);
        }
        catch (Exception exception) {
            this.log(Trace.Level.ERROR, "Raising client advisory failed. Cause: " + exception.getMessage(), new Object[0]);
        }
    }

    @Override
    protected SLSession doCreateSLSession(String nodeName, boolean isSystem) throws SLSessionException {
        return new HTTPSLSessionImpl(this, nodeName);
    }

    @Override
    public long getFileTransfersDirectConsumersTimeout() {
        return this.fileTransfersDirectConsumersTimeoutMs;
    }

    @Override
    public void setFileTransfersDirectConsumersTimeout(long fileTransfersDirectConsumersTimeoutMs) {
        this.fileTransfersDirectConsumersTimeoutMs = fileTransfersDirectConsumersTimeoutMs;
    }

    @Override
    public WarDeployer getWarDeployer(HttpServletRequest request) throws FabricConnectionException, SecurityManagerException {
        if (this.getSecurityManager().lookupUser(this.getUserName()) == null || !this.getSecurityManager().lookupUser(this.getUserName()).isAdministrator()) {
            throw new FabricConnectionException(1016, "Only administrator user can get war deployer.");
        }
        return (WarDeployer)request.getServletContext().getAttribute(WarDeployer.ATTRIBUTE);
    }

    public String toString() {
        return "[ " + this.getHttpSessionId() + ", " + this.isOpened() + ", " + this.leasePeriod + "ms ]";
    }

    @Override
    public String toStringMaxInfo() {
        String clientId;
        String string = clientId = this.getClientId() != null ? this.getClientId().toString() : null;
        if (clientId != null && this.getName().equals(clientId)) {
            clientId = "as name";
        }
        return "[ " + this.getType() + "." + this.getName() + ", isOpened: " + this.isOpened() + (String)(clientId != null ? ", clientId: " + clientId : "") + ", sessionId: " + this.getHttpSessionId() + ", user: " + this.getUserName() + ", leasePeriod: " + this.leasePeriod + "ms ]";
    }

    public void log(Trace.Level level, String message, Object ... args) {
        if (!Trace.isEnabled(this.getClass(), level)) {
            return;
        }
        message = this.toString() + " " + (String)message;
        switch (level) {
            case DEBUG: {
                Trace.logDebug(this, (String)message, args);
                break;
            }
            case INFO: {
                Trace.logInfo(this, (String)message, args);
                break;
            }
            case ERROR: {
                Trace.logError(this, (String)message, args);
                break;
            }
            default: {
                Trace.logDebug(this, (String)message, args);
            }
        }
    }

    @Override
    public HttpServletRequest getHttpRequest() {
        return this.request;
    }

    public boolean isLeasPeriodIsDefault() {
        return this.leasPeriodIsDefault;
    }
}

