/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.fabric;

import com.streamscape.cli.http.HTTPFabricConnection;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.cli.tlp.FabricConnectionFactory;
import com.streamscape.cli.tlp.FabricConnectionFactoryException;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptor;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnectionImpl;
import com.streamscape.sef.network.http.server.fabric.RESTServerFabricConnectionImpl;
import javax.servlet.http.HttpServletRequest;

public class HTTPServerFabricConnectionFactory
extends FabricConnectionFactory {
    private boolean isREST = false;
    private transient RuntimeContext context;

    public HTTPServerFabricConnectionFactory(String httpSessionId, boolean isREST, RuntimeContext context) throws FabricConnectionFactoryException {
        this.addURL(httpSessionId);
        this.setREST(isREST);
        this.setDescription(isREST ? "REST Connection" : "HTTP Connection");
        this.context = context;
    }

    @Override
    public void addURL(String url) {
        this.doAddURL(url);
    }

    @Override
    public HTTPServerFabricConnection createConnection() throws FabricConnectionFactoryException {
        return (HTTPServerFabricConnection)super.createConnection();
    }

    @Override
    protected FabricConnection createConnectionInstance() {
        return this.isREST ? new RESTServerFabricConnectionImpl(this.getType(), this.getClientName(), this.context) : new HTTPServerFabricConnectionImpl(this.getType(), this.getClientName(), this.context);
    }

    public HTTPServerFabricConnectionImpl createConnection(HTTPAcceptor acceptor, HttpServletRequest request) throws FabricConnectionFactoryException {
        HTTPServerFabricConnectionImpl result = this.isREST ? new RESTServerFabricConnectionImpl(this.getType(), this.getClientName(), this.context) : new HTTPServerFabricConnectionImpl(this.getType(), this.getClientName(), this.context);
        super.initConnectionParameters(result);
        result.init(acceptor, request);
        return result;
    }

    @Override
    public HTTPFabricConnection createConnection(String securityToken) throws FabricConnectionFactoryException {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    @Override
    protected void initBasicConnectionParameters(FabricConnection connection) throws FabricConnectionException {
        this.doInitBasicConnectionParameters(connection);
    }

    @Override
    public void setSecurityToken(String securityToken) {
        throw new UnsupportedOperationException("Operation is not supported.");
    }

    public boolean isREST() {
        return this.isREST;
    }

    public void setREST(boolean isREST) {
        this.isREST = isREST;
        this.setType(isREST ? "Client_REST" : "Client_HTTP");
    }
}

