/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.fabric;

import com.streamscape.Trace;
import com.streamscape.cli.http.HTTPClientException;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.sdo.IAbstractExceptionEvent;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.sef.FabricRequestListener;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.network.http.server.fabric.HTTPEventCompletionWaiter;
import com.streamscape.sef.network.http.server.fabric.HTTPEventTransmitter;
import com.streamscape.sef.network.http.server.fabric.HTTPFabricEventSourceFactory;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;

public class HTTPEventListener
implements FabricEventListener,
FabricRequestListener {
    private transient HTTPServerFabricConnection fabricConnection;
    private String consumerName;
    private boolean isDirectConsumer = false;
    private transient JSONSerializer jsonFabricSerializer;

    public HTTPEventListener(String consumer, boolean isDirectConsumer) {
        this.consumerName = consumer;
        this.isDirectConsumer = isDirectConsumer;
    }

    public void setFabricConnection(HTTPServerFabricConnection connection) {
        this.fabricConnection = connection;
        this.jsonFabricSerializer = HTTPUtils.getJsonSerializerForFabric(this.fabricConnection.getHttpRequest());
    }

    @Override
    public ImmutableEventDatagram onRequest(ImmutableEventDatagram request) throws FabricRequestException {
        ImmutableEventDatagram ack = null;
        try {
            if (Trace.isDebugEnabled(this.getClass())) {
                Trace.logDebug(this, "Http client request: " + request.getEventId());
            }
            HTTPEventTransmitter wrapper = new HTTPEventTransmitter(this.consumerName, request);
            if (this.isDirectConsumer) {
                ack = this.onDirectRequest(wrapper);
            } else {
                this.onAsyncEvent(wrapper);
            }
        }
        catch (FabricEventException error) {
            Trace.logError(this, "Http listener error: " + String.valueOf(error));
            throw new FabricRequestException(error);
        }
        catch (Exception error) {
            Trace.logError(this, "Http listener error on sending reply: " + String.valueOf(error));
            this.raiseHTTPClientException(error);
            throw new FabricRequestException(error);
        }
        return ack;
    }

    @Override
    public void onEvent(ImmutableEventDatagram event) throws FabricEventException {
        try {
            HTTPEventTransmitter wrapper = new HTTPEventTransmitter(this.consumerName, event);
            if (this.isDirectConsumer) {
                this.onDirectEvent(wrapper);
            } else {
                this.onAsyncEvent(wrapper);
            }
        }
        catch (FabricEventException error) {
            if (!Trace.isBroadcastEnabled(this.getClass().getName())) {
                Trace.logError(this, "Http listener error: " + String.valueOf(error));
            }
            throw error;
        }
        catch (Exception error) {
            if (!Trace.isBroadcastEnabled(this.getClass().getName())) {
                Trace.logError(this, "Http listener error on sending reply: " + String.valueOf(error));
            }
            this.raiseHTTPClientException(error);
            throw new FabricEventException(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object onDirectEvent(HTTPEventTransmitter wrapper) throws InterruptedException, IAbstractExceptionEvent {
        try {
            Object reply;
            HTTPEventCompletionWaiter waiter = this.fabricConnection.createEventCompletionWaiter(wrapper.getEventUniqueId());
            this.sendJson(wrapper, true);
            if (Trace.isDebugEnabled(this.getClass())) {
                Trace.logDebug(this, "Waiting for confirmation on event: " + ((ImmutableEventDatagram)wrapper.getEvent()).getEventId() + ", to consumer: " + this.consumerName);
            }
            try {
                waiter.waitForCompletion(this.fabricConnection.getFileTransfersDirectConsumersTimeout());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!waiter.completed()) {
                throw new FabricEventException(1018, "Event confirmation was not received from client during " + this.fabricConnection.getFileTransfersDirectConsumersTimeout() + " ms, event: " + ((ImmutableEventDatagram)wrapper.getEvent()).getEventId() + ", to consumer: " + this.consumerName);
            }
            if (Trace.isDebugEnabled(this.getClass())) {
                Trace.logDebug(this, "Confirmation was received, event: " + ((ImmutableEventDatagram)wrapper.getEvent()).getEventId() + ", to consumer: " + this.consumerName + ", reply: " + String.valueOf(waiter.getReply()));
            }
            if ((reply = waiter.getReply()) instanceof FabricEventException) {
                throw (FabricEventException)reply;
            }
            if (reply instanceof Exception) {
                throw new FabricEventException((Exception)reply);
            }
            Object object = reply;
            return object;
        }
        finally {
            this.fabricConnection.removeEventCompletionWaiter(wrapper.getEventUniqueId());
        }
    }

    protected ImmutableEventDatagram onDirectRequest(HTTPEventTransmitter wrapper) throws Exception {
        ImmutableEventDatagram ack = null;
        Object reply = this.onDirectEvent(wrapper);
        if (reply != null) {
            if (reply instanceof ImmutableEventDatagram) {
                ack = (ImmutableEventDatagram)reply;
            } else {
                if (reply instanceof Exception) {
                    throw (Exception)reply;
                }
                throw new FabricEventException(1018, "Unknown answer class, expected ImmutableEventDatagram, received: " + reply.getClass().toString());
            }
        }
        return ack;
    }

    protected void onAsyncEvent(HTTPEventTransmitter wrapper) throws IAbstractExceptionEvent {
        this.sendJson(wrapper, false);
    }

    public void raiseHTTPClientException(Exception exception) {
        try {
            HTTPClientException httpException = exception instanceof HTTPClientException ? (HTTPClientException)exception : new HTTPClientException(1018, (Throwable)exception);
            HTTPFabricEventSourceFactory.coalesce((ImmutableEventDatagram)httpException, this.fabricConnection.getFabricAddress());
            this.fabricConnection.raiseException(httpException, EventScope.INHERITED);
        }
        catch (Exception fail) {
            Trace.logError(this, "Raising http client exception failed: " + String.valueOf(fail));
        }
    }

    protected void sendJson(Object object, boolean direct) throws IAbstractExceptionEvent {
        String reply = this.jsonFabricSerializer.serialize(object);
        if (reply != null) {
            this.fabricConnection.getReverseProcessor().sendReverseMessage(reply, direct);
        }
    }
}

