/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.fabric;

import com.streamscape.Trace;
import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnectionImpl;
import com.streamscape.sef.network.http.server.fabric.ReverseProcessor;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationListener;
import org.eclipse.jetty.continuation.ContinuationSupport;

public class AsyncReverseProcessor
implements ReverseProcessor {
    private HTTPServerFabricConnectionImpl connection;
    private MessagesQueue messagesQueue;
    private final AtomicReference<Continuation> continuationReference = new AtomicReference();
    private final AtomicLong continuatiosCount = new AtomicLong(0L);
    private static final AtomicLong continuationId = new AtomicLong(0L);
    private final Object closeMutex = new Object();
    public static final String ATTRIBUTE_URL = "com.streamscape.sef.network.http.server.fabric.AsyncReverseMessagesSender.url";
    public static final String ATTRIBUTE_CONTINUATION = "com.streamscape.sef.network.http.server.fabric.AsyncReverseMessagesSender.continuation";
    public static final String ATTRIBUTE_HOLD_TIME = "com.streamscape.sef.network.http.server.fabric.AsyncReverseMessagesSender.hold.time";
    public static final String ATTRIBUTE_CONTINUATION_ID = "com.streamscape.sef.network.http.server.fabric.AsyncReverseMessagesSender.continuation.id";
    public static final String ATTRIBUTE_CONTINUATION_MUTEX = "com.streamscape.sef.network.http.server.fabric.AsyncReverseMessagesSender.continuation.mutex";
    public static final String ATTRIBUTE_CONTINUATION_COMPLETED = "com.streamscape.sef.network.http.server.fabric.AsyncReverseMessagesSender.continuation.completed";

    public AsyncReverseProcessor(HTTPServerFabricConnectionImpl connection) {
        this.connection = connection;
        this.messagesQueue = new MessagesQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void holdReverseConnection(FabricHTTPRequest url, HttpServletResponse response) throws FabricConnectionException {
        Continuation continuation = this.continuationReference.get();
        if (continuation != null) {
            this.log(Trace.Level.ERROR, "WARNING: New reverse request received while prevoius continuation {} not yet finished.", continuation.getAttribute(ATTRIBUTE_CONTINUATION_ID));
        }
        if (url.getRequest().getAttribute(ATTRIBUTE_HOLD_TIME) == null && this.messagesQueue.count() == 0 && this.connection.isOpened()) {
            Object object = this.closeMutex;
            synchronized (object) {
                long id = continuationId.incrementAndGet();
                long count = this.continuatiosCount.incrementAndGet();
                Continuation continuation2 = ContinuationSupport.getContinuation((ServletRequest)url.getRequest());
                if (continuation2.getAttribute(ATTRIBUTE_CONTINUATION_ID) != null) {
                    this.log(Trace.Level.DEBUG, continuation2, "upgraded to id {}", id);
                }
                continuation2.setTimeout(this.getReverseConnectionHoldTimeout());
                continuation2.addContinuationListener((ContinuationListener)new ContinuationListenerImpl());
                continuation2.setAttribute(ATTRIBUTE_URL, (Object)url);
                continuation2.setAttribute(ATTRIBUTE_HOLD_TIME, (Object)System.currentTimeMillis());
                continuation2.setAttribute(ATTRIBUTE_CONTINUATION, (Object)continuation2);
                continuation2.setAttribute(ATTRIBUTE_CONTINUATION_ID, (Object)id);
                continuation2.setAttribute(ATTRIBUTE_CONTINUATION_MUTEX, new Object());
                continuation2.setAttribute(ATTRIBUTE_CONTINUATION_COMPLETED, null);
                if (!this.connection.isOpened()) {
                    this.log(Trace.Level.DEBUG, continuation2, "reverse connection not hold because connection was closed", new Object[0]);
                    return;
                }
                this.log(Trace.Level.DEBUG, continuation2, "holding reverse connection, continuations count {}, timeout {} ms...", count, this.getReverseConnectionHoldTimeout());
                continuation2.suspend((ServletResponse)response);
                this.continuationReference.set(continuation2);
            }
            if (this.messagesQueue.count() > 0) {
                this.resume();
            }
        } else {
            this.sendMessages((Continuation)url.getRequest().getAttribute(ATTRIBUTE_CONTINUATION), url, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.closeMutex;
        synchronized (object) {
            this.resume();
        }
    }

    @Override
    public void sendReverseMessage(String message, boolean direct) {
        this.messagesQueue.add(message);
        this.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resume() {
        Continuation continuation = this.continuationReference.get();
        if (continuation != null) {
            this.log(Trace.Level.DEBUG, continuation, "resuming reverse connection.", new Object[0]);
            if (this.continuationReference.compareAndSet(continuation, null)) {
                Object object = continuation.getAttribute(ATTRIBUTE_CONTINUATION_MUTEX);
                synchronized (object) {
                    if (continuation.getAttribute(ATTRIBUTE_CONTINUATION_COMPLETED) == null) {
                        this.sendMessages(continuation, (FabricHTTPRequest)continuation.getAttribute(ATTRIBUTE_URL), (HttpServletResponse)continuation.getServletResponse());
                        this.complete(continuation);
                    }
                }
            }
        }
    }

    private void timeouted(Continuation continuation) {
        this.log(Trace.Level.DEBUG, continuation, "reverse connection timeouted.", new Object[0]);
        if (continuation != null && this.continuationReference.compareAndSet(continuation, null)) {
            this.sendMessages(continuation, (FabricHTTPRequest)continuation.getAttribute(ATTRIBUTE_URL), (HttpServletResponse)continuation.getServletResponse());
            this.complete(continuation);
        } else if (continuation != null) {
            this.complete(continuation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void complete(Continuation continuation) {
        Object object = continuation.getAttribute(ATTRIBUTE_CONTINUATION_MUTEX);
        synchronized (object) {
            if (continuation.getAttribute(ATTRIBUTE_CONTINUATION_COMPLETED) == null) {
                this.log(Trace.Level.DEBUG, continuation, "completing continuation", new Object[0]);
                continuation.complete();
                continuation.setAttribute(ATTRIBUTE_CONTINUATION_COMPLETED, new Object());
            } else {
                this.log(Trace.Level.DEBUG, continuation, "already completed", new Object[0]);
            }
        }
    }

    private void sendMessages(Continuation continuation, FabricHTTPRequest url, HttpServletResponse response) {
        MessagesQueue messagesToSend = this.messagesQueue.cloneAndClear();
        try {
            this.log(Trace.Level.DEBUG, continuation, "sending reply using response stream: @{}, messages count {}, messages size: {}, building response message...", Integer.toHexString(response.hashCode()), messagesToSend.count(), messagesToSend.getMessagesSize());
            long startTime = System.currentTimeMillis();
            StringBuilder messages = new StringBuilder();
            if (messagesToSend.count() > 0) {
                messages.append("[");
                Iterator<String> iterator = messagesToSend.iterator();
                if (iterator.hasNext()) {
                    messages.append(iterator.next());
                    while (iterator.hasNext()) {
                        messages.append(",");
                        messages.append(iterator.next());
                    }
                }
                messages.append("]");
            }
            long buildingTime = System.currentTimeMillis() - startTime;
            this.log(Trace.Level.DEBUG, continuation, "sending reply using response stream: @{}, messages count {}, built message size {}, building time {} ms", Integer.toHexString(response.hashCode()), messagesToSend.count(), messages.length(), buildingTime);
            response.setContentType("application/json; charset=UTF-8");
            response.getOutputStream().print(messages.toString());
            this.log(Trace.Level.DEBUG, continuation, "reply sent.", new Object[0]);
        }
        catch (Exception exception) {
            this.log(Trace.Level.ERROR, continuation, "reply failed. Cause: {}", exception.getMessage());
            long holdTime = (Long)url.getRequest().getAttribute(ATTRIBUTE_HOLD_TIME);
            if (this.connection.isRemoved() || !this.connection.isOpened() || this.connection.isClosed()) {
                this.log(Trace.Level.ERROR, continuation, "connection is opened({}) or removed({}). Clearing {} of size {} bytes reverse messages.", this.connection.isOpened(), this.connection.isRemoved(), messagesToSend.count(), messagesToSend.getMessagesSize());
            }
            if (this.connection.leasePeriod > 0L && System.currentTimeMillis() - holdTime > this.getReverseConnectionHoldTimeout() * 3L) {
                this.log(Trace.Level.ERROR, continuation, "reverse response stream was set {} ms ago (limit time {} ms). Accessed {} ms ago (lease period {} ms). Clearing {} of size {} bytes reverse messages.", System.currentTimeMillis() - holdTime, this.getReverseConnectionHoldTimeout() * 3L, System.currentTimeMillis() - this.connection.lastAccessTime, this.connection.leasePeriod, messagesToSend.count(), messagesToSend.getMessagesSize());
            }
            this.messagesQueue.prepend(messagesToSend);
        }
    }

    private long getReverseConnectionHoldTimeout() {
        return this.connection.getReverseConnectionHoldTimeout();
    }

    private void log(Trace.Level level, String message, Object ... args) {
        this.connection.log(level, message, args);
    }

    private void log(Trace.Level level, Continuation continuation, String message, Object ... args) {
        if (Trace.isEnabled(this.connection.getClass(), level)) {
            this.connection.log(level, "ContinuationId " + String.valueOf(continuation != null ? continuation.getAttribute(ATTRIBUTE_CONTINUATION_ID) : null) + ", " + message, args);
        }
    }

    public static class MessagesQueue {
        private List<String> messages = new LinkedList<String>();
        private long messagesSize = 0L;

        MessagesQueue() {
        }

        public synchronized void add(String message) {
            this.messages.add(message);
            if (message != null) {
                this.messagesSize += (long)message.length();
            }
        }

        public synchronized void prepend(MessagesQueue queue) {
            this.messages.addAll(0, queue.messages);
            this.messagesSize += queue.messagesSize;
        }

        public synchronized Iterator<String> iterator() {
            return this.messages.iterator();
        }

        public synchronized long getMessagesSize() {
            return this.messagesSize;
        }

        public synchronized int count() {
            return this.messages.size();
        }

        public synchronized MessagesQueue cloneAndClear() {
            MessagesQueue queue = new MessagesQueue();
            queue.messages = this.messages;
            queue.messagesSize = this.messagesSize;
            this.messages = new LinkedList<String>();
            this.messagesSize = 0L;
            return queue;
        }
    }

    class ContinuationListenerImpl
    implements ContinuationListener {
        ContinuationListenerImpl() {
        }

        public void onComplete(Continuation continuation) {
            long count = AsyncReverseProcessor.this.continuatiosCount.decrementAndGet();
            AsyncReverseProcessor.this.log(Trace.Level.DEBUG, continuation, "completed, continuations count: {}", count);
        }

        public void onTimeout(Continuation continuation) {
            AsyncReverseProcessor.this.timeouted(continuation);
        }
    }
}

