/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.dropbox;

import com.streamscape.Trace;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.lib.fs.client.FileCodec;
import com.streamscape.lib.fs.client.FileInfo;
import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.MergeFilesOperation;
import com.streamscape.sef.dropbox.DropBoxAccessor;
import com.streamscape.sef.dropbox.DropBoxFileSystem;
import com.streamscape.sef.dropbox.DropBoxFileSystemProxy;
import com.streamscape.sef.dropbox.DropBoxFileSystemWithNotifications;
import com.streamscape.sef.dropbox.DropBoxNotificationUtils;
import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.sef.dropbox.dsl.MputDropBoxOperation;
import com.streamscape.sef.dropbox.sdo.DropBox;
import com.streamscape.sef.dropbox.sdo.DropBoxAccessControlOperation;
import com.streamscape.sef.dropbox.sdo.DropBoxFolder;
import com.streamscape.sef.dropbox.sdo.DropBoxSharedResources;
import com.streamscape.sef.network.http.server.dropbox.DropBoxConfigurator;
import com.streamscape.sef.network.http.server.dropbox.DropBoxException;
import com.streamscape.sef.network.http.server.dropbox.DropBoxItem;
import com.streamscape.sef.network.http.server.dropbox.DropBoxService;
import com.streamscape.sef.network.http.server.dropbox.FolderType;
import com.streamscape.sef.network.http.server.dropbox.UploadedFile;
import com.streamscape.sef.network.http.server.jaxrs.exception.AbstractExceptionMapper;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import com.streamscape.sef.network.http.server.utils.MemoryFileItemFactory;
import com.streamscape.sef.network.http.server.utils.MultipartFormDataHelper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.ext.Provider;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;

@Provider
public class DropBoxServiceImpl
implements DropBoxService {
    private DropBoxConfigurator dropBoxConfigurator;
    private FabricConnection fabricConnection;
    private ServletContext servletContext;
    public static final int BUFFER_SIZE_IN_KB = 1024;
    public static final int BUFFER_SIZE_IN_KB_MAX = 102400;

    public void setFabricConnection(FabricConnection fabricConnection) {
        this.fabricConnection = fabricConnection;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void destroy() {
    }

    @Override
    public DropBoxItem[] listDropBoxes() {
        return RuntimeContext.getInstance().getDropBoxManagerRemote().listActiveDropBoxesVisibleByUser(this.fabricConnection.getUserName()).stream().filter(i -> this.isDropBoxAttached(i.getDropBoxName()) && this.isDropBoxEnabled(i.getDropBoxName())).map(i -> new DropBoxItem().setName(i.getDropBoxName()).setNodeName(i.getDropBoxNodeName()).setDropBox(true).setOwner(i.getOwner())).collect(Collectors.toList()).toArray(new DropBoxItem[0]);
    }

    @Override
    public DropBoxItem[] getTree(String path) {
        if (path == null || path.trim().length() == 0 || path.trim().equals("/")) {
            return this.listDropBoxes();
        }
        DropBox dropBox = this.checkAndGetDropBox(path);
        String dropBoxPath = this.getDropBoxPath(path);
        this.checkDropBoxEnabled(dropBox.getName());
        if (!DropBoxUtils.isEmptyOrDotPath(dropBoxPath)) {
            DropBoxUtils.checkFullAccess(dropBox, this.fabricConnection.getUserName(), DropBoxAccessControlOperation.LIST, dropBoxPath, DropBoxAccessor.DropBoxPathNotation.FOLDERS);
        }
        this.logDebug("Getting file tree for path {}", path);
        try {
            ArrayList<DropBoxItem> result = new ArrayList<DropBoxItem>();
            if (DropBoxUtils.isEmptyOrDotPath(dropBoxPath)) {
                for (DropBoxFolder folder : dropBox.getFolders()) {
                    if (!DropBoxUtils.hasFullAccessAny(dropBox, this.fabricConnection.getUserName(), folder.getName(), DropBoxAccessor.DropBoxPathNotation.FOLDERS)) continue;
                    DropBoxItem item = new DropBoxItem();
                    item.setName(folder.getName());
                    item.setNodeName(dropBox.getNodeName());
                    item.setPath(dropBox.getName());
                    item.setFile(false);
                    item.setType(folder.getType());
                    item.setExpiration(folder.getExpirationMillis());
                    item.setMaxSize(folder.getFileSizeLimitInBytes());
                    result.add(item);
                }
            } else {
                Pair<DropBoxFolder, String> pair = this.getDropBoxFolderAndPathAndThrowForbidden(dropBox, dropBoxPath);
                DropBoxFolder folder = (DropBoxFolder)pair.first;
                this.checkAccess(path, folder);
                try (FileSystem fileSystem = this.getFileSystem(dropBox);){
                    SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                    List<FileInfo> infos = fileSystem.list(dropBoxPath);
                    for (FileInfo info : infos) {
                        DropBoxItem item = new DropBoxItem();
                        item.setName(info.getName());
                        item.setPath(DropBoxUtils.normalizePath(dropBox.getName() + "/" + dropBoxPath));
                        item.setFile(!info.isDirectory());
                        DropBoxFolder folderItem = folder;
                        if (info.isDirectory()) {
                            folderItem = dropBox.getFolderByPath(Paths.get(dropBoxPath, info.getName()).toString());
                        }
                        if (folderItem == null) {
                            folderItem = folder;
                        }
                        item.setType(folderItem.getType());
                        item.setSize(info.getSize());
                        item.setLastModified(sdf.format(info.getModificationTime()));
                        item.setExpiration(folderItem.getExpirationMillis());
                        item.setMaxSize(folderItem.getFileSizeLimitInBytes());
                        result.add(item);
                    }
                }
            }
            this.logDebug("Getting file tree for path {} finished", path);
            return result.toArray(new DropBoxItem[0]);
        }
        catch (IOException exception) {
            this.logDebug("Getting file exception.", new Object[0]);
            if (Trace.isDebugEnabled(this.getClass())) {
                Trace.logException(this, exception, false);
            }
            throw new DropBoxException("Failed to get files tree.", exception);
        }
    }

    @Override
    public boolean remove(String path) {
        boolean bl;
        block10: {
            DropBox dropBox = this.checkAndGetDropBox(path);
            String dropBoxPath = this.getDropBoxPath(path);
            this.checkDropBoxEnabled(dropBox.getName());
            this.logDebug("Removing file {}", path);
            FileSystem fileSystem = this.getFileSystem(dropBox);
            try {
                DropBoxFolder folder = (DropBoxFolder)this.getDropBoxFolderAndPathAndThrowForbidden((DropBox)dropBox, (String)dropBoxPath).first;
                this.checkAccess(path, folder);
                FileInfo fileInfo = fileSystem.getInfo(dropBoxPath);
                if (folder.getName().equals(DropBoxUtils.normalizePath(dropBoxPath))) {
                    throw new ForbiddenException("Removing of top folder is not allowed.");
                }
                boolean result = fileSystem.delete(dropBoxPath, true);
                this.sendDropBoxNotification(dropBox, DropBoxNotificationUtils.DropBoxOperationType.REMOVE, fileInfo);
                this.logDebug("Removing file {} finished", path);
                bl = result;
                if (fileSystem == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (fileSystem != null) {
                        try {
                            fileSystem.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    this.logDebug("Removing file exception.", new Object[0]);
                    if (Trace.isDebugEnabled(this.getClass())) {
                        Trace.logException(this, exception, true);
                    }
                    throw new DropBoxException("Failed to remove file.", exception);
                }
            }
            fileSystem.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void download(String path, int bufferSize, int bufferSize1, HttpServletResponse response) {
        DropBox dropBox = this.checkAndGetDropBox(path);
        String dropBoxPath = this.getDropBoxPath(path);
        this.checkDropBoxEnabled(dropBox.getName());
        bufferSize = this.resolveBufferSize(bufferSize, 1024);
        bufferSize1 = this.resolveBufferSize(bufferSize1, bufferSize);
        this.logDebug("Downloading file {}, bufferSize: {}KB, bufferSize1: {}KB", path, bufferSize, bufferSize1);
        bufferSize <<= 10;
        bufferSize1 <<= 10;
        try (FileSystem fileSystem = this.getFileSystem(dropBox);){
            DropBoxFolder folder = (DropBoxFolder)this.getDropBoxFolderAndPathAndThrowForbidden((DropBox)dropBox, (String)dropBoxPath).first;
            this.checkAccess(path, folder);
            if (folder.getType() != FolderType.DOWNLOAD && folder.getType() != FolderType.UPLOAD_AND_DOWNLOAD) {
                throw new ForbiddenException("Target folder '" + folder.getPath() + "' for path '" + path + "' is not allowed for download.");
            }
            FileInfo info = fileSystem.getInfo(dropBoxPath);
            if (info.isDirectory()) {
                throw new ForbiddenException("Downloading of directories is not allowed.");
            }
            String contentType = dropBoxPath.endsWith("sco") || dropBoxPath.endsWith("sdo") ? "application/xhtml+xml" : this.servletContext.getMimeType(dropBoxPath);
            if (contentType == null) {
                contentType = "application/x-download";
            }
            response.setContentType(contentType);
            OutputStream output = null;
            try (InputStream input = fileSystem.open(dropBoxPath, bufferSize1);){
                output = response.getOutputStream();
                long length = FileIOUtils.copy(input, output, new byte[bufferSize]);
                response.setHeader("Content-Length", Long.toString(length));
                this.sendDropBoxNotification(dropBox, DropBoxNotificationUtils.DropBoxOperationType.DOWNLOAD, info);
            }
            finally {
                if (output != null) {
                    output.flush();
                }
            }
        }
        catch (UtilitiesException | IOException exception) {
            this.logDebug("Downloading exception.", new Object[0]);
            if (Trace.isDebugEnabled(this.getClass())) {
                Trace.logException(this, exception, true);
            }
            throw new DropBoxException("Failed to download file.", exception);
        }
        this.logDebug("Downloading file {} finished.", path);
    }

    @Override
    public void downloadShared(String dropBoxName, String resourceId, int bufferSize, int bufferSize1, HttpServletResponse response) {
        DropBox dropBox = this.lookupDropBox(dropBoxName);
        DropBoxSharedResources.DropBoxSharedResource resource = dropBox.getSharedResources().getResourceById(resourceId);
        if (resource == null || resource.isExpired()) {
            throw new ForbiddenException("Resource with specified ID not found or access denied.");
        }
        this.download(dropBoxName + "/" + resource.getPath(), bufferSize, bufferSize1, response);
    }

    public void setDropBoxConfigurator(DropBoxConfigurator dropBoxConfigurator) {
        this.dropBoxConfigurator = dropBoxConfigurator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UploadedFile> upload(String path, int bufferSize1, HttpServletRequest request, BiFunction<String, String, String> fileNameConverter) {
        if (fileNameConverter == null) {
            fileNameConverter = (p, fileName) -> fileName;
        }
        if (path != null && path.length() > 0) {
            DropBox dropBox = this.checkAndGetDropBox(path);
            String dropBoxPath = this.getDropBoxPath(path);
            this.checkDropBoxEnabled(dropBox.getName());
            this.checkAccess(path, (DropBoxFolder)this.getDropBoxFolderAndPathAndThrowForbidden((DropBox)dropBox, (String)dropBoxPath).first);
        }
        if (!MultipartFormDataHelper.isMultipartFormDataRequest(request)) {
            throw new BadRequestException("Upload file request should contain multipart form data.");
        }
        bufferSize1 = this.resolveBufferSize(bufferSize1, 1024);
        this.logDebug("Uploading to path {}, bufferSize1: {}KB", path, bufferSize1);
        DropBoxUploadFileItemFactory factory = new DropBoxUploadFileItemFactory(path, fileNameConverter, bufferSize1 <<= 10);
        ServletFileUpload upload = new ServletFileUpload(factory);
        try {
            upload.parseRequest(request);
        }
        catch (Exception exception) {
            if (!(exception instanceof DropBoxException)) {
                exception = exception.getCause() instanceof DropBoxException ? (Exception)exception.getCause() : new DropBoxException("File upload failed.", exception);
            }
            this.logDebug("Uploading exception.", new Object[0]);
            if (Trace.isDebugEnabled(this.getClass())) {
                Trace.logException(this, exception, true);
            }
            if (factory.items.size() <= 1) {
                throw (RuntimeException)exception;
            }
            DropBoxUploadFileItemFactory.DropBoxFileItem item = factory.items.get(factory.items.size() - 1);
            item.uploadedFile.setError(exception.getMessage());
            item.uploadedFile.setCauses(AbstractExceptionMapper.getCauses(exception).toArray(new String[0]));
        }
        finally {
            factory.items.forEach(i -> {
                if (i.outputStream != null) {
                    i.outputStream.closeAndDeletePartFile();
                }
            });
        }
        this.logDebug("Uploading file to {} finished.", path);
        return factory.items.stream().map(i -> i.uploadedFile).collect(Collectors.toList());
    }

    @Override
    public List<UploadedFile> append(String targetPath, String targetFileName, FileCodec.FileCodecType codec, Boolean close, int bufferSize1, HttpServletRequest request) {
        String fileNameExtension = FilenameUtils.getExtension(targetFileName);
        String fileNameExtensionAppend = fileNameExtension != null && fileNameExtension.length() > 0 ? "." + fileNameExtension : "";
        String targetPathInDropBox = this.getDropBoxPath(targetPath);
        String targetFilePathInDropBox = targetPathInDropBox + "/" + targetFileName;
        String targetFileNamePart = targetFileName + ".part" + fileNameExtensionAppend;
        String targetFilePartPathInDropBox = targetPathInDropBox + "/" + targetFileNamePart;
        String targetFileNamePartTmp = targetFileName + ".part." + System.currentTimeMillis() + fileNameExtensionAppend;
        String targetFilePartTmpPathInDropBox = targetPathInDropBox + "/" + targetFileNamePartTmp;
        String targetFilePartMergedTmpPathInDropBox = targetPathInDropBox + "/" + targetFileName + ".merged." + System.currentTimeMillis() + fileNameExtensionAppend;
        List<UploadedFile> uploadResult = this.upload(targetPath, bufferSize1, request, (p, fileName) -> targetFileNamePartTmp);
        if (uploadResult.size() == 0 || uploadResult.get(0).getError() != null) {
            return uploadResult;
        }
        try {
            DropBox dropBox = this.checkAndGetDropBox(targetPath);
            try (FileSystem fileSystem = this.getFileSystem(dropBox);){
                if (fileSystem.exists(targetFilePathInDropBox)) {
                    throw new BadRequestException("Target file already exist.");
                }
                this.logDebug("Merging tmp part file {} and {} to {}.", targetFilePartTmpPathInDropBox, targetFilePartPathInDropBox, targetFilePartMergedTmpPathInDropBox);
                if (fileSystem.exists(targetFilePartPathInDropBox)) {
                    MergeFilesOperation.mergeFiles(file -> DropBoxFileSystemWithNotifications.withDisabledNotifications(this.getFileSystem(dropBox)), Arrays.asList(targetFilePartPathInDropBox, targetFilePartTmpPathInDropBox), targetFilePartMergedTmpPathInDropBox, codec, null, true);
                } else {
                    DropBoxFileSystemWithNotifications.withDisabledNotifications(fileSystem).copy(targetFilePartTmpPathInDropBox, targetFilePartMergedTmpPathInDropBox);
                }
                this.logDebug("Renaming tmp merged file {} to {}.", targetFilePartMergedTmpPathInDropBox, targetFilePartPathInDropBox);
                if (fileSystem.exists(targetFilePartPathInDropBox)) {
                    fileSystem.delete(targetFilePartPathInDropBox, true);
                }
                DropBoxFileSystemWithNotifications.withDisabledNotifications(fileSystem).rename(targetFilePartMergedTmpPathInDropBox, targetFilePartPathInDropBox);
                uploadResult.get(0).getFileInfo().setName(targetFileNamePart);
                if (close.booleanValue()) {
                    this.logDebug("Renaming tmp part file {} to {}.", targetFilePartPathInDropBox, targetFilePathInDropBox);
                    fileSystem.rename(targetFilePartPathInDropBox, targetFilePathInDropBox);
                    uploadResult.get(0).getFileInfo().setName(targetFileName);
                }
            }
        }
        catch (Exception exception) {
            if (!(exception instanceof DropBoxException)) {
                exception = exception.getCause() instanceof DropBoxException ? (Exception)exception.getCause() : new DropBoxException("File upload failed.", exception);
            }
            throw (DropBoxException)exception;
        }
        return uploadResult;
    }

    @Override
    public List<UploadedFile> mput(final String targetPath, String targetFileName, FileCodec.FileCodecType codec, int partId, Boolean close, final int bufferSize1, final HttpServletRequest request) {
        class MputException
        extends RuntimeException {
            private final List<UploadedFile> uploadResult;

            public MputException(List<UploadedFile> uploadResult) {
                this.uploadResult = uploadResult;
            }

            public List<UploadedFile> getUploadResult() {
                return this.uploadResult;
            }
        }
        try {
            final ArrayList<UploadedFile> uploadResult = new ArrayList<UploadedFile>();
            String resultFileName = MputDropBoxOperation.mput(new MputDropBoxOperation.MputHelper(){

                @Override
                public DropBox checkAndGetDropBox(String targetFile) {
                    return DropBoxServiceImpl.this.checkAndGetDropBox(targetPath);
                }

                @Override
                public FileSystem getFileSystem(DropBox dropBox) {
                    return DropBoxServiceImpl.this.getFileSystem(dropBox);
                }

                @Override
                public void uploadFile(String sourceFile, String targetPathInDropBox, String targetFileNamePart) {
                    uploadResult.addAll(DropBoxServiceImpl.this.upload(targetPath, bufferSize1, request, (p, fileName) -> targetFileNamePart));
                    if (uploadResult.size() == 0 || ((UploadedFile)uploadResult.get(0)).getError() != null) {
                        throw new MputException(uploadResult);
                    }
                }
            }, null, targetPath + "/" + targetFileName, partId, codec, close);
            ((UploadedFile)uploadResult.get(0)).getFileInfo().setName(resultFileName);
            return uploadResult;
        }
        catch (MputException exception) {
            return exception.getUploadResult();
        }
    }

    private void sendDropBoxNotification(DropBox dropBox, DropBoxNotificationUtils.DropBoxOperationType operationType, FileInfo fileInfo) {
        DropBoxNotificationUtils.sendDropBoxNotification(this.fabricConnection, dropBox, this.fabricConnection.getUserName(), this.dropBoxConfigurator.getAcceptorConfiguration().getName(), operationType, fileInfo);
    }

    private int resolveBufferSize(int bufferSize, int defaultSize) {
        if (bufferSize <= 0) {
            bufferSize = defaultSize;
        }
        if (bufferSize > 102400) {
            Trace.logError(this, "WARNING: buffer size " + bufferSize + " is greater than max allowed 102400.");
            bufferSize = 102400;
        }
        return bufferSize;
    }

    private FileSystem getFileSystem(DropBox dropBox) {
        DropBoxAccessor accessor = RuntimeContext.getInstance().getDropBoxManagerRemote().createDropBoxAccessor(dropBox.getName());
        try {
            FileSystem fileSystem = accessor.createFileSystem(this.fabricConnection.getUserName(), DropBoxAccessor.DropBoxPathNotation.FOLDERS);
            if (fileSystem instanceof DropBoxFileSystemProxy) {
                ((DropBoxFileSystemProxy)fileSystem).setCloseAccessorOnClose();
            }
            return fileSystem;
        }
        catch (Exception exception) {
            accessor.close();
            throw exception;
        }
    }

    private String getDropBoxName(String path) {
        Path pathPath = Paths.get(DropBoxUtils.normalizePath(path), new String[0]);
        if (pathPath == null || pathPath.getNameCount() <= 0) {
            throw new DropBoxException("Invalid path '" + path + "'. Doesn't contain dropbox name.").status(400);
        }
        return pathPath.getName(0).toFile().getName();
    }

    private String getDropBoxPath(String path) {
        Path pathPath = Paths.get(DropBoxUtils.normalizePath(path), new String[0]);
        if (pathPath.getNameCount() <= 0) {
            throw new DropBoxException("Invalid path '" + path + "'. Doesn't contain dropbox name.").status(400);
        }
        if (pathPath.getNameCount() == 1) {
            return ".";
        }
        return DropBoxUtils.normalizePath(pathPath.subpath(1, pathPath.getNameCount()).toString());
    }

    private void checkDropBoxEnabled() {
        if (!this.dropBoxConfigurator.getAcceptorConfiguration().isEnableDropBox()) {
            throw new DropBoxException("DropBox is not enabled on this acceptor.").status(404);
        }
    }

    private boolean isDropBoxAttached(String name) {
        return true;
    }

    private void checkDropBoxAttached(String name) {
        if (!this.isDropBoxAttached(name)) {
            throw new DropBoxException("DropBox '" + name + "' name is not attached to this acceptor.").status(404);
        }
    }

    private void checkDropBoxEnabled(String name) {
        if (!this.isDropBoxEnabled(name)) {
            throw new DropBoxException("DropBox '" + name + "' is disabled.").status(403);
        }
    }

    private boolean isDropBoxEnabled(String name) {
        try {
            return this.lookupDropBox(name).isEnabled();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private DropBox checkAndGetDropBox(String path) {
        this.checkDropBoxEnabled();
        String name = this.getDropBoxName(path);
        this.checkDropBoxAttached(name);
        return this.lookupDropBox(name);
    }

    private DropBox lookupDropBox(String name) {
        DropBox dropBox = RuntimeContext.getInstance().getDropBoxManagerRemote().lookupDropBox(name);
        if (dropBox == null) {
            throw new DropBoxException("DropBox with name '" + name + "' doesn't exist.").status(404);
        }
        return dropBox;
    }

    private void checkAccess(String path, DropBoxFolder folder) {
        if (folder == null) {
            throw new DropBoxException("Target folder for path '" + path + "' doesn't exist.").status(403);
        }
        if (folder.getType() == FolderType.DISABLED) {
            throw new DropBoxException("Target folder for path '" + path + "' is disabled.").status(403);
        }
    }

    private Pair<DropBoxFolder, String> getDropBoxFolderAndPathAndThrowForbidden(DropBox dropBox, String path) {
        try {
            return DropBoxUtils.getDropBoxFolderAndPath(dropBox, path);
        }
        catch (Exception exception) {
            throw new ForbiddenException(exception.getMessage());
        }
    }

    private void logDebug(String message, Object ... args) {
        this.dropBoxConfigurator.logDebug(message, args);
    }

    private void logInfo(String message, Object ... args) {
        this.dropBoxConfigurator.logInfo(message, args);
    }

    private void logError(String message, Object ... args) {
        this.dropBoxConfigurator.logError(message, args);
    }

    class DropBoxUploadFileItemFactory
    implements FileItemFactory {
        private DropBox dropBox;
        private String path;
        private PathFileItem pathFileItem;
        private String fullPath;
        private List<DropBoxFileItem> items = new ArrayList<DropBoxFileItem>();
        private BiFunction<String, String, String> fileNameConverter;
        private int bufferSize1;

        DropBoxUploadFileItemFactory(String path, BiFunction<String, String, String> fileNameConverter, int bufferSize1) {
            this.path = path;
            this.fileNameConverter = fileNameConverter;
            this.bufferSize1 = bufferSize1;
        }

        @Override
        public FileItem createItem(String fieldName, String contentType, boolean isFormField, String fileName) {
            DropBoxFileItem dropBoxFileItem;
            block17: {
                fileName = this.fileNameConverter.apply(this.path, fileName);
                if (isFormField) {
                    if (fieldName.toLowerCase().equals("path") && this.items.size() == 0) {
                        this.path = null;
                        this.fullPath = null;
                        this.pathFileItem = new PathFileItem(contentType, fieldName);
                        return this.pathFileItem;
                    }
                    return new MemoryFileItemFactory.MemoryFileItem(contentType, fieldName, fileName, isFormField, 10240);
                }
                if ((this.path == null || this.path.length() == 0) && this.pathFileItem == null) {
                    throw new DropBoxException("File path is not specified or located after file data in form parameters. In that case use query parameter 'path'.").status(400);
                }
                if (this.pathFileItem != null) {
                    byte[] valueBytes = new byte[10240];
                    this.pathFileItem.getInputStream().read(valueBytes);
                    this.path = HTTPUtils.removeTrailingNullsForString(valueBytes);
                    this.pathFileItem = null;
                    DropBoxServiceImpl.this.logDebug("Path in form data {}.", this.path);
                }
                this.dropBox = DropBoxServiceImpl.this.checkAndGetDropBox(this.path);
                this.path = DropBoxServiceImpl.this.getDropBoxPath(this.path);
                DropBoxServiceImpl.this.checkDropBoxEnabled(this.dropBox.getName());
                DropBoxFolder folder = (DropBoxFolder)DropBoxServiceImpl.this.getDropBoxFolderAndPathAndThrowForbidden((DropBox)this.dropBox, (String)this.path).first;
                DropBoxServiceImpl.this.checkAccess(this.path, folder);
                FileSystem fileSystem = DropBoxServiceImpl.this.getFileSystem(this.dropBox);
                try {
                    if (this.fullPath == null) {
                        this.fullPath = this.path;
                        if (!fileSystem.isDirectory(this.fullPath)) {
                            throw new DropBoxException("Target path '" + this.path + "' is not a directory.").status(404);
                        }
                        if (folder.getType() != FolderType.UPLOAD && folder.getType() != FolderType.UPLOAD_AND_DOWNLOAD) {
                            throw new DropBoxException("Target folder '" + folder.getPath() + "' for path '" + this.path + "' is not allowed for upload.").status(403);
                        }
                    }
                    DropBoxServiceImpl.this.logDebug("Uploading file {} to {}", fileName, this.path);
                    fileName = this.fileNameConverter.apply(this.fullPath, fileName);
                    DropBoxFileItem item = new DropBoxFileItem(fieldName, contentType, isFormField, fileName, folder);
                    this.items.add(item);
                    if (fileSystem.exists(item.targetFilePath)) {
                        throw new DropBoxException("Target file '" + item.targetFilePath + "' already exists.").status(403);
                    }
                    dropBoxFileItem = item;
                    if (fileSystem == null) break block17;
                }
                catch (Throwable throwable) {
                    try {
                        if (fileSystem != null) {
                            try {
                                fileSystem.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        if (exception instanceof DropBoxException) {
                            throw (DropBoxException)exception;
                        }
                        throw new DropBoxException("Failed to upload file.", exception);
                    }
                }
                fileSystem.close();
            }
            return dropBoxFileItem;
        }

        class PathFileItem
        extends MemoryFileItemFactory.MemoryFileItem {
            PathFileItem(String contentType, String fieldName) {
                super(contentType, fieldName, null, true, 10240);
            }
        }

        class DropBoxFileItem
        implements FileItem {
            private String fileName;
            private boolean isFormField;
            private String contentType;
            private String fieldName;
            private String targetFilePath;
            private String targetFilePathPart;
            private UploadedFile uploadedFile;
            private Exception exception;
            private DropBoxFolder folder;
            private DropBoxFileItemOutputStream outputStream;

            public DropBoxFileItem(String fieldName, String contentType, boolean isFormField, String fileName, DropBoxFolder folder) {
                this.fieldName = fieldName;
                this.contentType = contentType;
                this.isFormField = isFormField;
                this.fileName = fileName;
                this.folder = folder;
                this.targetFilePath = Paths.get(DropBoxUploadFileItemFactory.this.path, fileName).normalize().toString();
                this.targetFilePathPart = this.targetFilePath + "_part_" + System.currentTimeMillis();
                this.uploadedFile = new UploadedFile();
                this.uploadedFile.setFileInfo(new FileInfo(fileName, DropBoxUploadFileItemFactory.this.path));
            }

            @Override
            public OutputStream getOutputStream() throws IOException {
                if (this.outputStream == null) {
                    this.outputStream = new DropBoxFileItemOutputStream();
                }
                return this.outputStream;
            }

            @Override
            public String getContentType() {
                return this.contentType;
            }

            @Override
            public String getName() {
                return this.fieldName;
            }

            @Override
            public String getFieldName() {
                return this.fieldName;
            }

            @Override
            public void setFieldName(String fieldName) {
                this.fieldName = fieldName;
            }

            @Override
            public boolean isFormField() {
                return this.isFormField;
            }

            @Override
            public void setFormField(boolean isFormField) {
                this.isFormField = isFormField;
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return null;
            }

            @Override
            public boolean isInMemory() {
                return false;
            }

            @Override
            public long getSize() {
                return 0L;
            }

            @Override
            public byte[] get() {
                return null;
            }

            @Override
            public String getString(String encoding) throws UnsupportedEncodingException {
                return null;
            }

            @Override
            public String getString() {
                return null;
            }

            @Override
            public void write(File file) throws Exception {
            }

            @Override
            public void delete() {
            }

            class DropBoxFileItemOutputStream
            extends OutputStream {
                private final FileSystem fileSystem;
                private BufferedOutputStream outputStream;
                private long size = 0L;

                DropBoxFileItemOutputStream() {
                    try {
                        DropBoxServiceImpl.this.logDebug("Creating output stream to file {}, bufferSize1: {}B", DropBoxFileItem.this.targetFilePathPart, DropBoxUploadFileItemFactory.this.bufferSize1);
                        this.fileSystem = DropBoxServiceImpl.this.getFileSystem(DropBoxUploadFileItemFactory.this.dropBox);
                        this.outputStream = new BufferedOutputStream(this.fileSystem.create(DropBoxFileItem.this.targetFilePathPart, false, null, DropBoxUploadFileItemFactory.this.bufferSize1), DropBoxUploadFileItemFactory.this.bufferSize1);
                    }
                    catch (Exception exception2) {
                        DropBoxException exception2 = new DropBoxException("Failed to create part file '" + DropBoxFileItem.this.targetFilePathPart + "'.", exception2);
                        throw exception2;
                    }
                }

                @Override
                public void write(int b) throws IOException {
                    try {
                        this.outputStream.write(b);
                        ++this.size;
                    }
                    catch (Exception exception2) {
                        DropBoxException exception2 = new DropBoxException("Failed to write file.", exception2);
                        throw exception2;
                    }
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    long fileSizeLimitInBytes = DropBoxFileItem.this.folder.getFileSizeLimitInBytes();
                    if (fileSizeLimitInBytes > 0L && this.size + (long)len > fileSizeLimitInBytes) {
                        DropBoxFileItem.this.exception = new DropBoxException("File exceeds maximum allowed size " + DropBoxFileItem.this.folder.getFolderSizeLimitString() + " for folder '" + DropBoxFileItem.this.folder.getPath() + "'.").status(403);
                        throw (DropBoxException)DropBoxFileItem.this.exception;
                    }
                    try {
                        this.outputStream.write(b, off, len);
                        this.size += (long)len;
                    }
                    catch (Exception exception2) {
                        DropBoxException exception2 = new DropBoxException("Failed to write file.", exception2);
                        throw exception2;
                    }
                }

                @Override
                public void close() {
                    block14: {
                        block12: {
                            if (this.outputStream != null) {
                                try {
                                    DropBoxServiceImpl.this.logDebug("Closing output stream to file {}", DropBoxFileItem.this.targetFilePathPart);
                                    this.outputStream.close();
                                    this.outputStream = null;
                                }
                                catch (Exception exception1) {
                                    if (DropBoxFileItem.this.exception != null) break block12;
                                    DropBoxFileItem.this.exception = new DropBoxException("Failed to close file.", exception1);
                                }
                            }
                        }
                        if (DropBoxFileItem.this.exception == null) {
                            try {
                                DropBoxServiceImpl.this.logDebug("Renaming file {} to {}", DropBoxFileItem.this.targetFilePathPart, DropBoxFileItem.this.targetFilePath);
                                ((DropBoxFileSystem)this.fileSystem).renameInternal(DropBoxFileItem.this.targetFilePathPart, DropBoxFileItem.this.targetFilePath);
                            }
                            catch (Exception error) {
                                DropBoxFileItem.this.exception = new DropBoxException("Failed to rename part '" + DropBoxFileItem.this.targetFilePathPart + "' to '" + DropBoxFileItem.this.targetFilePath + "'.", error);
                            }
                        }
                        this.closeAndDeletePartFile();
                        if (DropBoxFileItem.this.exception == null) {
                            block13: {
                                try {
                                    DropBoxServiceImpl.this.logDebug("Getting file info for file {}", DropBoxFileItem.this.targetFilePath);
                                    DropBoxFileItem.this.uploadedFile.setFileInfo(this.fileSystem.getInfo(DropBoxFileItem.this.targetFilePath));
                                }
                                catch (Exception exception) {
                                    DropBoxServiceImpl.this.logDebug("Failed to get file info for file '" + DropBoxFileItem.this.targetFilePath + "'.", new Object[0]);
                                    if (!Trace.isDebugEnabled(this.getClass())) break block13;
                                    Trace.logException(this, exception, true);
                                }
                            }
                            DropBoxServiceImpl.this.sendDropBoxNotification(DropBoxUploadFileItemFactory.this.dropBox, DropBoxNotificationUtils.DropBoxOperationType.UPLOAD, DropBoxFileItem.this.uploadedFile.getFileInfo());
                        }
                        try {
                            this.fileSystem.close();
                        }
                        catch (IOException e) {
                            if (!Trace.isDebugEnabled(this.getClass())) break block14;
                            Trace.logException(this, DropBoxFileItem.this.exception, true);
                        }
                    }
                    if (DropBoxFileItem.this.exception != null) {
                        throw (DropBoxException)DropBoxFileItem.this.exception;
                    }
                }

                public void closeAndDeletePartFile() {
                    if (this.outputStream != null) {
                        try {
                            DropBoxServiceImpl.this.logDebug("Closing output stream to file {}", DropBoxFileItem.this.targetFilePathPart);
                            this.outputStream.close();
                            this.outputStream = null;
                        }
                        catch (Exception exception1) {
                            DropBoxServiceImpl.this.logError("Failed to close part file output stream '" + DropBoxFileItem.this.targetFilePathPart + "'.", new Object[0]);
                            Trace.logException(this, DropBoxFileItem.this.exception, true);
                        }
                    }
                    try {
                        if (DropBoxFileItem.this.targetFilePathPart != null) {
                            DropBoxServiceImpl.this.logDebug("Removing file {}", DropBoxFileItem.this.targetFilePathPart);
                            this.fileSystem.delete(DropBoxFileItem.this.targetFilePathPart, false);
                            DropBoxFileItem.this.targetFilePathPart = null;
                        }
                    }
                    catch (Exception exception) {
                        DropBoxServiceImpl.this.logError("Failed to delete part file '" + DropBoxFileItem.this.targetFilePathPart + "'.", new Object[0]);
                        Trace.logException(this, exception, false);
                    }
                }
            }
        }
    }
}

