/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.dropbox;

import com.streamscape.lib.fs.client.FileCodec;
import com.streamscape.sef.network.http.server.dropbox.DropBoxItem;
import com.streamscape.sef.network.http.server.dropbox.DropBoxService;
import com.streamscape.sef.network.http.server.dropbox.UploadedFile;
import com.streamscape.sef.network.http.server.jaxrs.AuthorizedRequestFilterAnnotation;
import com.streamscape.sef.network.http.server.jaxrs.exception.HttpResourceError;
import com.streamscape.sef.network.http.server.jaxrs.injection.ServiceInject;
import com.streamscape.sef.network.http.server.jaxrs.swagger.FileParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/")
@AuthorizedRequestFilterAnnotation
@Api(tags={"DropBox"}, produces="application/json", consumes="application/json")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ApiResponses(value={@ApiResponse(code=400, message="Bad request", response=HttpResourceError.class), @ApiResponse(code=401, message="Unauthorized", response=HttpResourceError.class), @ApiResponse(code=405, message="Invalid arguments", response=HttpResourceError.class), @ApiResponse(code=406, message="Server error", response=HttpResourceError.class), @ApiResponse(code=500, message="Internal server error", response=HttpResourceError.class)})
public class DropBoxResource {
    @ServiceInject
    DropBoxService dropBoxService;

    @Path(value="/list")
    @GET
    @ApiOperation(value="Gets list of available DropBoxes for current user.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=DropBoxItem[].class)})
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response getList() {
        return Response.ok((Object)this.dropBoxService.listDropBoxes()).build();
    }

    @Path(value="/tree")
    @GET
    @ApiOperation(value="Gets files and directories tree for the specified path.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=DropBoxItem[].class), @ApiResponse(code=403, message="Access to specified path is not allowed", response=HttpResourceError.class)})
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response getTree(@ApiParam(value="Path of the tree root in format <dropboxname>/<path>. If not specified means list of DropBoxes.", required=false) @QueryParam(value="path") @DefaultValue(value="") String path) {
        return Response.ok((Object)this.dropBoxService.getTree(path)).build();
    }

    @Path(value="/remove")
    @GET
    @ApiOperation(value="Removes specified file or directory.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="File not found", response=HttpResourceError.class), @ApiResponse(code=403, message="Access to specified path is not allowed", response=HttpResourceError.class)})
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response remove(@ApiParam(value="Path of the file to be removed in format <dropboxname>/<path>.", required=true) @QueryParam(value="path") String path) {
        this.dropBoxService.remove(path);
        return Response.ok((Object)"OK").build();
    }

    @Path(value="/download/{path:.*}")
    @GET
    @ApiOperation(value="Downloads specified file.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=byte[].class), @ApiResponse(code=404, message="File not found", response=HttpResourceError.class), @ApiResponse(code=403, message="Access to specified path is not allowed", response=HttpResourceError.class)})
    @Produces(value={"application/json", "*/*"})
    @Consumes(value={"application/json"})
    public void download1(@ApiParam(value="Path of the file to be downloaded in format <dropboxname>/<path>.", required=true) @PathParam(value="path") String path, @ApiParam(value="Size of buffer used to send data to client in KB. If not set, zero or negative default value 1024 KB will be used.", required=false) @QueryParam(value="bufferSize") @DefaultValue(value="0") int bufferSize, @ApiParam(value="Size of buffer used to read data from target file system in KB. If not set, zero or negative value will be equal to value of bufferSize.", required=false) @QueryParam(value="bufferSize1") @DefaultValue(value="0") int bufferSize1, @Context HttpServletResponse response) {
        this.dropBoxService.download(path, bufferSize, bufferSize1, response);
    }

    @Path(value="/share/{dropBoxName}/{resourceId}")
    @GET
    @ApiOperation(value="Downloads shared file.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=byte[].class), @ApiResponse(code=404, message="File not found", response=HttpResourceError.class), @ApiResponse(code=403, message="Access to specified path is not allowed", response=HttpResourceError.class)})
    @Produces(value={"application/json", "*/*"})
    @Consumes(value={"application/json"})
    public void downloadShared(@ApiParam(value="DropBox name.", required=true) @PathParam(value="dropBoxName") String dropBoxName, @ApiParam(value="Resource ID.", required=true) @PathParam(value="resourceId") String resourceId, @ApiParam(value="Size of buffer used to send data to client in KB. If not set, zero or negative default value 1024 KB will be used.", required=false) @QueryParam(value="bufferSize") @DefaultValue(value="0") int bufferSize, @ApiParam(value="Size of buffer used to read data from target file system in KB. If not set, zero or negative value will be equal to value of bufferSize.", required=false) @QueryParam(value="bufferSize1") @DefaultValue(value="0") int bufferSize1, @Context HttpServletResponse response) {
        this.dropBoxService.downloadShared(dropBoxName, resourceId, bufferSize, bufferSize1, response);
    }

    @Path(value="/upload")
    @POST
    @ApiOperation(value="Uploads specified file.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=UploadedFile[].class), @ApiResponse(code=404, message="Target folder not found", response=HttpResourceError.class), @ApiResponse(code=403, message="Access to specified target path is not allowed or target file exists", response=HttpResourceError.class)})
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    public Response upload(@ApiParam(value="Target path of the file to be uploaded in format <dropboxname>/<path>. Can be specified in query or in multipart/form-data.", required=false) @FormParam(value="path") @DefaultValue(value="") String path, @ApiParam(value="File to be uploaded.", required=true) @FileParam(value="file") String file, @ApiParam(value="Size of buffer used to write data to target file system in KB.  If not set, zero or negative default value 1024 KB will be used.", required=false) @FormParam(value="bufferSize1") @DefaultValue(value="0") int bufferSize1, @Context HttpServletRequest request) {
        return Response.ok(this.dropBoxService.upload(path, bufferSize1, request)).build();
    }

    @Path(value="/append")
    @POST
    @ApiOperation(value="Uploads specified file and appendes it to target file using specified codec.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=UploadedFile[].class), @ApiResponse(code=404, message="Target folder not found", response=HttpResourceError.class), @ApiResponse(code=403, message="Access to specified target path is not allowed or target file exists", response=HttpResourceError.class)})
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    public Response append(@ApiParam(value="Target path of the file to be appended in format <dropboxname>/<path>. Can be specified in query or in multipart/form-data.", required=true) @FormParam(value="path") String path, @ApiParam(value="Target file name.", required=true) @FormParam(value="fileName") String fileName, @ApiParam(value="File to be uploaded.", required=true) @FileParam(value="file") String file, @ApiParam(value="Codec to merge files BINARY or AUDIO.", required=true) @FormParam(value="codec") FileCodec.FileCodecType codec, @ApiParam(value="If set then it is a last part and need to close the file.", required=false) @FormParam(value="close") @DefaultValue(value="false") Boolean close, @ApiParam(value="Size of buffer used to write data to target file system in KB.  If not set, zero or negative default value 1024 KB will be used.", required=false) @FormParam(value="bufferSize1") @DefaultValue(value="0") int bufferSize1, @Context HttpServletRequest request) {
        return Response.ok(this.dropBoxService.append(path, fileName, codec, close, bufferSize1, request)).build();
    }

    @Path(value="/mput")
    @POST
    @ApiOperation(value="Uploads specified file and assigns name like <filename>.part.<partId>.<ext>.\nIf close is true then uploaded files merged into one file <filename> and all parts are deleted.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=UploadedFile[].class), @ApiResponse(code=404, message="Target folder not found", response=HttpResourceError.class), @ApiResponse(code=403, message="Access to specified target path is not allowed or target file exists", response=HttpResourceError.class)})
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    public Response mput(@ApiParam(value="Target path of the file to be appended in format <dropboxname>/<path>/<targetFileName>. Can be specified in query or in multipart/form-data.", required=false) @FormParam(value="path") @DefaultValue(value="") String path, @ApiParam(value="Target file name.", required=true) @FormParam(value="fileName") String fileName, @ApiParam(value="File to be uploaded.", required=true) @FileParam(value="file") String file, @ApiParam(value="Codec to merge files BINARY or AUDIO.", required=true) @FormParam(value="codec") FileCodec.FileCodecType codec, @ApiParam(value="Part ID for this file.", required=true) @FormParam(value="partId") Integer partId, @ApiParam(value="If set then it is a last part and all parts will be merged to target file name and removed.", required=false) @FormParam(value="close") @DefaultValue(value="false") Boolean close, @ApiParam(value="Size of buffer used to write data to target file system in KB.  If not set, zero or negative default value 1024 KB will be used.", required=false) @FormParam(value="bufferSize1") @DefaultValue(value="0") int bufferSize1, @Context HttpServletRequest request) {
        return Response.ok(this.dropBoxService.mput(path, fileName, codec, partId, close, bufferSize1, request)).build();
    }
}

