/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.dropbox;

import com.streamscape.sef.network.http.server.dropbox.FolderType;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;

public class DropBoxFolderDescriptor {
    private String name;
    private FolderType type;
    private Set<String> organizations;
    private long fileSizeLimit = -1L;
    private long expiration = -1L;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = DropBoxFolderDescriptor.normalizeName(name);
    }

    public FolderType getType() {
        return this.type;
    }

    public void setType(FolderType type) {
        this.type = type;
    }

    public long getFileSizeLimit() {
        return this.fileSizeLimit;
    }

    public void setFileSizeLimit(long fileSizeLimit) {
        this.fileSizeLimit = fileSizeLimit;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    public synchronized Set<String> getOrganizations() {
        if (this.organizations == null) {
            return null;
        }
        return new TreeSet<String>(this.organizations);
    }

    public synchronized void setOrganizations(Collection<String> organizations) {
        this.organizations = organizations == null ? null : new TreeSet<String>(organizations);
    }

    public synchronized void setOrganizations(String ... organizations) {
        this.setOrganizations(Arrays.asList(organizations));
    }

    public synchronized void addOrganization(String ... organizations) {
        this.addOrganizations(Arrays.asList(organizations));
    }

    public synchronized void addOrganizations(Collection<String> organizations) {
        if (this.organizations == null) {
            this.organizations = new TreeSet<String>();
        }
        this.organizations.addAll(organizations);
    }

    public synchronized void removeOrganization(String ... organizations) {
        this.removeOrganizations(Arrays.asList(organizations));
    }

    public synchronized void removeOrganizations(Collection<String> organizations) {
        if (this.organizations == null) {
            return;
        }
        this.organizations.removeAll(organizations);
    }

    public boolean equalsName(String name) {
        return Paths.get(DropBoxFolderDescriptor.normalizeName(this.name), new String[0]).equals(Paths.get(DropBoxFolderDescriptor.normalizeName(name), new String[0]));
    }

    public boolean isParentOf(String name) {
        return Paths.get(DropBoxFolderDescriptor.normalizeName(name), new String[0]).startsWith(Paths.get(DropBoxFolderDescriptor.normalizeName(this.name), new String[0])) && !this.equalsName(name);
    }

    public boolean isChildOf(String name) {
        return Paths.get(DropBoxFolderDescriptor.normalizeName(this.name), new String[0]).startsWith(Paths.get(DropBoxFolderDescriptor.normalizeName(name), new String[0])) && !this.equalsName(name);
    }

    public static String normalizeName(String name) {
        while (name.length() > 0 && (name.charAt(0) == '/' || name.charAt(0) == '\\')) {
            name = name.substring(1);
        }
        name = Paths.get(name, new String[0]).normalize().toString();
        while (name.length() > 0 && (name.charAt(name.length() - 1) == '/' || name.charAt(name.length() - 1) == '\\')) {
            name = name.substring(0, name.length() - 1);
        }
        name = name.replace('\\', '/');
        return name;
    }

    public String toString() {
        return "DropBoxFolderDescriptor{name='" + this.name + "', type=" + String.valueOf((Object)this.type) + ", organizations=" + String.valueOf(this.organizations) + ", fileSizeLimit=" + this.fileSizeLimit + ", expiration=" + this.expiration + "}";
    }
}

