/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.dropbox;

import com.streamscape.Trace;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptor;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptorConfiguration;
import com.streamscape.sef.network.http.server.authentication.AuthenticationManager;
import com.streamscape.sef.network.http.server.config.RealmInfo;
import com.streamscape.sef.network.http.server.dropbox.DropBoxExceptionMapper;
import com.streamscape.sef.network.http.server.dropbox.DropBoxInjectionResolver;
import com.streamscape.sef.network.http.server.dropbox.DropBoxResource;
import com.streamscape.sef.network.http.server.dropbox.DropBoxSwaggerResource;
import com.streamscape.sef.network.http.server.jaxrs.WsConfig;
import com.streamscape.sef.network.http.server.jaxrs.WsModel;
import com.streamscape.sef.network.http.server.jaxrs.WsServletContainer;
import com.streamscape.sef.network.http.server.jaxrs.injection.InjectionContext;
import com.streamscape.sef.network.http.server.jaxrs.injection.InjectionContextConfigurator;
import javax.servlet.Servlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class DropBoxConfigurator
implements InjectionContextConfigurator {
    private HTTPAcceptor acceptor;

    public void configure(ServletContextHandler context, HTTPAcceptor acceptor, AuthenticationManager authenticationManager) {
        this.acceptor = acceptor;
        if (!acceptor.getConfiguration().isEnableDropBox()) {
            this.logInfo("DropBox is disabled on this acceptor. Don't start DropBox servlet.", new Object[0]);
            return;
        }
        this.configureServlet(context, acceptor);
        this.configureRealm(acceptor, authenticationManager);
        this.logInfo("DropBox configured.", new Object[0]);
    }

    private void configureServlet(ServletContextHandler context, HTTPAcceptor acceptor) {
        this.logDebug("Configuring DropBox Servlet...", new Object[0]);
        WsConfig config = WsConfig.createDeafult(acceptor.getRuntimeContext());
        config.register(DropBoxSwaggerResource.class);
        config.register(DropBoxResource.class);
        config.register(DropBoxInjectionResolver.class);
        config.register(DropBoxExceptionMapper.class);
        WsModel model = new WsModel();
        model.init(config);
        model.setInjectionContextConfigurator(this);
        context.addServlet(new ServletHolder((Servlet)new WsServletContainer(model)), "/dropbox/*");
        this.logDebug("DropBox Servlet configured.", new Object[0]);
    }

    private void configureRealm(HTTPAcceptor acceptor, AuthenticationManager authenticationManager) {
        RealmInfo dropBoxRealm = authenticationManager.getRealmManager().getRealmInfo("/dropbox");
        if (dropBoxRealm == null) {
            dropBoxRealm = new RealmInfo("DropBox", acceptor.getRuntimeContext());
            dropBoxRealm.addGroup("Admins");
            acceptor.getConfiguration().getRealms().put("/dropbox", dropBoxRealm);
        }
    }

    public static boolean isDropBoxConfigured(HTTPAcceptorConfiguration configuration) {
        return configuration != null && configuration.isEnableDropBox();
    }

    @Override
    public void configure(InjectionContext context) {
        context.put(DropBoxConfigurator.class, this);
    }

    public void destroy() {
    }

    public HTTPAcceptorConfiguration getAcceptorConfiguration() {
        return this.acceptor.getConfiguration();
    }

    protected void logDebug(String message, Object ... args) {
        this.log(Trace.Level.DEBUG, message, args);
    }

    protected void logInfo(String message, Object ... args) {
        this.log(Trace.Level.INFO, message, args);
    }

    protected void logError(String message, Object ... args) {
        this.log(Trace.Level.ERROR, message, args);
    }

    protected void log(Trace.Level level, String message, Object ... args) {
        message = "[DropBox at " + this.getAcceptorConfiguration().getName() + "] " + (String)message;
        switch (level) {
            case DEBUG: {
                Trace.logDebug(this, (String)message, args);
                break;
            }
            case ERROR: {
                Trace.logError(this, (String)message, args);
                break;
            }
            case INFO: {
                Trace.logInfo(this, (String)message, args);
                break;
            }
            default: {
                Trace.logError(this, (String)message, args);
            }
        }
    }

    public static interface FileSystemFactory {
        public FileSystem createFileSystem(FabricConnection var1);

        public void releaseFileSystem(FileSystem var1);

        public void destroy();
    }
}

