/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.dropbox;

import com.streamscape.Trace;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sef.dropbox.sdo.DropBox;
import com.streamscape.sef.network.http.server.dropbox.DropBoxFolderDescriptor;
import com.streamscape.sef.network.http.server.dropbox.FolderType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class DropBoxConfiguration
extends CloneableDataObject {
    private String rootFolder;
    private boolean stfs = false;
    private List<DropBoxFolderDescriptor> folderDescriptors = new ArrayList<DropBoxFolderDescriptor>();
    private String fsClientFactory = DropBox.LOCAL_FACTORY;

    public void setRootFolder(String folder) {
        this.rootFolder = folder;
    }

    public String getRootFolder() {
        return this.rootFolder;
    }

    public boolean isStfs() {
        return this.stfs;
    }

    public void setStfs(boolean stfs) {
        this.stfs = stfs;
    }

    public String getFsClientFactory() {
        return this.fsClientFactory;
    }

    public void setFsClientFactory(String fsClientFactory) {
        this.fsClientFactory = fsClientFactory;
    }

    public synchronized List<DropBoxFolderDescriptor> getFolderDescriptors() {
        return new ArrayList<DropBoxFolderDescriptor>(this.folderDescriptors);
    }

    public synchronized List<DropBoxFolderDescriptor> getFolderDescriptorsByType(FolderType type) {
        return this.folderDescriptors.stream().filter(desc -> desc.getType() == type).collect(Collectors.toList());
    }

    public synchronized boolean removeFolderDescriptor(String name) {
        return this.removeFolderDescriptor(name, false);
    }

    public synchronized boolean removeFolderDescriptor(String name, boolean withChildren) {
        boolean removed = false;
        Iterator<DropBoxFolderDescriptor> iter = this.folderDescriptors.iterator();
        while (iter.hasNext()) {
            DropBoxFolderDescriptor next = iter.next();
            if (!next.equalsName(name) && (!withChildren || !next.isChildOf(name))) continue;
            iter.remove();
            removed = true;
        }
        return removed;
    }

    public synchronized DropBoxFolderDescriptor getFolderDescriptor(String name) {
        for (DropBoxFolderDescriptor desc : this.folderDescriptors) {
            if (!desc.equalsName(name)) continue;
            return desc;
        }
        return null;
    }

    public synchronized DropBoxFolderDescriptor getFolderDescriptorBest(String name) {
        DropBoxFolderDescriptor result = null;
        for (DropBoxFolderDescriptor desc : this.folderDescriptors) {
            if (desc.equalsName(name)) {
                return desc;
            }
            if (!desc.isParentOf(name)) continue;
            if (result == null) {
                result = desc;
                continue;
            }
            if (result.getName().length() >= desc.getName().length()) continue;
            result = desc;
        }
        return result;
    }

    public synchronized DropBoxFolderDescriptor getParentOf(String name) {
        DropBoxFolderDescriptor result = null;
        for (DropBoxFolderDescriptor desc : this.folderDescriptors) {
            if (!desc.isParentOf(name)) continue;
            if (result == null) {
                result = desc;
                continue;
            }
            if (result.getName().length() >= desc.getName().length()) continue;
            result = desc;
        }
        return result;
    }

    public synchronized List<DropBoxFolderDescriptor> getChildrenOf(String path) {
        return this.folderDescriptors.stream().filter(folderDescriptor -> folderDescriptor.isChildOf(path)).collect(Collectors.toList());
    }

    public synchronized void setFolderDescriptor(DropBoxFolderDescriptor folderDescriptor) {
        this.addFolderDescriptor(folderDescriptor, false);
    }

    public synchronized void addFolderDescriptor(DropBoxFolderDescriptor folderDescriptor) {
        this.addFolderDescriptor(folderDescriptor, true);
    }

    public synchronized void addFolderDescriptor(DropBoxFolderDescriptor folderDescriptor, boolean mergeType) {
        if (folderDescriptor.getType() == null) {
            throw new IllegalArgumentException("Folder descriptor type is not set.");
        }
        DropBoxFolderDescriptor current = this.getFolderDescriptor(folderDescriptor.getName());
        if (current != null) {
            if (mergeType) {
                if (current.getType() == FolderType.UPLOAD && folderDescriptor.getType() == FolderType.DOWNLOAD) {
                    folderDescriptor.setType(FolderType.UPLOAD_AND_DOWNLOAD);
                } else if (current.getType() == FolderType.DOWNLOAD && folderDescriptor.getType() == FolderType.UPLOAD) {
                    folderDescriptor.setType(FolderType.UPLOAD_AND_DOWNLOAD);
                }
            }
            this.removeFolderDescriptor(folderDescriptor.getName());
        }
        if (folderDescriptor.getOrganizations() == null) {
            DropBoxFolderDescriptor parent = this.getParentOf(folderDescriptor.getName());
            if (parent != null) {
                folderDescriptor.setOrganizations(parent.getOrganizations());
            }
            if (folderDescriptor.getOrganizations() == null) {
                folderDescriptor.addOrganization("Domain");
            }
        }
        this.folderDescriptors.add(folderDescriptor);
    }

    public synchronized void clearFolderDescriptors() {
        this.folderDescriptors.clear();
    }

    public synchronized void check(String acceptorName) {
        if (this.folderDescriptors.size() > 0 && (this.rootFolder == null || this.rootFolder.length() == 0)) {
            Trace.logError(this, "HTTP.{} : DropBox has some folders configured, but root folder is null or empty. This DropBox servlet will not be started.", acceptorName);
        }
        for (DropBoxFolderDescriptor descriptor : this.folderDescriptors) {
            descriptor.setName(DropBoxFolderDescriptor.normalizeName(descriptor.getName()));
        }
        TreeSet<DropBoxFolderDescriptor> set = new TreeSet<DropBoxFolderDescriptor>((a1, a2) -> a1.getName().compareTo(a2.getName()));
        set.addAll(this.folderDescriptors);
        if (this.folderDescriptors.size() != set.size()) {
            Trace.logError(this, "HTTP.{} : Some DropBox folder descriptors have duplicate names. Removing them...", acceptorName);
            Iterator<DropBoxFolderDescriptor> iterator = this.folderDescriptors.iterator();
            while (iterator.hasNext()) {
                DropBoxFolderDescriptor descriptor = iterator.next();
                if (set.contains(descriptor)) {
                    set.remove(descriptor);
                    continue;
                }
                Trace.logError(this, "HTTP.{} : Removing descriptor {}", acceptorName, descriptor);
                iterator.remove();
            }
        }
        for (DropBoxFolderDescriptor folderDescriptor : this.folderDescriptors) {
            if (folderDescriptor.getType() == null) {
                Trace.logError(this, "HTTP.{} : Folder descriptor {} has null type. Set it to DISABLED.", acceptorName, folderDescriptor.getName());
                folderDescriptor.setType(FolderType.DISABLED);
            }
            if (folderDescriptor.getOrganizations() != null) continue;
            Trace.logInfo(this, "HTTP.{} : Folder descriptor {} has null organizations, set it to Domain.", acceptorName, folderDescriptor.getName());
            folderDescriptor.addOrganization("Domain");
        }
    }
}

