/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.cors;

import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sef.network.http.server.cors.Origin;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class OriginAccessControlConfiguration
extends CloneableDataObject {
    private List<Origin> origins = new ArrayList<Origin>();

    public OriginAccessControlConfiguration() {
        this.origins.add(new Origin());
    }

    public Origin setOrigin(Origin origin) {
        for (int index = 0; index < this.origins.size(); ++index) {
            if (!this.origins.get(index).getOrigin().equalsIgnoreCase(origin.getOrigin())) continue;
            return this.origins.set(index, origin);
        }
        this.origins.add(origin);
        return null;
    }

    public void setOrigins(List<Origin> origins) throws Exception {
        HashSet<String> originUrls = new HashSet<String>();
        for (Origin origin : origins) {
            if (originUrls.add(origin.getOrigin().toLowerCase())) continue;
            throw new Exception("Origin URL '" + origin.getOrigin() + "' present twice.");
        }
        this.origins = origins;
    }

    public Origin lookupOrigin(String origin) {
        for (Origin o : this.origins) {
            if (!o.getOrigin().equalsIgnoreCase(origin)) continue;
            return o;
        }
        return null;
    }

    public Origin removeOrigin(String origin) {
        for (int index = 0; index < this.origins.size(); ++index) {
            if (!this.origins.get(index).getOrigin().equalsIgnoreCase(origin)) continue;
            Origin removed = this.origins.get(index);
            this.origins.remove(index);
            return removed;
        }
        return null;
    }

    public List<Origin> getOrigins() {
        return new ArrayList<Origin>(this.origins);
    }
}

