/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.cors;

import com.streamscape.Trace;
import com.streamscape.lib.utils.CIString;
import com.streamscape.sef.network.http.server.cors.Origin;
import com.streamscape.sef.network.http.server.cors.OriginAccessControlConfiguration;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;

public class CORSPreprocessingHandler
extends HandlerWrapper {
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    public static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    public static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    public static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    public static final String ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    public static final String ORIGIN = "Origin";
    public static final String ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    public static final String ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
    private Map<CIString, Origin> origins = new HashMap<CIString, Origin>();
    private Origin defaultOrigin = null;
    private OriginAccessControlConfiguration configuration;

    public void setCorsConfiguration(OriginAccessControlConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.configuration == null || this.configuration.getOrigins() == null) {
            return;
        }
        this.origins = new HashMap<CIString, Origin>();
        for (Origin origin : this.configuration.getOrigins()) {
            if (origin.getOrigin().equals("*")) {
                this.defaultOrigin = origin;
                continue;
            }
            this.origins.put(new CIString(origin.getOrigin()), origin);
        }
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (baseRequest.isHandled()) {
            return;
        }
        String originHeaderValue = request.getHeader(ORIGIN);
        if (originHeaderValue == null) {
            return;
        }
        try {
            URL originUri = new URL(originHeaderValue);
            if (originUri.getProtocol().equalsIgnoreCase(request.getScheme()) && originUri.getHost().equalsIgnoreCase(request.getServerName()) && (originUri.getPort() == request.getServerPort() || originUri.getPort() == -1 && originUri.getDefaultPort() == request.getServerPort())) {
                return;
            }
        }
        catch (Exception originUri) {
            // empty catch block
        }
        if (this.origins == null) {
            Trace.logDebug((Object)this, "Incoming request contains ORIGIN header, but CORS not configured, origin: " + originHeaderValue);
            return;
        }
        Origin origin = this.origins.get(new CIString(originHeaderValue));
        if (origin == null) {
            origin = this.defaultOrigin;
        }
        if (origin == null || !origin.isEnabled()) {
            String message = "Cross-Origin Request Blocked: Accessing the remote resource at '" + request.getRequestURI() + "' from Origin '" + originHeaderValue + "' not allowed. This can be fixed by moving the resource to the same domain or enabling CORS for this Origin.";
            Trace.logDebug((Object)this, message);
            response.setStatus(403);
            response.getOutputStream().println(message);
            response.flushBuffer();
            baseRequest.setHandled(true);
            return;
        }
        if (origin.isAllowCredentials()) {
            if (originHeaderValue == null || originHeaderValue.equalsIgnoreCase("null")) {
                originHeaderValue = origin.getOrigin();
            }
            response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN, originHeaderValue);
            response.setHeader(ACCESS_CONTROL_ALLOW_CREDENTIALS, "true");
        } else if (origin.getOrigin().equals("*")) {
            response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN, origin.getOrigin());
        } else {
            response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN, originHeaderValue);
        }
        if (request.getMethod().equalsIgnoreCase("OPTIONS")) {
            String headerValue = null;
            headerValue = request.getHeader(ACCESS_CONTROL_REQUEST_METHOD);
            if (headerValue != null) {
                if (origin.getAllowedMethods() != null && origin.getAllowedMethods().length() > 0) {
                    response.setHeader(ACCESS_CONTROL_ALLOW_METHODS, origin.getAllowedMethods());
                } else {
                    response.setHeader(ACCESS_CONTROL_ALLOW_METHODS, headerValue);
                }
            }
            if ((headerValue = request.getHeader(ACCESS_CONTROL_REQUEST_HEADERS)) != null) {
                if (origin.getAllowedHeaders() != null && origin.getAllowedHeaders().length() > 0) {
                    response.setHeader(ACCESS_CONTROL_ALLOW_HEADERS, origin.getAllowedHeaders());
                } else {
                    response.setHeader(ACCESS_CONTROL_ALLOW_HEADERS, headerValue);
                }
            }
            if (origin.getMaxAge() != 0L) {
                response.setHeader(ACCESS_CONTROL_MAX_AGE, new Long(origin.getMaxAge()).toString());
            }
            response.setStatus(200);
            response.flushBuffer();
            baseRequest.setHandled(true);
            return;
        }
        if (origin.getExposedHeaders() != null && origin.getExposedHeaders().length() > 0) {
            response.setHeader(ACCESS_CONTROL_EXPOSE_HEADERS, origin.getExposedHeaders());
        }
    }
}

