/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.config;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.security.Group;
import com.streamscape.sef.security.SecurityManager;
import com.streamscape.sef.security.SecurityManagerException;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class RealmInfo {
    protected String realmName = "";
    protected LinkedList<String> users = new LinkedList();
    protected LinkedList<String> groups = new LinkedList();
    private transient SecurityManager securityManager;

    public RealmInfo(RuntimeContext context) {
        this.init(context);
    }

    public RealmInfo(String name, RuntimeContext context) {
        this.realmName = name;
        this.init(context);
    }

    public void init(RuntimeContext context) {
        try {
            if (context != null) {
                this.securityManager = context.getSecurityManager();
            }
        }
        catch (SecurityManagerException securityManagerException) {
            // empty catch block
        }
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setRealmName(String name) {
        this.realmName = name;
    }

    public void addUser(String user) {
        this.users.add(RealmInfo.trim(user));
    }

    public void removeUser(String user) {
        this.users.remove(RealmInfo.trim(user));
    }

    public void addGroup(String group) {
        this.groups.add(RealmInfo.trim(group));
    }

    public void removeGroup(String group) {
        this.groups.remove(RealmInfo.trim(group));
    }

    public List<String> listUsers() {
        return this.users;
    }

    public List<String> listGroups() {
        return this.groups;
    }

    public void setUsers(List<String> users) {
        this.users = RealmInfo.trim(users);
    }

    public void setGroups(List<String> groups) {
        this.groups = RealmInfo.trim(groups);
    }

    public boolean checkUser(String user) {
        if (this.users == null) {
            this.users = new LinkedList();
        }
        if (this.groups == null) {
            this.groups = new LinkedList();
        }
        if (this.users.contains(user = RealmInfo.trim(user))) {
            return true;
        }
        try {
            if (this.securityManager != null) {
                List<Group> allGroups = this.securityManager.getGroups();
                for (Group group : allGroups) {
                    if (!group.hasUser(user)) continue;
                    for (String realmGroupName : this.groups) {
                        if (!group.getName().equals(realmGroupName)) continue;
                        return true;
                    }
                }
            }
        }
        catch (SecurityManagerException securityManagerException) {
            // empty catch block
        }
        return false;
    }

    public void trim() {
        this.groups = RealmInfo.trim(this.groups);
        this.users = RealmInfo.trim(this.users);
    }

    private static String trim(String s) {
        return s != null ? s.trim() : null;
    }

    private static LinkedList<String> trim(List<String> list) {
        if (list != null) {
            list = new LinkedList<String>(list.stream().map(s -> RealmInfo.trim(s)).collect(Collectors.toList()));
        }
        return (LinkedList)list;
    }
}

