/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.runtime.service;

import com.streamscape.Trace;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.network.http.server.authentication.runtime.ApiKeyErrorException;
import com.streamscape.sef.network.http.server.authentication.runtime.ApiKeyErrorInvalidArgumentsException;
import com.streamscape.sef.network.http.server.authentication.runtime.TokenGenerator;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.ApplicationDao;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.Criteria;
import com.streamscape.sef.network.http.server.authentication.runtime.model.ApiKeySecurityBinding;
import com.streamscape.sef.network.http.server.authentication.runtime.model.Application;
import com.streamscape.sef.network.http.server.authentication.runtime.model.ApplicationResourceMatcher;
import com.streamscape.sef.network.http.server.authentication.runtime.service.AbstractService;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApplicationService;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.User;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ApplicationServiceImpl
extends AbstractService<ApplicationDao>
implements ApplicationService {
    public static final String QUILT_APPLICATION = "Quilt";
    public static final String RED_SQUARE_APPLICATION = "RedSquare";
    public static final String SOR_APPLICATION = "SOR";
    private static final String QUILT_APPLICATION_ID = "aqltiqaq47qldrqlmh4gh6vl0gbf3g";
    private static final String RED_SQUARE_APPLICATION_ID = "arsqn51bnc20s6tmpof5k8rpaiskd9";
    private static final String SOR_APPLICATION_ID = "asord29imfh480a01uukocgqg506rt";
    public static final Map<String, String> systemApplications = ApplicationServiceImpl.createSystemApplicationsMap();
    private TokenGenerator applicationIdGenerator;
    private RuntimeContext context;

    private static Map createSystemApplicationsMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(QUILT_APPLICATION, QUILT_APPLICATION_ID);
        map.put(RED_SQUARE_APPLICATION, RED_SQUARE_APPLICATION_ID);
        map.put(SOR_APPLICATION, SOR_APPLICATION_ID);
        return Collections.unmodifiableMap(map);
    }

    public void setApplicationIdGenerator(TokenGenerator applicationIdGenerator) {
        this.applicationIdGenerator = applicationIdGenerator;
    }

    public void setRuntimeContext(RuntimeContext context) {
        this.context = context;
    }

    @Override
    public void create(Application application) {
        this.checkNotNullNotEmpty("name", application.getName());
        this.checkNullOrEmpty("applicationId", application.getApplicationId());
        this.checkResources(application);
        ApplicationServiceImpl.checkSecurityBindings(application.getSecurityBindings());
        if (systemApplications.containsKey(application.getName()) && this.getAll("*", application.getName(), false, true).size() > 0) {
            throw new ApiKeyErrorException("Application name '" + application.getName() + " is reserved. Choose another name.");
        }
        if (application.getOwner() == null || application.getOwner().trim().length() == 0) {
            application.setOwner(this.authenticationContext.getUser().getName().toString());
        }
        if (!application.getOwner().equalsIgnoreCase(this.authenticationContext.getUser().getName().toString())) {
            if (!this.authenticationContext.getUser().isAdministrator()) {
                throw new ApiKeyErrorException("Only admin users can create applications owned by another users.");
            }
            try {
                User user = this.context.getSecurityManager().lookupUser(application.getOwner());
                if (user == null) {
                    throw new ApiKeyErrorException("Specified owner user doesn't exit.");
                }
                application.setOwner(user.getName().toString());
            }
            catch (SecurityManagerException exception) {
                throw new ApiKeyErrorException("Cannot check user name.", exception);
            }
        }
        if (application.getResources() == null) {
            application.setResources(new HashSet<Application.Resource>());
        }
        if (application.getSecurityBindings() == null) {
            application.setSecurityBindings(new HashSet<ApiKeySecurityBinding>());
        }
        application.setCreatedAt(System.currentTimeMillis());
        String applicationId = systemApplications.get(application.getName());
        if (applicationId == null) {
            applicationId = this.applicationIdGenerator.generate(application.getName());
        }
        application.setApplicationId(applicationId);
        application.setLastUpdatedAt(System.currentTimeMillis());
        application.setMasterNode(this.context.getName());
        application.setDeletedAt(0L);
        ((ApplicationDao)this.dao).insert(application);
    }

    @Override
    public void update(Application application) {
        this.checkNotNullNotEmpty("applicationId", application.getApplicationId());
        this.checkResources(application);
        ApplicationServiceImpl.checkSecurityBindings(application.getSecurityBindings());
        Application oldApplication = this.get(application.getApplicationId(), false);
        if (oldApplication == null) {
            throw new ApiKeyErrorInvalidArgumentsException("Application with specified applicationId doesn't exist.");
        }
        if (!this.authenticationContext.getUser().isAdministrator() && !this.authenticationContext.getUser().getName().toString().equalsIgnoreCase(oldApplication.getOwner())) {
            throw new ApiKeyErrorException("Only admin users can update applications owned by another users.");
        }
        if (application.getName() != null && application.getName().length() > 0 && !application.getName().equals(oldApplication.getName())) {
            throw new ApiKeyErrorInvalidArgumentsException("Application name cannot be updated.");
        }
        if (application.getOwner() != null && application.getOwner().length() > 0 && !application.getOwner().equalsIgnoreCase(oldApplication.getOwner())) {
            throw new ApiKeyErrorInvalidArgumentsException("Application owner cannot be updated.");
        }
        application.setName(oldApplication.getName());
        application.setOwner(oldApplication.getOwner());
        application.setCreatedAt(oldApplication.getCreatedAt());
        application.setGlobal(oldApplication.isGlobal());
        if (application.getResources() == null) {
            application.setResources(new HashSet<Application.Resource>());
        }
        if (application.getSecurityBindings() == null) {
            application.setSecurityBindings(new HashSet<ApiKeySecurityBinding>());
        }
        application.setLastUpdatedAt(System.currentTimeMillis());
        application.setDeletedAt(0L);
        ((ApplicationDao)this.dao).updateByApplicationId(application);
    }

    @Override
    public Application get(String applicationId, boolean withResources) {
        return ((ApplicationDao)this.dao).getByApplicationId(applicationId, withResources);
    }

    @Override
    public List<String> listApplications() {
        return ((ApplicationDao)this.dao).list(Criteria.Builder.eq("OWNER", this.authenticationContext.getUser().getName().toString().toLowerCase()));
    }

    @Override
    public List<Application> getAll(String owner, String applicationName, boolean withResources, boolean withSystem) {
        if (owner == null || owner.trim().length() == 0) {
            owner = this.authenticationContext.getUser().getName().toString().toLowerCase();
        }
        return ((ApplicationDao)this.dao).select(this.buildCriteria(owner, applicationName, withSystem), withResources);
    }

    @Override
    public int delete(String applicationId) {
        Application application = this.get(applicationId, false);
        if (application != null) {
            if (!this.authenticationContext.getUser().isAdministrator() && !this.authenticationContext.getUser().getName().toString().equalsIgnoreCase(application.getOwner())) {
                throw new ApiKeyErrorException("Only admin users can delete applications owned by another users.");
            }
            this.checkApplicationNameNotSystem(application.getName());
            return ((ApplicationDao)this.dao).deleteByApplicationId(applicationId);
        }
        return 0;
    }

    @Override
    public int deleteAll(String owner, String applicationName) {
        if (owner == null || owner.trim().length() == 0) {
            owner = this.authenticationContext.getUser().getName().toString().toLowerCase();
        }
        if (!this.authenticationContext.getUser().isAdministrator()) {
            if (owner.equals("*")) {
                owner = this.authenticationContext.getUser().getName().toString().toLowerCase();
            }
            if (!this.authenticationContext.getUser().getName().toString().equalsIgnoreCase(owner)) {
                throw new ApiKeyErrorException("Only admin users can delete applications owned by another users.");
            }
        }
        this.checkApplicationNameNotSystem(applicationName);
        return ((ApplicationDao)this.dao).delete(this.buildCriteria(owner, applicationName, false));
    }

    private void checkApplicationNameNotSystem(String name) {
        if (systemApplications.containsKey(name)) {
            throw new ApiKeyErrorException("System application '" + name + "' cannot be removed.");
        }
    }

    private Criteria buildCriteria(String owner, String applicationName, boolean withSystem) {
        Criteria criteria = Criteria.Builder.tr();
        if (!owner.equals("*")) {
            criteria = Criteria.Builder.eq("OWNER", owner.toLowerCase());
        }
        if (applicationName != null && applicationName.length() > 0) {
            criteria = Criteria.Builder.and(criteria, Criteria.Builder.eq("NAME", applicationName));
        } else if (!withSystem) {
            criteria = Criteria.Builder.and(criteria, ApplicationServiceImpl.notSystemApplicationCriteria());
        }
        return criteria;
    }

    private void checkResources(Application application) {
        if (application.getResources() != null) {
            try {
                ApplicationResourceMatcher.Matcher matcher = ApplicationResourceMatcher.create(application.getResources(), (m, u) -> new Application.Resource(m, u));
                if (Trace.isDebugEnabled(this.getClass())) {
                    StringBuilder builder = ApplicationResourceMatcher.printTree(matcher, new StringBuilder());
                    Trace.logDebug(this, "Application '{}' resources tree:\n{}", application.getName(), builder.toString());
                }
            }
            catch (Exception exception) {
                throw new ApiKeyErrorException("Invalid resources specified.", exception);
            }
        }
    }

    public static void checkSecurityBindings(Set<ApiKeySecurityBinding> securityBindings) {
        if (securityBindings != null) {
            if (securityBindings.contains((Object)ApiKeySecurityBinding.SESSION_ON_AUTHENTICATION) && securityBindings.contains((Object)ApiKeySecurityBinding.SESSION_ON_FIRST_TOKEN_USE)) {
                throw new ApiKeyErrorException("Invalid security bindings specified. SESSION_ON_AUTHENTICATION and SESSION_ON_FIRST_TOKEN_USE cannot be set together.");
            }
            if (securityBindings.contains((Object)ApiKeySecurityBinding.USER_AGENT_ON_AUTHENTICATION) && securityBindings.contains((Object)ApiKeySecurityBinding.USER_AGENT_ON_FIRST_TOKEN_USE)) {
                throw new ApiKeyErrorException("Invalid security bindings specified. USER_AGENT_ON_AUTHENTICATION and USER_AGENT_ON_AUTHENTICATION cannot be set together.");
            }
        }
    }

    private void checkNotNullNotEmpty(String name, String value) {
        if (value == null || value.trim().length() == 0) {
            throw new ApiKeyErrorInvalidArgumentsException("Application '" + name + "' should be not null and not empty.");
        }
    }

    private void checkNullOrEmpty(String name, String value) {
        if (value != null && value.trim().length() > 0) {
            throw new ApiKeyErrorInvalidArgumentsException("Application '" + name + "' should be null or empty.");
        }
    }

    public static Criteria notSystemApplicationCriteria() {
        Criteria criteria = null;
        for (String name : systemApplications.keySet()) {
            Criteria c = Criteria.Builder.neq("NAME", name);
            criteria = criteria == null ? c : Criteria.Builder.and(criteria, c);
        }
        if (criteria == null) {
            criteria = Criteria.Builder.tr();
        }
        return criteria;
    }
}

