/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.runtime.service;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.dispatcher.AbstractApiKeyTokenService;
import com.streamscape.sef.network.http.server.authentication.runtime.ApiKeyErrorException;
import com.streamscape.sef.network.http.server.authentication.runtime.ApiKeyErrorInvalidArgumentsException;
import com.streamscape.sef.network.http.server.authentication.runtime.TokenGenerator;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.ApiKeyTokenDao;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.Criteria;
import com.streamscape.sef.network.http.server.authentication.runtime.model.ApiKeyToken;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApiKeyDefaultsService;
import com.streamscape.sef.security.ApiKeyTokenDigestCalculator;
import java.util.List;

public class ApiKeyTokenServiceImpl
extends AbstractApiKeyTokenService {
    private RuntimeContext context;
    private TokenGenerator apiKeyTokenGenerator;
    private ApiKeyDefaultsService apiKeyDefaultsService;

    public void setApiKeyTokenGenerator(TokenGenerator apiKeyTokenGenerator) {
        this.apiKeyTokenGenerator = apiKeyTokenGenerator;
    }

    public void setApiKeyDefaultsService(ApiKeyDefaultsService apiKeyDefaultsService) {
        this.apiKeyDefaultsService = apiKeyDefaultsService;
    }

    public void setRuntimeContext(RuntimeContext context) {
        this.context = context;
    }

    @Override
    public void create(ApiKeyToken apiKeyToken) {
        this.checkNotNullNotEmpty("name", apiKeyToken.getName());
        this.checkNullOrEmpty("token", apiKeyToken.getTokenId());
        this.checkNullOrEmpty("securityToken", apiKeyToken.getSecurityTokenId());
        this.checkNotNullNotEmpty("applicationId", apiKeyToken.getApplicationId());
        if (apiKeyToken.getOwner() != null && apiKeyToken.getOwner().trim().length() > 0 && !apiKeyToken.getOwner().equalsIgnoreCase(this.authenticationContext.getUser().getName().toString())) {
            throw new ApiKeyErrorException("It is not allowed to create token owned by another users.");
        }
        apiKeyToken.setOwner(this.authenticationContext.getUser().getName().toString());
        apiKeyToken.setCreatedAt(System.currentTimeMillis());
        apiKeyToken.setLastAccessedAt(apiKeyToken.getCreatedAt());
        apiKeyToken.setTokenId(this.apiKeyTokenGenerator.generate(apiKeyToken.getName()));
        if (apiKeyToken.getExtendPeriod() == 0) {
            apiKeyToken.setExtendPeriod(this.apiKeyDefaultsService.getPropertyIntValue("api.key.token.extend.period.in.sec"));
        }
        if (apiKeyToken.getExpiresIn() == 0) {
            apiKeyToken.setExpiresIn(this.apiKeyDefaultsService.getPropertyIntValue("api.key.token.expiration.in.sec"));
        }
        if (apiKeyToken.getDeleteTimeoutAfterExpiration() == 0L) {
            apiKeyToken.setDeleteTimeoutAfterExpiration(this.apiKeyDefaultsService.getPropertyIntValue("api.key.token.delete.timeout.after.expiration.in.sec"));
        }
        apiKeyToken.setLastUpdatedAt(System.currentTimeMillis());
        apiKeyToken.setMasterNode(this.context.getName());
        apiKeyToken.setDeletedAt(0L);
        apiKeyToken.setSecurityTokenId(this.calculateDigest(this.authenticationContext.getUser(), new ApiKeyTokenDigestCalculator()));
        ((ApiKeyTokenDao)this.dao).insert(apiKeyToken);
    }

    @Override
    public void update(ApiKeyToken apiKeyToken) {
        this.checkNotNullNotEmpty("tokenId", apiKeyToken.getTokenId());
        ApiKeyToken oldApiKeyToken = this.get(apiKeyToken.getTokenId());
        if (oldApiKeyToken == null) {
            throw new ApiKeyErrorInvalidArgumentsException("Api key token with specified tokenId does not exist.");
        }
        if (!this.authenticationContext.getUser().isAdministrator() && !this.authenticationContext.getUser().getName().toString().equalsIgnoreCase(oldApiKeyToken.getOwner())) {
            throw new ApiKeyErrorException("Only admin users can update tokens owned by another users.");
        }
        if (apiKeyToken.getName() != null && apiKeyToken.getName().length() > 0 && !apiKeyToken.getName().equals(oldApiKeyToken.getName())) {
            throw new ApiKeyErrorInvalidArgumentsException("Api key token name cannot be updated.");
        }
        if (apiKeyToken.getOwner() != null && apiKeyToken.getOwner().length() > 0 && !apiKeyToken.getOwner().equals(oldApiKeyToken.getOwner())) {
            throw new ApiKeyErrorInvalidArgumentsException("Api key token owner cannot be updated.");
        }
        apiKeyToken.setName(oldApiKeyToken.getName());
        apiKeyToken.setOwner(oldApiKeyToken.getOwner());
        apiKeyToken.setSecurityTokenId(oldApiKeyToken.getSecurityTokenId());
        apiKeyToken.setCreatedAt(oldApiKeyToken.getCreatedAt());
        apiKeyToken.setLastAccessedAt(oldApiKeyToken.getLastAccessedAt());
        apiKeyToken.setGlobal(oldApiKeyToken.isGlobal());
        apiKeyToken.setApplicationId(oldApiKeyToken.getApplicationId());
        apiKeyToken.setLastUpdatedAt(System.currentTimeMillis());
        apiKeyToken.setDeletedAt(0L);
        ((ApiKeyTokenDao)this.dao).updateByTokenId(apiKeyToken);
    }

    @Override
    public ApiKeyToken get(String tokenId) {
        return ((ApiKeyTokenDao)this.dao).getByTokenId(tokenId);
    }

    @Override
    public List<ApiKeyToken> getAll(String owner, String tokenName) {
        return this.getAll(owner, tokenName, null);
    }

    @Override
    public List<ApiKeyToken> getAll(String owner, String tokenName, String applicationId) {
        if (owner == null || owner.trim().length() == 0) {
            owner = this.authenticationContext.getUser().getName().toString().toLowerCase();
        }
        if (!this.authenticationContext.getUser().isAdministrator()) {
            if (owner.equals("*")) {
                owner = this.authenticationContext.getUser().getName().toString().toLowerCase();
            }
            if (!this.authenticationContext.getUser().getName().toString().equalsIgnoreCase(owner)) {
                throw new ApiKeyErrorException("Only admin users can get tokens owned by another users.");
            }
        }
        if (tokenName != null && (tokenName.trim().length() == 0 || tokenName.trim().equals("*"))) {
            tokenName = null;
        }
        if (applicationId != null && (applicationId.trim().length() == 0 || applicationId.trim().equals("*"))) {
            applicationId = null;
        }
        return ((ApiKeyTokenDao)this.dao).select(this.buildCriteria(owner, tokenName, applicationId));
    }

    @Override
    public int revoke(String tokenId) {
        ApiKeyToken token = this.get(tokenId);
        if (token != null) {
            if (!this.authenticationContext.getUser().isAdministrator() && !this.authenticationContext.getUser().getName().toString().equalsIgnoreCase(token.getOwner())) {
                throw new ApiKeyErrorException("Only admin users can revoke API key tokens owned by another users.");
            }
            return ((ApiKeyTokenDao)this.dao).deleteByTokenId(tokenId);
        }
        return 0;
    }

    @Override
    public int revokeAll(String owner, String tokenName) {
        return this.revokeAll(owner, tokenName, null);
    }

    @Override
    public int revokeAll(String owner, String tokenName, String applicationId) {
        if (owner == null || owner.trim().length() == 0) {
            owner = this.authenticationContext.getUser().getName().toString().toLowerCase();
        }
        if (!this.authenticationContext.getUser().isAdministrator()) {
            if (owner.equals("*")) {
                owner = this.authenticationContext.getUser().getName().toString().toLowerCase();
            }
            if (!this.authenticationContext.getUser().getName().toString().equalsIgnoreCase(owner)) {
                throw new ApiKeyErrorException("Only admin users can revoke tokens owned by another users.");
            }
        }
        return ((ApiKeyTokenDao)this.dao).delete(this.buildCriteria(owner, tokenName, applicationId));
    }

    @Override
    public List<String> listTokens() {
        return ((ApiKeyTokenDao)this.dao).list(Criteria.Builder.eq("OWNER", this.authenticationContext.getUser().getName().toString().toLowerCase()));
    }

    private Criteria buildCriteria(String owner, String tokenName, String applicationId) {
        Criteria criteria = Criteria.Builder.tr();
        if (!owner.equals("*")) {
            criteria = Criteria.Builder.eq("OWNER", owner.toLowerCase());
        }
        if (tokenName != null && tokenName.length() > 0) {
            criteria = Criteria.Builder.and(criteria, Criteria.Builder.eq("NAME", tokenName));
        }
        if (applicationId != null && applicationId.length() > 0) {
            criteria = Criteria.Builder.and(criteria, Criteria.Builder.eq("APPLICATION_ID", applicationId));
        }
        return criteria;
    }

    private void checkNotNullNotEmpty(String name, String value) {
        if (value == null || value.trim().length() == 0) {
            throw new ApiKeyErrorInvalidArgumentsException("API Key Token '" + name + "' should be not null and not empty.");
        }
    }

    private void checkNullOrEmpty(String name, String value) {
        if (value != null && value.trim().length() > 0) {
            throw new ApiKeyErrorInvalidArgumentsException("API Key Token '" + name + "' should be null or empty.");
        }
    }
}

