/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.runtime.service;

import com.streamscape.Trace;
import com.streamscape.lib.concurrent.worker.MonitorDaemonWorker;
import com.streamscape.lib.utils.Utils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.ApiKeyTokenDao;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.ApplicationDao;

public class ApiKeyTokenCleaner
extends MonitorDaemonWorker {
    private final ApiKeyTokenDao apiKeyTokenDao;
    private final ApplicationDao applicationDao;
    private final RuntimeContext context;
    private int removeTimeout;

    public ApiKeyTokenCleaner(ApiKeyTokenDao apiKeyTokenDao, ApplicationDao applicationDao, int threadRunTimeout, int removeTimeout, RuntimeContext context) throws FabricException {
        super("EXCH:ApiKeyTokenCleaner", "Cleans expired api key tokens.", threadRunTimeout * 1000);
        this.apiKeyTokenDao = apiKeyTokenDao;
        this.applicationDao = applicationDao;
        this.context = context;
        this.removeTimeout = removeTimeout;
        Trace.logDebug(this, "API Key Tokens cleaner thread created. Cleanup period {} seconds.", this.getTimeout() / 1000L);
    }

    public int getRemoveTimeout() {
        return this.removeTimeout;
    }

    public void setRemoveTimeout(int removeTimeout) {
        this.removeTimeout = removeTimeout;
    }

    @Override
    protected void doExecute() throws FabricException, InterruptedException {
        try {
            this.apiKeyTokenDao.deleteExpired(this.context.getName(), System.currentTimeMillis());
        }
        catch (Exception exception) {
            Trace.logError(this, "Failed to delete expired api key tokens.");
            this.logException(exception);
        }
        try {
            this.apiKeyTokenDao.removeDeleted(this.context.getName(), this.removeTimeout);
        }
        catch (Exception exception) {
            Trace.logError(this, "Failed to remove deleted api key tokens.");
            this.logException(exception);
        }
        try {
            this.applicationDao.removeDeleted(this.context.getName(), this.removeTimeout);
        }
        catch (Exception exception) {
            Trace.logError(this, "Failed to remove deleted api key applications.");
            this.logException(exception);
        }
    }

    private void logException(Exception exception) {
        Trace.logError(this, Utils.formatExceptionWithUnrepeatedCauses(exception));
        if (Trace.isDebugEnabled(this.getClass())) {
            Trace.logException(this, exception, true);
        }
    }
}

