/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.runtime.service;

import com.streamscape.Trace;
import com.streamscape.sef.network.http.server.authentication.Authenticator;
import com.streamscape.sef.network.http.server.authentication.HTTPCredentials;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.ApiKeyTokenDao;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.ApplicationDao;
import com.streamscape.sef.network.http.server.authentication.runtime.model.ApiKeySecurityBinding;
import com.streamscape.sef.network.http.server.authentication.runtime.model.ApiKeyToken;
import com.streamscape.sef.network.http.server.authentication.runtime.model.Application;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApiKeyTokenAuthenticatorService;
import com.streamscape.sef.security.ApiKeyTokenDigestCalculator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;

public class ApiKeyTokenAuthenticatorServiceImpl
implements ApiKeyTokenAuthenticatorService {
    private ApplicationDao applicationDao;
    private ApiKeyTokenDao apiKeyTokenDao;

    public ApiKeyTokenAuthenticatorServiceImpl(ApplicationDao applicationDao, ApiKeyTokenDao apiKeyTokenDao) {
        this.applicationDao = applicationDao;
        this.apiKeyTokenDao = apiKeyTokenDao;
    }

    @Override
    public HTTPCredentials authenticate(String tokenId, String method, String uri, HttpServletRequest httpServletRequest) throws Authenticator.AuthenticationException {
        Application application;
        ApiKeyToken token = this.apiKeyTokenDao.getByTokenId(tokenId);
        if (token == null) {
            throw new Authenticator.AuthenticationFailedException("Token does not exist: " + ApiKeyToken.trim(tokenId), "8003");
        }
        if (token.getExpiresIn() > 0 && System.currentTimeMillis() - token.getLastAccessedAt() > (long)(token.getExpiresIn() * 1000)) {
            throw new Authenticator.AuthenticationFailedException("Token has expired.", "8002");
        }
        if (token.getExtendPeriod() > 0) {
            token.setLastAccessedAt(System.currentTimeMillis());
            if (token.getLastAccessedAtOriginal() > 0L && System.currentTimeMillis() - token.getLastAccessedAtOriginal() >= (long)(token.getExtendPeriod() * 1000)) {
                try {
                    this.apiKeyTokenDao.updateTokenLastAccessedAt(token);
                }
                catch (Exception exception) {
                    Trace.logError(this, "Updating token last accessed time failed.");
                    Trace.logException(this, exception, true);
                }
            }
        }
        if (token.getSecurityBindings() != null && token.getSecurityBindings().size() > 0) {
            Map<ApiKeySecurityBinding, String> bindingsMap = token.getSecurityBindingsValues();
            if (bindingsMap != null) {
                bindingsMap = new HashMap<ApiKeySecurityBinding, String>(bindingsMap);
            }
            if (token.getSecurityBindings().contains((Object)ApiKeySecurityBinding.SESSION_ON_FIRST_TOKEN_USE) && (bindingsMap == null || !bindingsMap.containsKey((Object)ApiKeySecurityBinding.SESSION_ON_FIRST_TOKEN_USE))) {
                if (bindingsMap == null) {
                    bindingsMap = new HashMap<ApiKeySecurityBinding, String>();
                }
                bindingsMap.put(ApiKeySecurityBinding.SESSION_ON_FIRST_TOKEN_USE, httpServletRequest.getSession(true).getId());
            }
            if (token.getSecurityBindings().contains((Object)ApiKeySecurityBinding.USER_AGENT_ON_FIRST_TOKEN_USE) && (bindingsMap == null || !bindingsMap.containsKey((Object)ApiKeySecurityBinding.USER_AGENT_ON_FIRST_TOKEN_USE))) {
                if (bindingsMap == null) {
                    bindingsMap = new HashMap<ApiKeySecurityBinding, String>();
                }
                bindingsMap.put(ApiKeySecurityBinding.USER_AGENT_ON_FIRST_TOKEN_USE, httpServletRequest.getHeader("User-Agent"));
            }
            if (!Objects.equals(bindingsMap, token.getSecurityBindingsValues())) {
                token.setSecurityBindingsValues(bindingsMap);
                this.apiKeyTokenDao.updateByTokenId(token);
            }
        }
        if (token.getSecurityBindingsValues() != null && token.getSecurityBindingsValues().size() > 0) {
            String requestUserAgent;
            String session = token.getSecurityBindingsValues().getOrDefault((Object)ApiKeySecurityBinding.SESSION_ON_AUTHENTICATION, null);
            if (session == null) {
                session = token.getSecurityBindingsValues().getOrDefault((Object)ApiKeySecurityBinding.SESSION_ON_FIRST_TOKEN_USE, null);
            }
            if (session != null && !session.equals(httpServletRequest.getSession(true).getId())) {
                throw new Authenticator.AccessDeniedException("Access denied in another session.", "8006");
            }
            String userAgent = token.getSecurityBindingsValues().getOrDefault((Object)ApiKeySecurityBinding.USER_AGENT_ON_AUTHENTICATION, null);
            if (userAgent == null) {
                userAgent = token.getSecurityBindingsValues().getOrDefault((Object)ApiKeySecurityBinding.USER_AGENT_ON_FIRST_TOKEN_USE, null);
            }
            if (!(userAgent == null || (requestUserAgent = httpServletRequest.getHeader("User-Agent")) != null && requestUserAgent.endsWith("RPT-HTTPClient/0.3-3") && requestUserAgent.startsWith(userAgent) || userAgent.equals(requestUserAgent))) {
                throw new Authenticator.AccessDeniedException("Access denied in another user agent.", "8006");
            }
        }
        if ((application = this.applicationDao.getByApplicationId(token.getApplicationId(), true)) == null) {
            throw new Authenticator.AccessDeniedException("Application for provided token does not exist.", "8008");
        }
        Application.Resource resource = application.matches(method, uri);
        if (resource == null) {
            throw new Authenticator.AccessDeniedException("Access denied by application '" + application.getName() + "'.", "8006");
        }
        if (Trace.isDebugEnabled(this.getClass())) {
            Trace.logDebug(this, "Request {} {} matched to application '{}' and resource '{}'", method, uri, application.getName(), resource.toString());
        }
        HTTPCredentials credentials = new HTTPCredentials();
        credentials.setUserName(token.getOwner());
        credentials.setCredentials(token.getSecurityTokenId());
        credentials.setDigestCalculator(new ApiKeyTokenDigestCalculator());
        return credentials;
    }
}

