/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.runtime.service;

import com.streamscape.Trace;
import com.streamscape.sef.network.http.server.authentication.runtime.ApiKeyErrorException;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.ApiKeyDefaultsDao;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.Criteria;
import com.streamscape.sef.network.http.server.authentication.runtime.model.ApiKeyDefault;
import com.streamscape.sef.network.http.server.authentication.runtime.service.AbstractService;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApiKeyDefaultsService;
import com.streamscape.sef.network.http.server.jetty.JettyAdvancedProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ApiKeyDefaultsServiceImpl
extends AbstractService<ApiKeyDefaultsDao>
implements ApiKeyDefaultsService {
    private static Map<String, ApiKeyDefault> defaults = Collections.synchronizedMap(new LinkedHashMap());
    private List<ApiKeyDefaultsService.ApiKeyDefaultsUpdateListener> apiKeyDefaultsUpdateListeners = new ArrayList<ApiKeyDefaultsService.ApiKeyDefaultsUpdateListener>();

    private static void registerProperty(String key, Object value, String description) {
        defaults.put(key, new ApiKeyDefault(key, value, description));
    }

    public static Map<String, ApiKeyDefault> getDefaults() {
        return new HashMap<String, ApiKeyDefault>(defaults);
    }

    private static ApiKeyDefault getApiKeyDefault(String name) {
        return defaults.get(name);
    }

    public void setApiKeyDefaultsUpdateListeners(List<ApiKeyDefaultsService.ApiKeyDefaultsUpdateListener> apiKeyDefaultsUpdateListeners) {
        this.apiKeyDefaultsUpdateListeners = apiKeyDefaultsUpdateListeners;
    }

    @Override
    public Object getPropertyDefaultValue(String name) {
        ApiKeyDefault d = ApiKeyDefaultsServiceImpl.getApiKeyDefault(name);
        if (d == null) {
            return null;
        }
        return d.getValue();
    }

    @Override
    public String getPropertyValue(String name) {
        List<ApiKeyDefault> properties = ((ApiKeyDefaultsDao)this.dao).select(Criteria.Builder.eq("NAME", name));
        if (properties.size() == 0) {
            return null;
        }
        return (String)properties.get(0).getValue();
    }

    @Override
    public Integer getPropertyIntValue(String name) {
        String value = this.getPropertyValue(name);
        try {
            if (value != null) {
                return Integer.valueOf(value);
            }
            return (Integer)this.getPropertyDefaultValue(name);
        }
        catch (RuntimeException exception) {
            Trace.logError(JettyAdvancedProperties.class, "Failed to cast value '" + value + "' of property '" + name + "' to integer.");
            Trace.logException(JettyAdvancedProperties.class, exception, true);
            throw exception;
        }
    }

    @Override
    public Long getPropertyLongValue(String name) {
        String value = this.getPropertyValue(name);
        try {
            if (value != null) {
                return Long.valueOf(value);
            }
            return (Long)this.getPropertyDefaultValue(name);
        }
        catch (RuntimeException exception) {
            Trace.logError(JettyAdvancedProperties.class, "Failed to cast value '" + value + "' of property '" + name + "' to long.");
            Trace.logException(JettyAdvancedProperties.class, exception, true);
            throw exception;
        }
    }

    @Override
    public Boolean getPropertyBooleanValue(String name) {
        String value = this.getPropertyValue(name);
        try {
            if (value != null) {
                return Boolean.valueOf(value);
            }
            return (Boolean)this.getPropertyDefaultValue(name);
        }
        catch (RuntimeException exception) {
            Trace.logError(JettyAdvancedProperties.class, "Failed to cast value '" + value + "' of property '" + name + "' to boolean.");
            Trace.logException(JettyAdvancedProperties.class, exception, true);
            throw exception;
        }
    }

    @Override
    public void setPropertyValue(String name, String value) {
        if (this.authenticationContext == null || !this.authenticationContext.getUser().isAdministrator()) {
            throw new ApiKeyErrorException("Only admin user can change api key defaults.");
        }
        ApiKeyDefault apiKeyDefault = ApiKeyDefaultsServiceImpl.getDefaults().get(name);
        if (apiKeyDefault == null) {
            throw new ApiKeyErrorException("Unknown property '" + name + "'.");
        }
        apiKeyDefault = new ApiKeyDefault(name, value, apiKeyDefault.getDescription());
        try {
            ((ApiKeyDefaultsDao)this.dao).insert(apiKeyDefault);
        }
        catch (Exception exception) {
            ((ApiKeyDefaultsDao)this.dao).update(apiKeyDefault);
        }
        this.apiKeyDefaultsUpdateListeners.forEach(l -> l.onPropertyChanged(name));
    }

    @Override
    public List<ApiKeyDefault> getAllProperties() {
        return ((ApiKeyDefaultsDao)this.dao).select(null);
    }

    @Override
    public List<String> listProperties() {
        return new ArrayList<String>(defaults.keySet());
    }

    static {
        ApiKeyDefaultsServiceImpl.registerProperty("api.key.cache.expiration.check.period.in.sec", 60, "How often to check expired objects in cache.");
        ApiKeyDefaultsServiceImpl.registerProperty("api.key.remove.timeout.after.deletion.in.sec", 86400, "Timeout in seconds to wait since application/token was marked as deleted and before application/token being removed from table. Default 24 hours.");
        ApiKeyDefaultsServiceImpl.registerProperty("api.key.cleaner.run.period.in.sec", 3600, "How often to run cleaner thread. Cleaner thread deletes expired tokens and removes deleted tokens and applications. 1 hour default.");
        ApiKeyDefaultsServiceImpl.registerProperty("api.key.token.expiration.in.sec", 864000, "Token expiration default timeout in seconds. Default value 10 days. A value -1 means never expires.");
        ApiKeyDefaultsServiceImpl.registerProperty("api.key.token.extend.period.in.sec", -1, "Timeout in seconds between updates of token last accessed time in dataspace. A value -1 means don't extend.");
        ApiKeyDefaultsServiceImpl.registerProperty("api.key.token.delete.timeout.after.expiration.in.sec", 43200, "Timeout in seconds to wait since token has expired and before marking token as deleted on master node. 12 hours default. A value of -1 means don't wait.");
        ApiKeyDefaultsServiceImpl.registerProperty("api.key.applications.cache.expiration.in.sec", 3600, "Api key applications cache expiration timeout in seconds. ");
        ApiKeyDefaultsServiceImpl.registerProperty("api.key.applications.cache.max.objects", 100, "Api key applications cache max size.");
        ApiKeyDefaultsServiceImpl.registerProperty("api.key.tokens.cache.expiration.in.sec", 60, "Api key tokens cache expiration timeout in seconds.");
        ApiKeyDefaultsServiceImpl.registerProperty("api.key.tokens.cache.max.objects", 1000, "Api key tokens cache max size.");
        ApiKeyDefaultsServiceImpl.registerProperty("api.key.dataspace.accessors.pool.max.size", 1, "Maximum dataspace accessors pool size used for api key applications, tokens access and management. To apply property changes node restart required.");
        ApiKeyDefaultsServiceImpl.registerProperty("api.key.dataspace.accessors.pool.expiration.in.sec", 60, "Dataspace accessor will be closed and removed from pool after this time in seconds of inactivity. To apply property changes node restart required.");
    }
}

