/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.runtime.service;

import com.streamscape.sef.network.http.server.authentication.runtime.AuthenticationContext;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.DaoFactory;
import com.streamscape.sef.network.http.server.authentication.runtime.service.AbstractService;
import com.streamscape.sef.network.http.server.authentication.runtime.service.Service;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ServiceFactory;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class AbstractServiceFactory
implements ServiceFactory<AbstractService<?>> {
    private Class<?> serviceClazz;
    private DaoFactory<?> daoFactory;
    private AuthenticationContext authenticationContext;

    public void setServiceClazz(Class<?> serviceClazz) {
        this.serviceClazz = serviceClazz;
    }

    public void setDaoFactory(DaoFactory<?> daoFactory) {
        this.daoFactory = daoFactory;
    }

    public void setAuthenticationContext(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    @Override
    public AbstractService<?> create() {
        return (AbstractService)this.create(this.serviceClazz);
    }

    @Override
    public <T> T create(Class<T> clazz) {
        AbstractService<?> service = this.doCreateServiceInstance(clazz);
        this.doInitServiceInstance(clazz, service);
        return (T)service;
    }

    protected abstract AbstractService<?> doCreateServiceInstance(Type var1);

    protected void doInitServiceInstance(Type clazz, AbstractService<?> service) {
        service.setDao(this.daoFactory.create(this.getDaoClassFromServiceClass(service.getClass())));
        service.setAuthenticationContext(this.authenticationContext);
    }

    private Class<?> getDaoClassFromServiceClass(Type type) {
        if (!(type instanceof Class)) {
            return null;
        }
        Class clazz = (Class)type;
        if (!Service.class.isAssignableFrom(clazz)) {
            return null;
        }
        for (Type i : clazz.getGenericInterfaces()) {
            ParameterizedType itype;
            if (i instanceof ParameterizedType && (itype = (ParameterizedType)i).getRawType() == Service.class) {
                return (Class)itype.getActualTypeArguments()[0];
            }
            if (!(i instanceof Class)) {
                return null;
            }
            Class<?> result = this.getDaoClassFromServiceClass((Class)i);
            if (result == null) continue;
            return result;
        }
        return this.getDaoClassFromServiceClass(clazz.getGenericSuperclass());
    }
}

