/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.runtime.model;

import com.streamscape.Trace;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.sef.network.http.server.authentication.runtime.model.Application;
import com.streamscape.sef.network.http.server.uri.UriTree;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jetty.http.HttpMethod;

public class ApplicationResourceMatcher {
    public static Matcher create() {
        return new UriTreeBasedMatcher();
    }

    public static Matcher create(Collection<? extends Application.ResourceBase> resources, ResourceCreator creator) {
        return new UriTreeBasedMatcher(ApplicationResourceMatcher.mergeResources(resources, creator));
    }

    public static StringBuilder printTree(Matcher matcher, StringBuilder builder) {
        return ((UriTreeBasedMatcher)matcher).tree.toString(builder);
    }

    private static Set<Application.ResourceBase> mergeResources(Collection<? extends Application.ResourceBase> resources, ResourceCreator creator) {
        HashSet<Application.ResourceBase> mergedResources = new HashSet<Application.ResourceBase>();
        for (Application.ResourceBase resourceBase : resources) {
            Application.ResourceBase mergedResource = mergedResources.stream().filter(r -> r.getUrl() == resource.getUrl() || r.getUrl() != null && r.getUrl().trim().equalsIgnoreCase(resource.getUrl().trim())).findFirst().orElse(null);
            if (mergedResource != null) {
                MethodMatcher mergedResourceMatcher = MethodMatcher.forMethodPattern(mergedResource.getMethod());
                MethodMatcher resourceMatcher = MethodMatcher.forMethodPattern(resourceBase.getMethod());
                if (mergedResourceMatcher.allMethods) continue;
                if (resourceMatcher.allMethods) {
                    mergedResources.remove(mergedResource);
                    mergedResources.add(resourceBase);
                    continue;
                }
                Object mergedMethods = mergedResource.getMethod();
                boolean extended = false;
                for (String method : resourceMatcher.methods) {
                    if (mergedResourceMatcher.matches(method)) continue;
                    mergedMethods = (String)mergedMethods + "|" + method;
                    extended = true;
                }
                if (!extended) continue;
                mergedResources.remove(mergedResource);
                mergedResources.add(creator.create((String)mergedMethods, resourceBase.getUrl()));
                continue;
            }
            mergedResources.add(resourceBase);
        }
        return mergedResources;
    }

    static class UriTreeBasedMatcher
    implements Matcher {
        private UriTree<ResourceInfo> tree;

        public UriTreeBasedMatcher() {
        }

        public UriTreeBasedMatcher(Set<Application.ResourceBase> resources) {
            this.init(resources);
        }

        @Override
        public void init(Set<? extends Application.ResourceBase> resources) {
            this.tree = this.buildTree(resources);
        }

        @Override
        public Application.ResourceBase matches(String method, String uri) {
            ResourceInfo info = this.matches(uri);
            if (info != null && (method == null || info.methodMatcher.matches(method))) {
                return info.resource;
            }
            return null;
        }

        @Override
        public ResourceInfo matches(String uri) {
            try {
                UriTree.ParsedUri<ResourceInfo> parsed = this.tree.parse(uri);
                if (parsed != null) {
                    return parsed.getData();
                }
            }
            catch (UriTree.UriException exception) {
                Trace.logError(this, "Uri parsing error.");
                Trace.logException(this, exception, false);
            }
            return null;
        }

        private UriTree<ResourceInfo> buildTree(Set<? extends Application.ResourceBase> resources) {
            UriTree<ResourceInfo> tree = new UriTree<ResourceInfo>();
            for (Application.ResourceBase resourceBase : resources) {
                try {
                    tree.add(resourceBase.getUrl(), new ResourceInfo(resourceBase), false);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("Invalid resource '" + String.valueOf(resourceBase) + "'. " + exception.getMessage());
                }
            }
            return tree;
        }

        @Override
        public void validate(Set<? extends Application.ResourceBase> resources) {
            this.buildTree(resources);
        }
    }

    public static interface ResourceCreator {
        public Application.ResourceBase create(String var1, String var2);
    }

    public static class MethodMatcher {
        static final Set<String> allowedMethods = Arrays.asList(HttpMethod.values()).stream().map(m -> m.asString().toUpperCase()).collect(Collectors.toSet());
        private Set<String> methods;
        private boolean allMethods = false;

        public boolean matches(String method) {
            if (this.methods == null) {
                throw new IllegalArgumentException("Not initialized.");
            }
            if (method == null) {
                return false;
            }
            if (this.allMethods) {
                return allowedMethods.contains(method);
            }
            return this.methods.contains(method.trim().toUpperCase());
        }

        private MethodMatcher() {
        }

        public static MethodMatcher forMethodPattern(String method) {
            MethodMatcher result = new MethodMatcher();
            result.init(method);
            return result;
        }

        public static boolean matches(String template, String method) {
            return MethodMatcher.forMethodPattern(template).matches(method);
        }

        private void init(String method) {
            Set<String> split = MethodMatcher.split(method);
            this.validate(split);
            this.methods = split;
            this.allMethods = this.methods.remove("*");
        }

        public static Set<String> split(String method) {
            if (method == null) {
                throw new IllegalArgumentException("Http method is null.");
            }
            if ((method = method.trim()).length() == 0) {
                throw new IllegalArgumentException("Http method empty.");
            }
            return StringUtils.split(method, '|').stream().map(m -> m.trim().toUpperCase()).collect(Collectors.toSet());
        }

        private void validate(String method) {
            this.validate(MethodMatcher.split(method));
        }

        private void validate(Set<String> methods) {
            if (!allowedMethods.containsAll(methods)) {
                HashSet<String> copy = new HashSet<String>(methods);
                copy.removeAll(allowedMethods);
                throw new IllegalArgumentException("Unknown http methods " + String.valueOf(copy) + ".");
            }
        }

        static {
            allowedMethods.add("*");
        }
    }

    public static class ResourceInfo {
        private Application.ResourceBase resource;
        private MethodMatcher methodMatcher;

        ResourceInfo(Application.ResourceBase resource) {
            this.resource = resource;
            this.methodMatcher = MethodMatcher.forMethodPattern(resource.getMethod());
        }

        public Application.ResourceBase getResource() {
            return this.resource;
        }

        public MethodMatcher getMethodMatcher() {
            return this.methodMatcher;
        }

        public String toString() {
            return this.resource.toString();
        }
    }

    public static interface Matcher {
        public void init(Set<? extends Application.ResourceBase> var1);

        public Application.ResourceBase matches(String var1, String var2);

        public ResourceInfo matches(String var1);

        public void validate(Set<? extends Application.ResourceBase> var1);
    }
}

