/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.runtime.model;

import com.streamscape.Trace;
import com.streamscape.sef.network.http.server.authentication.runtime.model.ApiKeySecurityBinding;
import com.streamscape.sef.network.http.server.authentication.runtime.model.ApplicationResourceMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="Application")
public class Application {
    private String name;
    private String description;
    private long createdAt;
    private String owner;
    private String applicationId;
    private boolean global;
    private Set<Resource> resources;
    private Set<ApiKeySecurityBinding> securityBindings;
    private long lastUpdatedAt;
    private String masterNode;
    private long deletedAt;
    public transient ApplicationResourceMatcher.Matcher matcher;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    @XmlElementWrapper(name="resources")
    public Set<Resource> getResources() {
        if (this.resources != null) {
            return new HashSet<Resource>(this.resources);
        }
        return new HashSet<Resource>();
    }

    public void setResources(Collection<Resource> resources) {
        if (resources != null) {
            this.checkResourcesUnique(resources);
            this.resources = new HashSet<Resource>(resources);
        } else {
            this.resources = new HashSet<Resource>();
        }
    }

    public void removeResources(Collection<Resource> resources) {
        if (this.resources != null && resources != null) {
            this.resources.removeAll(resources);
        }
    }

    public void addResource(Resource resource) {
        this.addResources(Arrays.asList(resource));
    }

    public void addResources(Collection<Resource> resources) {
        if (this.resources == null) {
            this.resources = new HashSet<Resource>();
        }
        ArrayList<Resource> mergedResources = new ArrayList<Resource>();
        mergedResources.addAll(this.resources);
        mergedResources.addAll(resources);
        this.checkResourcesUnique(mergedResources);
        this.resources = new HashSet<Resource>(mergedResources);
    }

    @XmlElementWrapper(name="securityBindings")
    public Set<ApiKeySecurityBinding> getSecurityBindings() {
        return this.securityBindings;
    }

    public Application setSecurityBindings(Set<ApiKeySecurityBinding> securityBindings) {
        this.securityBindings = securityBindings;
        return this;
    }

    public Application addSecurityBinding(ApiKeySecurityBinding securityBinding) {
        if (this.securityBindings == null) {
            this.securityBindings = new HashSet<ApiKeySecurityBinding>();
        }
        this.securityBindings.add(securityBinding);
        return this;
    }

    public long getLastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public Application setLastUpdatedAt(long lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
        return this;
    }

    public String getMasterNode() {
        return this.masterNode;
    }

    public Application setMasterNode(String masterNode) {
        this.masterNode = masterNode;
        return this;
    }

    public long getDeletedAt() {
        return this.deletedAt;
    }

    public Application setDeletedAt(long deletedAt) {
        this.deletedAt = deletedAt;
        return this;
    }

    public boolean equalsWithoutApplicationId(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Application)) {
            return false;
        }
        Application that = (Application)o;
        return this.global == that.global && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.resources, that.resources) && Objects.equals(this.securityBindings, that.securityBindings);
    }

    public Resource matches(String method, String uri) {
        if (this.matcher == null) {
            this.matcher = ApplicationResourceMatcher.create(this.getResources(), (m, u) -> new Resource(m, u));
            if (Trace.isDebugEnabled(this.getClass())) {
                StringBuilder builder = ApplicationResourceMatcher.printTree(this.matcher, new StringBuilder());
                Trace.logDebug(this, "Application '{}' resources tree:\n{}", this.getName(), builder.toString());
            }
        }
        return (Resource)this.matcher.matches(method, uri);
    }

    private void checkResourcesUnique(Collection<Resource> mergedResources) {
        HashSet<Resource> mergedResourcesSet = new HashSet<Resource>();
        for (Resource resource : mergedResources) {
            if (mergedResourcesSet.contains(resource)) {
                throw new IllegalArgumentException("Resources validation failed. Duplicate resource '" + resource.toString() + "'.");
            }
            mergedResourcesSet.add(resource);
        }
    }

    @XmlRootElement(name="Resource")
    public static class Resource
    implements ResourceBase {
        private String method;
        private String url;
        private String name;
        private String description;

        public Resource() {
        }

        public Resource(String method, String url) {
            this(method, url, null, null);
        }

        public Resource(String method, String url, String name, String description) {
            this.method = method;
            this.url = url;
            this.name = name;
            this.description = description;
        }

        @Override
        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        @Override
        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Resource)) {
                return false;
            }
            Resource resource = (Resource)o;
            return (this.method == resource.method || this.method != null && this.method.equalsIgnoreCase(resource.method)) && (this.url == resource.url || this.url != null && this.url.equalsIgnoreCase(resource.url));
        }

        public int hashCode() {
            return Objects.hash(this.method, this.url);
        }

        public String toString() {
            return this.method + " - " + this.url;
        }
    }

    public static interface ResourceBase {
        public String getUrl();

        public String getMethod();
    }
}

