/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.runtime.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.streamscape.sef.network.http.server.authentication.runtime.model.ApiKeySecurityBinding;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlElementWrapper;

public class ApiKeyToken {
    private String name;
    private String description;
    private String tokenId;
    private String applicationId;
    private String owner;
    private int expiresIn;
    private long createdAt;
    private long lastAccessedAt;
    private int extendPeriod;
    private boolean global;
    private Set<ApiKeySecurityBinding> securityBindings;
    private long lastUpdatedAt;
    private String masterNode;
    private long deletedAt;
    private int deleteTimeoutAfterExpiration;
    private String securityTokenId;
    private Map<ApiKeySecurityBinding, String> securityBindingsValues;
    private transient long lastAccessedAtOriginal = 0L;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public void setTokenId(String tokenId) {
        this.tokenId = tokenId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public int getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(int expiresIn) {
        this.expiresIn = expiresIn;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public long getLastAccessedAt() {
        return this.lastAccessedAt;
    }

    public void setLastAccessedAt(long lastAccessedAt) {
        this.lastAccessedAt = lastAccessedAt;
        if (this.lastAccessedAtOriginal == 0L) {
            this.lastAccessedAtOriginal = lastAccessedAt;
        }
    }

    public int getExtendPeriod() {
        return this.extendPeriod;
    }

    public void setExtendPeriod(int extendPeriod) {
        this.extendPeriod = extendPeriod;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    @XmlElementWrapper(name="securityBindings")
    public Set<ApiKeySecurityBinding> getSecurityBindings() {
        return this.securityBindings;
    }

    public ApiKeyToken setSecurityBindings(Set<ApiKeySecurityBinding> securityBindings) {
        this.securityBindings = securityBindings;
        return this;
    }

    public ApiKeyToken addSecurityBinding(ApiKeySecurityBinding securityBinding) {
        if (this.securityBindings == null) {
            this.securityBindings = new HashSet<ApiKeySecurityBinding>();
        }
        this.securityBindings.add(securityBinding);
        return this;
    }

    public long getLastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public ApiKeyToken setLastUpdatedAt(long lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
        return this;
    }

    public String getMasterNode() {
        return this.masterNode;
    }

    public ApiKeyToken setMasterNode(String masterNode) {
        this.masterNode = masterNode;
        return this;
    }

    public long getDeletedAt() {
        return this.deletedAt;
    }

    public ApiKeyToken setDeletedAt(long deletedAt) {
        this.deletedAt = deletedAt;
        return this;
    }

    public long getDeleteTimeoutAfterExpiration() {
        return this.deleteTimeoutAfterExpiration;
    }

    public ApiKeyToken setDeleteTimeoutAfterExpiration(int deleteTimeoutAfterExpiration) {
        this.deleteTimeoutAfterExpiration = deleteTimeoutAfterExpiration;
        return this;
    }

    @JsonIgnore
    public String getSecurityTokenId() {
        return this.securityTokenId;
    }

    public void setSecurityTokenId(String securityTokenId) {
        this.securityTokenId = securityTokenId;
    }

    @JsonIgnore
    public Map<ApiKeySecurityBinding, String> getSecurityBindingsValues() {
        return this.securityBindingsValues;
    }

    public ApiKeyToken setSecurityBindingsValues(Map<ApiKeySecurityBinding, String> securityBindingsValues) {
        this.securityBindingsValues = securityBindingsValues;
        return this;
    }

    public boolean isLastAccessedAtChanged() {
        return this.lastAccessedAtOriginal != 0L;
    }

    public long getLastAccessedAtOriginal() {
        return this.lastAccessedAtOriginal;
    }

    public static String trim(String token) {
        if (token != null && token.length() > 0) {
            return token.substring(0, 5) + "****" + token.substring(token.length() - 4);
        }
        return token;
    }
}

