/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.runtime.dao;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public interface Criteria {
    public String getTemplate();

    public List<Object> getArguments();

    public Criteria lookupCriteriaForColumn(String var1);

    public static class AndCriteria
    implements Criteria {
        private Criteria c1;
        private Criteria c2;

        public AndCriteria(Criteria c1, Criteria c2) {
            this.c1 = c1;
            this.c2 = c2;
        }

        @Override
        public String getTemplate() {
            return "(" + this.c1.getTemplate() + ") and (" + this.c2.getTemplate() + ")";
        }

        @Override
        public List<Object> getArguments() {
            ArrayList<Object> result = new ArrayList<Object>(this.c1.getArguments());
            result.addAll(this.c2.getArguments());
            return result;
        }

        @Override
        public Criteria lookupCriteriaForColumn(String name) {
            Criteria l1 = this.c1.lookupCriteriaForColumn(name);
            if (l1 == null) {
                l1 = this.c2.lookupCriteriaForColumn(name);
            }
            return l1;
        }
    }

    public static class OrCriteria
    implements Criteria {
        private Criteria c1;
        private Criteria c2;

        public OrCriteria(Criteria c1, Criteria c2) {
            this.c1 = c1;
            this.c2 = c2;
        }

        @Override
        public String getTemplate() {
            return "(" + this.c1.getTemplate() + ") or (" + this.c2.getTemplate() + ")";
        }

        @Override
        public List<Object> getArguments() {
            ArrayList<Object> result = new ArrayList<Object>(this.c1.getArguments());
            result.addAll(this.c2.getArguments());
            return result;
        }

        @Override
        public Criteria lookupCriteriaForColumn(String name) {
            Criteria l1 = this.c1.lookupCriteriaForColumn(name);
            if (l1 == null) {
                l1 = this.c2.lookupCriteriaForColumn(name);
            }
            return l1;
        }
    }

    public static class InCriteria
    implements Criteria {
        private String columnName;
        private String operation;
        private String value;

        public InCriteria(String columnName, String operation, String value) {
            this.columnName = columnName;
            this.operation = operation;
            this.value = value;
        }

        @Override
        public String getTemplate() {
            return this.columnName + " " + this.operation + " " + this.value;
        }

        @Override
        public List<Object> getArguments() {
            return Collections.emptyList();
        }

        @Override
        public Criteria lookupCriteriaForColumn(String name) {
            return this.columnName.equals(name) ? this : null;
        }
    }

    public static class OperationCriteria
    implements Criteria {
        private String columnName;
        private String operation;
        private Object value;

        public OperationCriteria(String columnName, String operation, Object value) {
            this.columnName = columnName;
            this.operation = operation;
            this.value = value;
        }

        @Override
        public String getTemplate() {
            return this.columnName + " " + this.operation + " ? ";
        }

        @Override
        public List<Object> getArguments() {
            return Arrays.asList(this.value);
        }

        @Override
        public Criteria lookupCriteriaForColumn(String name) {
            return this.columnName.equals(name) ? this : null;
        }
    }

    public static class TrueCriteria
    implements Criteria {
        @Override
        public String getTemplate() {
            return "1=1";
        }

        @Override
        public List<Object> getArguments() {
            return new ArrayList<Object>();
        }

        @Override
        public Criteria lookupCriteriaForColumn(String name) {
            return null;
        }
    }

    public static class Builder {
        public static Criteria tr() {
            return new TrueCriteria();
        }

        public static Criteria eq(String columnName, Object value) {
            return new OperationCriteria(columnName, "=", value);
        }

        public static Criteria neq(String columnName, Object value) {
            return new OperationCriteria(columnName, "!=", value);
        }

        public static Criteria gt(String columnName, Object value) {
            return new OperationCriteria(columnName, ">", value);
        }

        public static Criteria ge(String columnName, Object value) {
            return new OperationCriteria(columnName, ">=", value);
        }

        public static Criteria lt(String columnName, Object value) {
            return new OperationCriteria(columnName, "<", value);
        }

        public static Criteria le(String columnName, Object value) {
            return new OperationCriteria(columnName, "<=", value);
        }

        public static Criteria in(String columnName, String value) {
            return new InCriteria(columnName, "in", value);
        }

        public static Criteria notin(String columnName, String value) {
            return new InCriteria(columnName, "not in", value);
        }

        public static Criteria or(Criteria c1, Criteria c2) {
            return new OrCriteria(c1, c2);
        }

        public static Criteria and(Criteria c1, Criteria c2) {
            return new AndCriteria(c1, c2);
        }
    }
}

