/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.runtime.dao;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.dispatcher.AbstractApiKeyManager;
import com.streamscape.sef.dispatcher.AbstractDaoReplicated;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.ApplicationDao;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.Criteria;
import com.streamscape.sef.network.http.server.authentication.runtime.model.Application;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApplicationServiceImpl;
import java.util.List;

public class ApplicationDaoReplicated
extends AbstractDaoReplicated
implements ApplicationDao {
    private final ApplicationDao dao;

    public ApplicationDaoReplicated(ApplicationDao dao, RuntimeContext context) {
        super(context);
        this.dao = dao;
    }

    @Override
    public void insert(Application application) {
        this.dao.insert(application);
        if (application.isGlobal() && !ApplicationServiceImpl.systemApplications.containsKey(application.getName())) {
            this.invokeReplication("insert", application);
        }
    }

    @Override
    public void updateByApplicationId(Application application) {
        this.dao.updateByApplicationId(application);
        if (application.isGlobal() && !ApplicationServiceImpl.systemApplications.containsKey(application.getName())) {
            this.invokeReplication("updateByApplicationId", application);
        }
    }

    @Override
    public void update(Application application, Criteria criteria) {
        this.dao.update(application, criteria);
        if (application.isGlobal() && !ApplicationServiceImpl.systemApplications.containsKey(application.getName())) {
            this.invokeReplication("update", application, criteria);
        }
    }

    @Override
    public List<Application> select(Criteria criteria, boolean withResources) {
        return this.dao.select(criteria, withResources);
    }

    @Override
    public Application getByApplicationId(String applicationId, boolean withResources) {
        return this.dao.getByApplicationId(applicationId, withResources);
    }

    @Override
    public List<String> list(Criteria criteria) {
        return this.dao.list(criteria);
    }

    @Override
    public int deleteByApplicationId(String applicationId) {
        int result = this.dao.deleteByApplicationId(applicationId);
        this.invokeReplication("deleteByApplicationId", applicationId);
        return result;
    }

    @Override
    public int delete(Criteria criteria) {
        int result = this.dao.delete(criteria);
        this.invokeReplication("delete", criteria);
        return result;
    }

    @Override
    public List<String> removeDeleted(String masterNodeName, int timeout) {
        List<String> result = this.dao.removeDeleted(masterNodeName, timeout);
        if (result != null && result.size() > 0) {
            this.invokeReplication("removeDeletedApplications", result);
        }
        return result;
    }

    @Override
    public void removeDeletedApplications(List<String> tokenIds) {
        this.dao.removeDeletedApplications(tokenIds);
    }

    public void invokeReplication(String methodName, Object ... parameters) {
        super.invokeReplication(AbstractApiKeyManager.Target.API_KEY_APPLICATION, methodName, parameters);
    }
}

