/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.runtime.dao;

import com.streamscape.Trace;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.AbstractDao;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.ApplicationDao;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.Criteria;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.DaoException;
import com.streamscape.sef.network.http.server.authentication.runtime.model.Application;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ApplicationDaoImpl
extends AbstractDao
implements ApplicationDao {
    @Override
    protected void onInitialize() {
        block8: {
            block7: {
                Trace.logDebug(this, "Initializing Application DAO...");
                try {
                    if (!this.containsDeletedAt()) {
                        this.execute("drop collection API_KEY_TOKENS if exists cascade", "Failed to drop API_KEY_TOKENS.", new Object[0]);
                        this.execute("drop collection API_KEY_APPLICATIONS if exists cascade", "Failed to drop API_KEY_APPLICATIONS.", new Object[0]);
                    }
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, true);
                }
                try {
                    this.execute("create persistent table API_KEY_APPLICATIONS\n(\nNAME string,\nDESCRIPTION string,\nCREATED_AT SqlTimestamp,\nOWNER string,\nAPPLICATION_ID string,\nREPLICATED boolean,\nRESOURCES string,\nSECURITY_BINDINGS string,\nLAST_UPDATED_AT SqlTimestamp,\nMASTER_NODE string,\nDELETED_AT long DEFAULT 0,\nPRIMARY KEY (APPLICATION_ID)\n)", "Cannot create API_KEY_APPLICATIONS table.", new Object[0]);
                }
                catch (Exception exception) {
                    if (this.isObjectNameAlreadyExistsException(exception)) break block7;
                    throw exception;
                }
            }
            try {
                this.execute("create unique index API_KEY_APPLICATIONS_OWNER_NAME_IDX on API_KEY_APPLICATIONS (OWNER, NAME, DELETED_AT)", "Cannot create index on Application table.", new Object[0]);
            }
            catch (Exception exception) {
                if (this.isObjectNameAlreadyExistsException(exception)) break block8;
                throw exception;
            }
        }
        Trace.logDebug(this, "Application DAO initialized.");
    }

    private boolean containsDeletedAt() {
        try {
            RowSet rowSet = this.execute("describe collection API_KEY_APPLICATIONS tuples", "Failed to describe API_KEY_APPLICATIONS.", new Object[0]);
            while (rowSet.next()) {
                if (!rowSet.getString(1).equals("DELETED_AT")) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return true;
        }
    }

    @Override
    public void insert(Application application) {
        try {
            this.execute("insert into API_KEY_APPLICATIONS (NAME, DESCRIPTION, CREATED_AT, OWNER, APPLICATION_ID, REPLICATED, RESOURCES, SECURITY_BINDINGS,LAST_UPDATED_AT, MASTER_NODE, DELETED_AT) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", "Cannot insert new application.", application.getName(), application.getDescription(), new Timestamp(application.getCreatedAt()), application.getOwner().toLowerCase(), application.getApplicationId(), application.isGlobal(), this.serializeResources(application), this.serializeSecurityBindings(application.getSecurityBindings()), new Timestamp(application.getLastUpdatedAt()), application.getMasterNode(), 0);
        }
        catch (Exception exception) {
            if (this.isUniqueConstraintOrIndexViolations(exception, "API_KEY_APPLICATIONS_OWNER_NAME_IDX")) {
                throw new DaoException("Application with name '" + application.getName() + "' for owner user '" + application.getOwner() + "' already exists.");
            }
            throw exception;
        }
    }

    @Override
    public void updateByApplicationId(Application application) {
        this.update(application, Criteria.Builder.eq("APPLICATION_ID", application.getApplicationId()));
    }

    @Override
    public void update(Application application, Criteria criteria) {
        if (criteria == null) {
            criteria = Criteria.Builder.tr();
        }
        criteria = this.addDeletedAt(criteria);
        this.execute("update API_KEY_APPLICATIONS set NAME = ?, DESCRIPTION = ?, CREATED_AT = ?, OWNER = ?, APPLICATION_ID = ?, REPLICATED = ?, RESOURCES = ?, SECURITY_BINDINGS = ?,LAST_UPDATED_AT = ? " + this.where(criteria), "Cannot update application.", this.where(application.getName(), application.getDescription(), application.getCreatedAt(), application.getOwner().toLowerCase(), application.getApplicationId(), application.isGlobal(), this.serializeResources(application), this.serializeSecurityBindings(application.getSecurityBindings()), new Timestamp(application.getLastUpdatedAt()), criteria));
    }

    @Override
    public Application getByApplicationId(String applicationId, boolean withResources) {
        List<Application> applications = this.select(Criteria.Builder.eq("APPLICATION_ID", applicationId), withResources);
        if (applications.size() > 0) {
            return applications.get(0);
        }
        return null;
    }

    @Override
    public List<Application> select(Criteria criteria, boolean withResources) {
        if (criteria == null) {
            criteria = Criteria.Builder.tr();
        }
        criteria = this.addDeletedAt(criteria);
        RowSet rowSet = this.execute("select NAME, DESCRIPTION, CREATED_AT, OWNER, APPLICATION_ID, REPLICATED, SECURITY_BINDINGS, LAST_UPDATED_AT, MASTER_NODE, DELETED_AT" + (withResources ? ", RESOURCES" : "") + " from  API_KEY_APPLICATIONS " + this.where(criteria), "Cannot select applications.", criteria.getArguments().toArray());
        ArrayList<Application> applications = new ArrayList<Application>();
        try {
            while (rowSet.next()) {
                Application application = new Application();
                application.setName(rowSet.getString("NAME"));
                application.setDescription(rowSet.getString("DESCRIPTION"));
                application.setCreatedAt(rowSet.getTimestamp("CREATED_AT").getTime());
                application.setOwner(rowSet.getString("OWNER"));
                application.setApplicationId(rowSet.getString("APPLICATION_ID"));
                application.setGlobal(rowSet.getBoolean("REPLICATED"));
                if (withResources) {
                    application.setResources(this.deserializeResources(rowSet.getString("RESOURCES")));
                }
                application.setSecurityBindings(this.deserializeSecurityBindings(rowSet.getString("SECURITY_BINDINGS")));
                application.setLastUpdatedAt(rowSet.getTimestamp("LAST_UPDATED_AT").getTime());
                application.setMasterNode(rowSet.getString("MASTER_NODE"));
                application.setDeletedAt(rowSet.getLong("DELETED_AT"));
                applications.add(application);
            }
        }
        catch (Exception exception) {
            throw new DaoException("Failed to iterate over applications row set.", exception);
        }
        return applications;
    }

    @Override
    public List<String> list(Criteria criteria) {
        if (criteria == null) {
            criteria = Criteria.Builder.tr();
        }
        criteria = this.addDeletedAt(criteria);
        RowSet rowSet = this.execute("select APPLICATION_ID from API_KEY_APPLICATIONS " + this.where(criteria), "Cannot select applications.", criteria.getArguments().toArray());
        ArrayList<String> applications = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                applications.add(rowSet.getString("APPLICATION_ID"));
            }
        }
        catch (Exception exception) {
            throw new DaoException("Failed to iterate over applications row set.", exception);
        }
        return applications;
    }

    @Override
    public int deleteByApplicationId(String applicationId) {
        return this.delete(Criteria.Builder.eq("APPLICATION_ID", applicationId));
    }

    @Override
    public int delete(Criteria criteria) {
        if (criteria == null) {
            criteria = Criteria.Builder.tr();
        }
        criteria = this.addDeletedAt(criteria);
        RowSet rowSet = this.execute("update  API_KEY_APPLICATIONS set DELETED_AT = ? " + this.where(criteria), "Cannot delete applications.", this.where(System.currentTimeMillis(), criteria));
        try {
            if (rowSet.next()) {
                return rowSet.getInt(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 0;
    }

    @Override
    public List<String> removeDeleted(String masterNodeName, int timeout) {
        RowSet rowSet = this.execute("select APPLICATION_ID from API_KEY_APPLICATIONS where MASTER_NODE = ? and DELETED_AT > 0 and (long)unixTimestamp(currentTimestamp())-DELETED_AT >= ?", "Cannot select deleted api key applications.", masterNodeName, timeout * 1000);
        ArrayList<String> applicationIds = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                applicationIds.add(rowSet.getString(1));
            }
        }
        catch (SQLException exception) {
            Trace.logException(this, exception, true);
        }
        this.removeDeletedApplications(applicationIds);
        return applicationIds;
    }

    @Override
    public void removeDeletedApplications(List<String> applicationIds) {
        StringBuilder builder = new StringBuilder();
        int count = 0;
        for (String applicationId : applicationIds) {
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append("'").append(applicationId).append("'");
            if (++count != 30) continue;
            this.removeApplications(builder);
            count = 0;
            builder.setLength(0);
        }
        if (count > 0) {
            this.removeApplications(builder);
        }
    }

    private void removeApplications(StringBuilder builder) {
        try {
            this.execute("delete from API_KEY_APPLICATIONS where APPLICATION_ID in (" + builder.toString() + ")", "Cannot remove api key applications " + builder.toString(), new Object[0]);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
    }

    private String serializeResources(Application application) {
        try {
            return this.getJsonSerializer().serialize(application.getResources());
        }
        catch (SerializerException exception) {
            throw new DaoException("Failed to serialize application resources.", exception);
        }
    }

    private Set<Application.Resource> deserializeResources(String json) {
        try {
            return new HashSet<Application.Resource>(Arrays.asList(this.getJsonSerializer().deserialize(Application.Resource[].class, json)));
        }
        catch (SerializerException exception) {
            throw new DaoException("Failed to deserialize application resources.", exception);
        }
    }
}

