/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.runtime.dao;

import com.streamscape.sef.network.http.server.authentication.runtime.cache.ObjectsCache;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.ApplicationDao;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.Criteria;
import com.streamscape.sef.network.http.server.authentication.runtime.model.Application;
import java.util.Collections;
import java.util.List;

public class ApplicationDaoCacheTrigger
implements ApplicationDao {
    private final ApplicationDao dao;
    protected final ObjectsCache<Application> objectsCache;

    public ApplicationDaoCacheTrigger(ApplicationDao dao, ObjectsCache<Application> objectsCache) {
        this.dao = dao;
        this.objectsCache = objectsCache;
    }

    @Override
    public void insert(Application application) {
        this.dao.insert(application);
    }

    @Override
    public void updateByApplicationId(Application application) {
        try {
            this.dao.updateByApplicationId(application);
        }
        finally {
            this.objectsCache.remove(application.getApplicationId());
        }
    }

    @Override
    public void update(Application application, Criteria criteria) {
        try {
            this.dao.update(application, criteria);
        }
        finally {
            if (application.getApplicationId() != null) {
                this.objectsCache.remove(application.getApplicationId());
            } else {
                this.objectsCache.clear();
            }
        }
    }

    @Override
    public Application getByApplicationId(String applicationId, boolean withResources) {
        return this.dao.getByApplicationId(applicationId, withResources);
    }

    @Override
    public List<Application> select(Criteria criteria, boolean withResources) {
        return this.dao.select(criteria, withResources);
    }

    @Override
    public List<String> list(Criteria criteria) {
        return this.dao.list(criteria);
    }

    @Override
    public int deleteByApplicationId(String applicationId) {
        try {
            int n = this.dao.deleteByApplicationId(applicationId);
            return n;
        }
        finally {
            this.objectsCache.remove(applicationId);
        }
    }

    @Override
    public int delete(Criteria criteria) {
        int count = 1;
        try {
            count = this.dao.delete(criteria);
        }
        finally {
            if (count > 0) {
                this.objectsCache.clear();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> removeDeleted(String masterNodeName, int timeout) {
        List<String> result = null;
        try {
            result = this.dao.removeDeleted(masterNodeName, timeout);
        }
        finally {
            if (result == null || result.size() > 0) {
                this.objectsCache.clear();
            }
        }
        return result == null ? Collections.emptyList() : result;
    }

    @Override
    public void removeDeletedApplications(List<String> tokenIds) {
        try {
            this.dao.removeDeletedApplications(tokenIds);
        }
        finally {
            tokenIds.forEach(id -> this.objectsCache.remove((String)id));
        }
    }
}

