/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.runtime.dao;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.dispatcher.AbstractApiKeyManager;
import com.streamscape.sef.dispatcher.AbstractDaoReplicated;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.ApiKeyTokenDao;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.Criteria;
import com.streamscape.sef.network.http.server.authentication.runtime.model.ApiKeyToken;
import java.util.List;

public class ApiKeyTokenDaoReplicated
extends AbstractDaoReplicated
implements ApiKeyTokenDao {
    private final ApiKeyTokenDao dao;

    public ApiKeyTokenDaoReplicated(ApiKeyTokenDao dao, RuntimeContext context) {
        super(context);
        this.dao = dao;
    }

    @Override
    public void insert(ApiKeyToken token) {
        this.dao.insert(token);
        if (token.isGlobal()) {
            this.invokeReplication("insert", token);
        }
    }

    @Override
    public void updateByTokenId(ApiKeyToken token) {
        this.dao.updateByTokenId(token);
        if (token.isGlobal()) {
            this.invokeReplication("updateByTokenId", token);
        }
    }

    @Override
    public void update(ApiKeyToken token, Criteria criteria) {
        this.dao.update(token, criteria);
        if (token.isGlobal()) {
            this.invokeReplication("update", token, criteria);
        }
    }

    @Override
    public void updateTokenLastAccessedAt(ApiKeyToken token) {
        this.dao.updateTokenLastAccessedAt(token);
        if (token.isGlobal()) {
            this.invokeReplication("updateTokenLastAccessedAt", token);
        }
    }

    @Override
    public ApiKeyToken getByTokenId(String tokenId) {
        return this.dao.getByTokenId(tokenId);
    }

    @Override
    public List<ApiKeyToken> select(Criteria criteria) {
        return this.dao.select(criteria);
    }

    @Override
    public List<String> list(Criteria criteria) {
        return this.dao.list(criteria);
    }

    @Override
    public int deleteByTokenId(String tokenId) {
        int result = this.dao.deleteByTokenId(tokenId);
        this.invokeReplication("deleteByTokenId", tokenId);
        return result;
    }

    @Override
    public int delete(Criteria criteria) {
        int result = this.dao.delete(criteria);
        this.invokeReplication("delete", criteria);
        return result;
    }

    @Override
    public int deleteExpired(String masterNodeName, long deletedAt) {
        int result = this.dao.deleteExpired(masterNodeName, deletedAt);
        this.invokeReplication("deleteExpired", masterNodeName, deletedAt);
        return result;
    }

    @Override
    public List<String> removeDeleted(String masterNodeName, int timeout) {
        List<String> result = this.dao.removeDeleted(masterNodeName, timeout);
        if (result != null && result.size() > 0) {
            this.invokeReplication("removeDeletedTokens", result);
        }
        return result;
    }

    @Override
    public void removeDeletedTokens(List<String> tokenIds) {
        this.dao.removeDeletedTokens(tokenIds);
    }

    public void invokeReplication(String methodName, Object ... parameters) {
        super.invokeReplication(AbstractApiKeyManager.Target.API_KEY_TOKEN, methodName, parameters);
    }
}

