/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.runtime.dao;

import com.streamscape.Trace;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.AbstractDao;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.ApiKeyTokenDao;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.Criteria;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.DaoException;
import com.streamscape.sef.network.http.server.authentication.runtime.model.ApiKeySecurityBinding;
import com.streamscape.sef.network.http.server.authentication.runtime.model.ApiKeyToken;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApiKeyTokenDaoImpl
extends AbstractDao
implements ApiKeyTokenDao {
    public static final String API_KEY_APPLICATIONS_UPDATE_EVENT_ID = "event.SDS.API_KEY_APPLICATIONS.afterUpdate";
    public static final String DELETE_TOKEN_FOR_DELETED_APPLICATIONS_FUNCTION = "deleteTokenForDeletedApplications";

    @Override
    protected void onInitialize() {
        block25: {
            block24: {
                block23: {
                    Trace.logDebug(this, "Initializing ApiKeyToken DAO...");
                    try {
                        if (!this.containsDeletedTimeoutAfterExpiration()) {
                            this.execute("drop collection API_KEY_TOKENS if exists cascade ", "Failed to drop API_KEY_TOKENS.", new Object[0]);
                        }
                    }
                    catch (Exception exception) {
                        Trace.logException(this, exception, true);
                    }
                    try {
                        this.execute("create persistent table API_KEY_TOKENS\n(\nNAME string,\nDESCRIPTION string,\nCREATED_AT SqlTimestamp,\nLAST_ACCESSED_AT SqlTimestamp,\nEXTEND_PERIOD int,\nEXPIRES_IN int,\nDELETE_TIMEOUT_AFTER_EXPIRATION int,\nOWNER string,\nTOKEN_ID string,\nAPPLICATION_ID string,\nREPLICATED boolean,\nSECURITY_BINDINGS string,\nSECURITY_BINDINGS_VALUES string,\nSECURITY_TOKEN_ID string,\nLAST_UPDATED_AT SqlTimestamp,\nMASTER_NODE string,\nDELETED_AT long DEFAULT 0,\nPRIMARY KEY (TOKEN_ID),\nCONSTRAINT API_KEY_TOKENS_API_KEY_APPLICATIONS_FK FOREIGN KEY (APPLICATION_ID) REFERENCES API_KEY_APPLICATIONS(APPLICATION_ID) on delete cascade\n)", "Cannot create ApiKeyToken table.", new Object[0]);
                    }
                    catch (Exception exception) {
                        if (this.isObjectNameAlreadyExistsException(exception)) break block23;
                        throw exception;
                    }
                }
                try {
                    this.execute("create unique index API_KEY_TOKENS_OWNER_NAME_IDX on API_KEY_TOKENS (OWNER, NAME, DELETED_AT)", "Cannot create index on ApiKeyToken table.", new Object[0]);
                }
                catch (Exception exception) {
                    if (this.isObjectNameAlreadyExistsException(exception)) break block24;
                    throw exception;
                }
            }
            try {
                this.execute("create event trigger API_KEY_APPLICATIONS_DELETE_TRIGGER \n    on API_KEY_APPLICATIONS \n    event scope local \n    after update  \n    new data as NewRow\n    actionable event as RowChangeEvent\n    when(NewRow.DELETED_AT > 0) \n    as \n    {\n        string applicationId = RowChangeEvent.rowAfter.data[5];\n        long deletedAt = RowChangeEvent.rowAfter.data[11];\n        update API_KEY_TOKENS set DELETED_AT = deletedAt where DELETED_AT = 0 and APPLICATION_ID=applicationId;\n    } \n    enable\n", "Cannot create application update trigger.", new Object[0]);
            }
            catch (Exception exception) {
                if (this.isObjectNameAlreadyExistsException(exception)) break block25;
                throw exception;
            }
        }
        try {
            this.execute("enable event trigger API_KEY_APPLICATIONS_DELETE_TRIGGER", "Cannot enable API_KEY_APPLICATIONS_DELETE_TRIGGER trigger.", new Object[0]);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
        try {
            block26: {
                boolean checkFailed = false;
                try {
                    this.execute("check function deleteTokenForDeletedApplications", "Cannot check function deleteTokenForDeletedApplications.", new Object[0]);
                }
                catch (Exception exception) {
                    if (!this.isObjectDoesnotExistException(exception)) {
                        Trace.logException(this, exception, true);
                    }
                    checkFailed = true;
                }
                if (checkFailed) {
                    try {
                        this.execute("drop function deleteTokenForDeletedApplications if exists", "", new Object[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        this.execute("create function deleteTokenForDeletedApplications() returns int\n{\n    RowSet r = (select APPLICATION_ID,DELETED_AT from API_KEY_APPLICATIONS where DELETED_AT > 0);\n\n    while(r.next())\n    {\n        update API_KEY_TOKENS set DELETED_AT=r.getLong(2) where DELETED_AT = 0 and APPLICATION_ID=r.getString(1);\n    }\n\n    return 0;\n}\n", "Failed to create deleteTokenForDeletedApplications function.", new Object[0]);
                    }
                    catch (Exception exception) {
                        if (this.isObjectNameAlreadyExistsException(exception)) break block26;
                        Trace.logException(this, exception, true);
                    }
                }
            }
            try {
                this.execute("check function deleteTokenForDeletedApplications", "Cannot check function deleteTokenForDeletedApplications.", new Object[0]);
            }
            catch (Exception exception) {
                Trace.logException(this, exception, true);
            }
            this.execute("call deleteTokenForDeletedApplications()", "Failed to execute deleteTokenForDeletedApplications function.", new Object[0]);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
        Trace.logDebug(this, "ApiKeyToken DAO initialized.");
    }

    private boolean containsDeletedTimeoutAfterExpiration() {
        try {
            RowSet rowSet = this.execute("describe collection API_KEY_TOKENS tuples", "Failed to describe API_KEY_TOKENS.", new Object[0]);
            while (rowSet.next()) {
                if (!rowSet.getString(1).equals("DELETE_TIMEOUT_AFTER_EXPIRATION")) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return true;
        }
    }

    @Override
    public void insert(ApiKeyToken token) {
        try {
            this.execute("insert into API_KEY_TOKENS (NAME, DESCRIPTION, CREATED_AT, LAST_ACCESSED_AT, EXTEND_PERIOD, EXPIRES_IN, DELETE_TIMEOUT_AFTER_EXPIRATION, OWNER, TOKEN_ID, APPLICATION_ID, REPLICATED, SECURITY_BINDINGS, SECURITY_TOKEN_ID, SECURITY_BINDINGS_VALUES, LAST_UPDATED_AT, MASTER_NODE, DELETED_AT) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", "Cannot insert new api key token.", token.getName(), token.getDescription(), new Timestamp(token.getCreatedAt()), new Timestamp(token.getLastAccessedAt()), token.getExtendPeriod(), token.getExpiresIn(), token.getDeleteTimeoutAfterExpiration(), token.getOwner().toLowerCase(), token.getTokenId(), token.getApplicationId(), token.isGlobal(), this.serializeSecurityBindings(token.getSecurityBindings()), token.getSecurityTokenId(), this.serializeSecurityBindingsValues(token.getSecurityBindingsValues()), new Timestamp(token.getLastUpdatedAt()), token.getMasterNode(), 0);
        }
        catch (Exception exception) {
            if (this.isUniqueConstraintOrIndexViolations(exception, "API_KEY_TOKENS_OWNER_NAME_IDX")) {
                throw new DaoException("API Key token with name '" + token.getName() + "' for owner user '" + token.getOwner() + "' already exists.");
            }
            if (this.isForeignKeyNoParentViolations(exception)) {
                throw new DaoException("Application with specified id '" + token.getApplicationId() + "' doesn't exist.");
            }
            throw exception;
        }
    }

    @Override
    public void updateByTokenId(ApiKeyToken token) {
        this.update(token, Criteria.Builder.eq("TOKEN_ID", token.getTokenId()));
    }

    @Override
    public void update(ApiKeyToken token, Criteria criteria) {
        if (criteria == null) {
            criteria = Criteria.Builder.tr();
        }
        criteria = this.addDeletedAt(criteria);
        this.execute("update API_KEY_TOKENS set NAME = ?, DESCRIPTION = ?, CREATED_AT = ?, EXTEND_PERIOD = ? , EXPIRES_IN = ?, DELETE_TIMEOUT_AFTER_EXPIRATION = ?, OWNER = ?, TOKEN_ID = ?, APPLICATION_ID = ?, REPLICATED = ?, SECURITY_TOKEN_ID = ?, SECURITY_BINDINGS = ?, SECURITY_BINDINGS_VALUES = ?, LAST_UPDATED_AT = ? " + this.where(criteria), "Cannot update api key token.", this.where(token.getName(), token.getDescription(), new Timestamp(token.getCreatedAt()), token.getExtendPeriod(), token.getExpiresIn(), token.getDeleteTimeoutAfterExpiration(), token.getOwner().toLowerCase(), token.getTokenId(), token.getApplicationId(), token.isGlobal(), token.getSecurityTokenId(), this.serializeSecurityBindings(token.getSecurityBindings()), this.serializeSecurityBindingsValues(token.getSecurityBindingsValues()), new Timestamp(token.getLastUpdatedAt()), criteria));
    }

    @Override
    public void updateTokenLastAccessedAt(ApiKeyToken token) {
        this.execute("update API_KEY_TOKENS set LAST_ACCESSED_AT = ? WHERE TOKEN_ID = ?", "Cannot update api key token.", new Timestamp(token.getLastAccessedAt()), token.getTokenId());
    }

    @Override
    public ApiKeyToken getByTokenId(String tokenId) {
        List<ApiKeyToken> tokens = this.select(Criteria.Builder.eq("TOKEN_ID", tokenId));
        return tokens.size() > 0 ? tokens.get(0) : null;
    }

    @Override
    public List<ApiKeyToken> select(Criteria criteria) {
        if (criteria == null) {
            criteria = Criteria.Builder.tr();
        }
        criteria = this.addDeletedAt(criteria);
        RowSet rowSet = this.execute("select NAME, DESCRIPTION, CREATED_AT, LAST_ACCESSED_AT, EXTEND_PERIOD, EXPIRES_IN, DELETE_TIMEOUT_AFTER_EXPIRATION, OWNER, TOKEN_ID, APPLICATION_ID, REPLICATED, SECURITY_BINDINGS, SECURITY_TOKEN_ID, SECURITY_BINDINGS_VALUES, LAST_UPDATED_AT, MASTER_NODE, DELETED_AT from  API_KEY_TOKENS " + this.where(criteria), "Cannot select api key tokens.", criteria.getArguments().toArray());
        ArrayList<ApiKeyToken> tokens = new ArrayList<ApiKeyToken>();
        try {
            while (rowSet.next()) {
                ApiKeyToken token = new ApiKeyToken();
                token.setName(rowSet.getString("NAME"));
                token.setDescription(rowSet.getString("DESCRIPTION"));
                token.setCreatedAt(rowSet.getTimestamp("CREATED_AT").getTime());
                token.setLastAccessedAt(rowSet.getTimestamp("LAST_ACCESSED_AT").getTime());
                token.setExtendPeriod(rowSet.getInt("EXTEND_PERIOD"));
                token.setExpiresIn(rowSet.getInt("EXPIRES_IN"));
                token.setDeleteTimeoutAfterExpiration(rowSet.getInt("DELETE_TIMEOUT_AFTER_EXPIRATION"));
                token.setOwner(rowSet.getString("OWNER"));
                token.setTokenId(rowSet.getString("TOKEN_ID"));
                token.setApplicationId(rowSet.getString("APPLICATION_ID"));
                token.setGlobal(rowSet.getBoolean("REPLICATED"));
                token.setSecurityTokenId(rowSet.getString("SECURITY_TOKEN_ID"));
                token.setSecurityBindings(this.deserializeSecurityBindings(rowSet.getString("SECURITY_BINDINGS")));
                token.setSecurityBindingsValues(this.deserializeSecurityBindingsValues(rowSet.getString("SECURITY_BINDINGS_VALUES")));
                token.setLastUpdatedAt(rowSet.getTimestamp("LAST_UPDATED_AT").getTime());
                token.setMasterNode(rowSet.getString("MASTER_NODE"));
                token.setDeletedAt(rowSet.getLong("DELETED_AT"));
                tokens.add(token);
            }
        }
        catch (Exception exception) {
            throw new DaoException("Failed to iterate over api key tokens row set.", exception);
        }
        return tokens;
    }

    @Override
    public List<String> list(Criteria criteria) {
        if (criteria == null) {
            criteria = Criteria.Builder.tr();
        }
        criteria = this.addDeletedAt(criteria);
        RowSet rowSet = this.execute("select TOKEN_ID from API_KEY_TOKENS " + this.where(criteria), "Cannot select api key tokens.", criteria.getArguments().toArray());
        ArrayList<String> tokens = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                tokens.add(rowSet.getString("TOKEN_ID"));
            }
        }
        catch (Exception exception) {
            throw new DaoException("Failed to iterate over api key token row set.", exception);
        }
        return tokens;
    }

    @Override
    public int deleteByTokenId(String tokenId) {
        return this.delete(Criteria.Builder.eq("TOKEN_ID", tokenId));
    }

    @Override
    public int delete(Criteria criteria) {
        if (criteria == null) {
            criteria = Criteria.Builder.tr();
        }
        criteria = this.addDeletedAt(criteria);
        RowSet rowSet = this.execute("update  API_KEY_TOKENS set DELETED_AT = ? " + this.where(criteria), "Cannot delete api ket token.", this.where(System.currentTimeMillis(), criteria));
        try {
            if (rowSet.next()) {
                return rowSet.getInt(1);
            }
        }
        catch (SQLException exception) {
            Trace.logException(this, exception, true);
        }
        return 0;
    }

    @Override
    public int deleteExpired(String masterNodeName, long deletedAt) {
        RowSet rowSet = this.execute("update API_KEY_TOKENS SET DELETED_AT = ? where MASTER_NODE = ? and EXPIRES_IN > 0 and DELETED_AT = 0 and DELETE_TIMEOUT_AFTER_EXPIRATION + EXPIRES_IN <= timestampDiff(SQL_TSI_SECOND, LAST_ACCESSED_AT, currentTimestamp())", "Cannot delete expired tokens.", deletedAt, masterNodeName);
        try {
            if (rowSet.next()) {
                return rowSet.getInt(1);
            }
        }
        catch (SQLException exception) {
            Trace.logException(this, exception, true);
        }
        return 0;
    }

    @Override
    public List<String> removeDeleted(String masterNodeName, int timeout) {
        RowSet rowSet = this.execute("select TOKEN_ID from API_KEY_TOKENS where MASTER_NODE = ? and DELETED_AT > 0 and (long)unixTimestamp(currentTimestamp())-DELETED_AT >= ?", "Cannot select deleted api key token.", masterNodeName, timeout * 1000);
        ArrayList<String> tokenIds = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                tokenIds.add(rowSet.getString(1));
            }
        }
        catch (SQLException exception) {
            Trace.logException(this, exception, true);
        }
        this.removeDeletedTokens(tokenIds);
        return tokenIds;
    }

    @Override
    public void removeDeletedTokens(List<String> tokenIds) {
        StringBuilder builder = new StringBuilder();
        int count = 0;
        for (String tokenId : tokenIds) {
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append("'").append(tokenId).append("'");
            if (++count != 30) continue;
            this.removeTokens(builder);
            count = 0;
            builder.setLength(0);
        }
        if (count > 0) {
            this.removeTokens(builder);
        }
    }

    private void removeTokens(StringBuilder builder) {
        try {
            this.execute("delete from API_KEY_TOKENS where TOKEN_ID in (" + builder.toString() + ")", "Cannot remove api key tokens " + builder.toString(), new Object[0]);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
    }

    protected String serializeSecurityBindingsValues(Map<ApiKeySecurityBinding, String> values) {
        if (values == null || values.size() == 0) {
            return null;
        }
        try {
            return this.getJsonSerializer().serialize(values);
        }
        catch (SerializerException exception) {
            throw new DaoException("Failed to serialize security bindings values.", exception);
        }
    }

    protected Map<ApiKeySecurityBinding, String> deserializeSecurityBindingsValues(String json) {
        if (json == null || json.trim().length() == 0 || json.equals("null")) {
            return new HashMap<ApiKeySecurityBinding, String>();
        }
        try {
            Map map = this.getJsonSerializer().deserialize(Map.class, json);
            if (map != null) {
                for (ApiKeySecurityBinding value : ApiKeySecurityBinding.values()) {
                    Object s = map.getOrDefault(value.toString(), null);
                    if (s == null) continue;
                    map.remove(value.toString());
                    map.put(value, s);
                }
            }
            return map;
        }
        catch (SerializerException exception) {
            throw new DaoException("Failed to deserialize security bindings values.", exception);
        }
    }
}

