/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.runtime.dao;

import com.streamscape.Trace;
import com.streamscape.sef.network.http.server.authentication.runtime.cache.ObjectsCache;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.ApiKeyTokenDao;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.Criteria;
import com.streamscape.sef.network.http.server.authentication.runtime.model.ApiKeyToken;
import java.util.Collections;
import java.util.List;

public class ApiKeyTokenDaoCacheTrigger
implements ApiKeyTokenDao {
    private final ApiKeyTokenDao dao;
    protected final ObjectsCache<ApiKeyToken> objectsCache;

    public ApiKeyTokenDaoCacheTrigger(ApiKeyTokenDao dao, ObjectsCache<ApiKeyToken> objectsCache) {
        this.dao = dao;
        this.objectsCache = objectsCache;
    }

    @Override
    public void insert(ApiKeyToken token) {
        this.dao.insert(token);
    }

    @Override
    public void updateByTokenId(ApiKeyToken token) {
        try {
            this.dao.updateByTokenId(token);
        }
        finally {
            token = this.objectsCache.remove(token.getTokenId());
            if (token != null && token.isLastAccessedAtChanged()) {
                try {
                    this.updateTokenLastAccessedAt(token);
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(ApiKeyToken token, Criteria criteria) {
        try {
            this.dao.update(token, criteria);
        }
        finally {
            if (token.getTokenId() != null) {
                ApiKeyToken token1 = this.objectsCache.remove(token.getTokenId());
                try {
                    if (token1 != null && token1.isLastAccessedAtChanged()) {
                        this.updateTokenLastAccessedAt(token1);
                    }
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, true);
                }
            } else {
                this.objectsCache.clear();
            }
        }
    }

    @Override
    public void updateTokenLastAccessedAt(ApiKeyToken token) {
        try {
            this.dao.updateTokenLastAccessedAt(token);
        }
        finally {
            this.objectsCache.remove(token.getTokenId());
        }
    }

    @Override
    public ApiKeyToken getByTokenId(String tokenId) {
        return this.dao.getByTokenId(tokenId);
    }

    @Override
    public List<ApiKeyToken> select(Criteria criteria) {
        return this.dao.select(criteria);
    }

    @Override
    public List<String> list(Criteria criteria) {
        return this.dao.list(criteria);
    }

    @Override
    public int deleteByTokenId(String tokenId) {
        try {
            int n = this.dao.deleteByTokenId(tokenId);
            return n;
        }
        finally {
            this.objectsCache.remove(tokenId);
        }
    }

    @Override
    public int delete(Criteria criteria) {
        int count = 1;
        try {
            count = this.dao.delete(criteria);
        }
        finally {
            if (count > 0) {
                this.objectsCache.clear();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteExpired(String masterNodeName, long deletedAt) {
        int count = 1;
        try {
            count = this.dao.deleteExpired(masterNodeName, deletedAt);
        }
        finally {
            if (count > 0) {
                this.objectsCache.clear();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> removeDeleted(String masterNodeName, int timeout) {
        List<String> result = null;
        try {
            result = this.dao.removeDeleted(masterNodeName, timeout);
        }
        finally {
            if (result == null || result.size() > 0) {
                this.objectsCache.clear();
            }
        }
        return result == null ? Collections.emptyList() : result;
    }

    @Override
    public void removeDeletedTokens(List<String> tokenIds) {
        try {
            this.dao.removeDeletedTokens(tokenIds);
        }
        finally {
            tokenIds.forEach(id -> this.objectsCache.remove((String)id));
        }
    }
}

