/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.runtime.dao;

import com.streamscape.Trace;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.AbstractDao;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.ApiKeyDefaultsDao;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.Criteria;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.DaoException;
import com.streamscape.sef.network.http.server.authentication.runtime.model.ApiKeyDefault;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApiKeyDefaultsServiceImpl;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ApiKeyDefaultsDaoImpl
extends AbstractDao
implements ApiKeyDefaultsDao {
    @Override
    protected void onInitialize() {
        block2: {
            Trace.logDebug(this, "Initializing ApiKeyDefaultsDao DAO...");
            try {
                this.execute("create persistent table API_KEY_DEFAULTS\n(\nNAME string,\nVALUE string,\nDESCRIPTION string,\nPRIMARY KEY (NAME)\n)", "Cannot create API_KEY_DEFAULTS table.", new Object[0]);
            }
            catch (Exception exception) {
                if (this.isObjectNameAlreadyExistsException(exception)) break block2;
                throw exception;
            }
        }
        this.initDefaults();
        Trace.logDebug(this, "ApiKeyDefaultsDao DAO initialized.");
    }

    private void initDefaults() {
        List<ApiKeyDefault> properties = this.select(null);
        Map<String, ApiKeyDefault> defaults = ApiKeyDefaultsServiceImpl.getDefaults();
        List toDelete = properties.stream().filter(p -> !defaults.containsKey(p.getName())).map(p -> p.getName()).collect(Collectors.toList());
        List toUpdateDescription = properties.stream().filter(p -> defaults.containsKey(p.getName()) && !((ApiKeyDefault)defaults.get(p.getName())).getDescription().equals(p.getDescription())).map(p -> (ApiKeyDefault)defaults.get(p.getName())).collect(Collectors.toList());
        List<ApiKeyDefault> toInsert = defaults.values().stream().filter(d -> properties.stream().filter(p -> p.getName().equals(d.getName())).count() == 0L).collect(Collectors.toList());
        if (toDelete.size() > 0) {
            String toDeleteKeyNames = toDelete.stream().map(k -> "'" + k + "'").collect(Collectors.joining(","));
            this.delete(Criteria.Builder.in("NAME", "(" + toDeleteKeyNames + ")"));
        }
        for (ApiKeyDefault property : toUpdateDescription) {
            try {
                this.execute("update API_KEY_DEFAULTS set DESCRIPTION=? where NAME = ?", "Cannot update api key default description for property " + property.getName(), property.getDescription(), property.getName());
            }
            catch (Exception exception) {
                Trace.logException(this, exception, true);
            }
        }
        toInsert.forEach(this::insert);
    }

    @Override
    public int insert(ApiKeyDefault value) {
        return this.getUpdateCount(this.execute("insert into API_KEY_DEFAULTS (NAME, VALUE, DESCRIPTION) VALUES (?, ?, ?)", "Cannot insert new api key defaults.", value.getName(), String.valueOf(value.getValue()), value.getDescription()));
    }

    @Override
    public int update(ApiKeyDefault value) {
        return this.getUpdateCount(this.execute("update API_KEY_DEFAULTS set VALUE = ?, DESCRIPTION=? where NAME = ?", "Cannot update api key defaults.", String.valueOf(value.getValue()), value.getDescription(), value.getName()));
    }

    @Override
    public List<ApiKeyDefault> select(Criteria criteria) {
        if (criteria == null) {
            criteria = Criteria.Builder.tr();
        }
        ArrayList<ApiKeyDefault> result = new ArrayList<ApiKeyDefault>();
        RowSet rowSet = this.execute("select NAME, VALUE, DESCRIPTION from API_KEY_DEFAULTS " + this.where(criteria), "Cannot select api key defaults.", criteria.getArguments().toArray());
        try {
            while (rowSet.next()) {
                result.add(new ApiKeyDefault(rowSet.getString(1), rowSet.getString(2), rowSet.getString(3)));
            }
        }
        catch (SQLException exception) {
            Trace.logException(this, exception, true);
            throw new DaoException("Cannot select api key defaults.", exception);
        }
        return result;
    }

    @Override
    public int delete(Criteria criteria) {
        if (criteria == null) {
            criteria = Criteria.Builder.tr();
        }
        return this.getUpdateCount(this.execute("delete from API_KEY_DEFAULTS " + this.where(criteria), "Cannot delete api key defaults.", criteria.getArguments().toArray()));
    }
}

