/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.runtime.dao;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.ds.DataspaceException;
import com.streamscape.lib.utils.Utils;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.network.http.server.authentication.runtime.DataspaceAccessorsPool;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.Criteria;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.DaoException;
import com.streamscape.sef.network.http.server.authentication.runtime.model.ApiKeySecurityBinding;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractDao {
    private DataspaceAccessorsPool pool;
    private RuntimeContext context;
    private JSONSerializer serializer;

    public void setDataspaceAccessorsPool(DataspaceAccessorsPool pool) {
        this.pool = pool;
    }

    public void setRuntimeContext(RuntimeContext context) {
        this.context = context;
    }

    public void init() {
        this.serializer = HTTPUtils.getJsonSerializerForJaxrx(this.context);
        this.onInitialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RowSet execute(String query, String error, Object ... parameters) {
        DataspaceAccessor accessor = null;
        try {
            DataspaceAccessor dataspaceAccessor = accessor = this.pool.get();
            synchronized (dataspaceAccessor) {
                try {
                    RowSet rowSet = accessor.executeQuery(query, parameters);
                    return rowSet;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (Throwable exception) {
                        throw new DaoException(error, exception);
                    }
                }
            }
        }
        finally {
            if (accessor != null) {
                this.pool.release(accessor);
            }
        }
    }

    protected JSONSerializer getJsonSerializer() {
        return this.serializer;
    }

    protected String serializeSecurityBindings(Set<ApiKeySecurityBinding> securityBindings) {
        if (securityBindings == null) {
            securityBindings = new HashSet<ApiKeySecurityBinding>();
        }
        try {
            return this.getJsonSerializer().serialize(securityBindings);
        }
        catch (SerializerException exception) {
            throw new DaoException("Failed to serialize security bindings.", exception);
        }
    }

    protected Set<ApiKeySecurityBinding> deserializeSecurityBindings(String json) {
        if (json == null || json.trim().length() == 0 || json.equals("null")) {
            return Collections.emptySet();
        }
        try {
            return new HashSet<ApiKeySecurityBinding>(Arrays.asList(this.getJsonSerializer().deserialize(ApiKeySecurityBinding[].class, json)));
        }
        catch (SerializerException exception) {
            throw new DaoException("Failed to deserialize security bindings.", exception);
        }
    }

    protected abstract void onInitialize();

    protected Criteria addDeletedAt(Criteria criteria) {
        if (criteria.lookupCriteriaForColumn("DELETED_AT") == null) {
            criteria = Criteria.Builder.and(Criteria.Builder.eq("DELETED_AT", 0), criteria);
        }
        return criteria;
    }

    protected String where(Criteria criteria) {
        if (criteria == null) {
            return "";
        }
        return "where " + criteria.getTemplate();
    }

    protected Object[] where(Object ... args) {
        if (args.length > 0 && args[args.length - 1] instanceof Criteria) {
            ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(args));
            Criteria criteria = (Criteria)list.remove(list.size() - 1);
            list.addAll(criteria.getArguments());
            args = list.toArray();
        }
        return args;
    }

    protected int getUpdateCount(RowSet rowSet) {
        try {
            if (rowSet.next()) {
                return rowSet.getInt(1);
            }
        }
        catch (SQLException exception) {
            Trace.logException(this, exception, true);
        }
        return 0;
    }

    protected boolean isObjectNameAlreadyExistsException(Exception exception) {
        DataspaceException dataspaceException = Utils.getCause(exception, DataspaceException.class);
        return dataspaceException != null && ("42504".equals(dataspaceException.getSQLState()) || "42605".equals(dataspaceException.getSQLState()));
    }

    protected boolean isObjectDoesnotExistException(Exception exception) {
        DataspaceException dataspaceException = Utils.getCause(exception, DataspaceException.class);
        return dataspaceException != null && "42501".equals(dataspaceException.getSQLState());
    }

    protected boolean isForeignKeyAlreadyExistsException(Exception exception) {
        DataspaceException dataspaceException = Utils.getCause(exception, DataspaceException.class);
        return dataspaceException != null && "42528".equals(dataspaceException.getSQLState());
    }

    protected boolean isUniqueConstraintOrIndexViolations(Exception exception, String indexName) {
        DataspaceException dataspaceException = Utils.getCause(exception, DataspaceException.class);
        return dataspaceException != null && "23505".equals(dataspaceException.getSQLState()) && dataspaceException.getMessage().contains(indexName);
    }

    protected boolean isForeignKeyNoParentViolations(Exception exception) {
        DataspaceException dataspaceException = Utils.getCause(exception, DataspaceException.class);
        return dataspaceException != null && "23503".equals(dataspaceException.getSQLState());
    }
}

