/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.runtime.cache;

import com.streamscape.Trace;
import com.streamscape.lib.concurrent.worker.MonitorDaemonWorker;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.network.http.server.authentication.runtime.cache.ObjectsCache;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ObjectsCacheCleaner
extends MonitorDaemonWorker {
    List<ObjectsCache<?>> caches = new CopyOnWriteArrayList();

    public ObjectsCacheCleaner(String name, long timeout) throws FabricException {
        super("EXCH:ObjectsCacheCleaner:" + name, "Cleans expired cached objects.", timeout);
        Trace.logDebug(this, "API Key Objects Cache cleaner thread created. Cleanup period {} seconds.", timeout / 1000L);
    }

    @Override
    protected void doExecute() throws FabricException, InterruptedException {
        this.caches.forEach(c -> c.removeExpiredObjects());
    }

    public void addCache(ObjectsCache<?> cache) {
        this.caches.add(cache);
    }
}

