/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.runtime.cache;

import com.streamscape.Trace;
import com.streamscape.sef.network.http.server.authentication.runtime.cache.CachedObject;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ObjectsCache<T> {
    private Map<String, CachedObject<T>> objects = new ConcurrentHashMap<String, CachedObject<T>>();
    private Class<T> objectClass;
    private int maxCacheSize = 10000;
    private float cleanupFactor = 0.75f;
    private long expirationTime = 60000L;

    public ObjectsCache(Class<T> objectClass) {
        this.objectClass = objectClass;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
    }

    public T get(String key) {
        CachedObject<T> object = this.objects.get(key);
        if (object != null) {
            object.setLastAccessTime();
            return object.getObject();
        }
        return null;
    }

    public T remove(String key) {
        CachedObject<T> object = this.objects.remove(key);
        if (object != null) {
            return object.getObject();
        }
        return null;
    }

    public void put(String key, T object) {
        this.ensureSize();
        this.objects.put(key, new CachedObject<T>(object));
    }

    public void removeExpiredObjects() {
        this.removeExpiredObjects(false);
    }

    private synchronized int[] removeExpiredObjects(boolean buildHistogram) {
        return this.removeExpiredObjects(buildHistogram, this.expirationTime);
    }

    private synchronized int[] removeExpiredObjects(boolean buildHistogram, long expirationTime) {
        int[] histogram = null;
        if (buildHistogram) {
            histogram = new int[(int)(expirationTime / 1000L) + 1];
            Arrays.fill(histogram, 0);
        }
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<String, CachedObject<T>>> iterator = this.objects.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, CachedObject<T>> entry = iterator.next();
            long offset = now - entry.getValue().getCachedTime();
            if (offset >= expirationTime) {
                iterator.remove();
                continue;
            }
            if (histogram == null) continue;
            int n = (int)(offset / 1000L);
            histogram[n] = histogram[n] + 1;
        }
        return histogram;
    }

    public synchronized void ensureSize() {
        int[] histogram = null;
        if (this.objects.size() >= this.maxCacheSize) {
            histogram = this.removeExpiredObjects(true);
        }
        int limit = (int)((float)this.maxCacheSize * this.cleanupFactor);
        if (histogram != null && this.objects.size() >= limit) {
            int i;
            int countToClean = this.objects.size() - limit;
            for (i = histogram.length - 1; i >= 0 && (countToClean -= histogram[i]) > 0; --i) {
            }
            Trace.logDebug(this, "WARNING: removing {} not expired objects. Object type {}, cache size {}, max cache size: {}, expiration time: {}ms.", countToClean, this.objectClass, this.objects.size(), this.maxCacheSize, this.expirationTime);
            this.removeExpiredObjects(false, (i + 1) * 1000);
        }
    }

    public void clear() {
        this.objects.clear();
    }
}

