/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.runtime;

import java.math.BigInteger;
import java.security.SecureRandom;

public interface TokenGenerator {
    public String generate(String var1);

    public static String generateUtil(String name, int maxNameLength) {
        SecureRandom random = new SecureRandom();
        String timestamp = BigInteger.valueOf(System.currentTimeMillis()).toString(32);
        String secure = new BigInteger(130, new SecureRandom()).toString(32);
        String padding = "";
        if (name.length() < maxNameLength) {
            int paddingLength = maxNameLength - name.length();
            padding = new BigInteger(paddingLength * 16, new SecureRandom()).toString(16);
        }
        return name + timestamp + padding + secure;
    }

    public static String compressName(String name, int maxLength) {
        if (name == null) {
            return "";
        }
        if ((name = name.trim()).length() == 0) {
            return "";
        }
        boolean afterDelimiter = true;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            boolean isDelimiter;
            char c = name.charAt(i);
            boolean bl = isDelimiter = Character.isWhitespace(c) || ",|\"';()[]{}_-".indexOf(c) != -1;
            if (afterDelimiter && !isDelimiter || Character.isUpperCase(c) || Character.isDigit(c)) {
                builder.append(Character.toLowerCase(c));
            }
            afterDelimiter = isDelimiter;
            if (maxLength > 0 && builder.length() >= maxLength) break;
        }
        return builder.toString();
    }
}

