/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.runtime;

import com.streamscape.sef.network.http.server.authentication.HTTPCredentials;
import com.streamscape.sef.network.http.server.authentication.RuntimeAuthenticator;
import com.streamscape.sef.network.http.server.authentication.runtime.ApiKeyErrorUnauthorizedException;
import com.streamscape.sef.network.http.server.authentication.runtime.ApiKeyManager;
import com.streamscape.sef.network.http.server.authentication.runtime.AuthenticationContext;
import com.streamscape.sef.network.http.server.authentication.runtime.HTTPAuthenticationManager;
import com.streamscape.sef.network.http.server.authentication.runtime.HTTPAuthenticationManagerCoreImpl;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApiKeyServiceFactory;
import com.streamscape.sef.security.User;
import com.streamscape.slex.MFSession;
import javax.servlet.http.HttpServletRequest;

public class HTTPAuthenticationManagerImpl
implements HTTPAuthenticationManager {
    private HTTPAuthenticationManagerCoreImpl coreManager;
    private AuthenticationContext authenticationContext;

    public HTTPAuthenticationManagerImpl(HTTPAuthenticationManagerCoreImpl core) {
        this.coreManager = core;
    }

    @Override
    public HTTPAuthenticationManager authorize(MFSession session) {
        this.authenticationContext = new AuthenticationContext((User)session.getOwner());
        return this;
    }

    @Override
    public HTTPAuthenticationManager authorize(HttpServletRequest request) {
        return this.authorize((HTTPCredentials)request.getAttribute(HTTPCredentials.ATTRIBUTE));
    }

    @Override
    public HTTPAuthenticationManager authorize(HTTPCredentials credentials) {
        if (credentials == null) {
            throw new ApiKeyErrorUnauthorizedException("Authorization failed. HTTP credentials not set.");
        }
        try {
            new RuntimeAuthenticator(this.coreManager.getRuntimeContext()).authenticate(credentials);
        }
        catch (Exception exception) {
            throw new ApiKeyErrorUnauthorizedException("Authorization failed.", exception);
        }
        try {
            User user = this.coreManager.getRuntimeContext().getSecurityManager().lookupUser(credentials.getUserName());
            if (user == null) {
                throw new Exception("User does not exist.");
            }
            this.authenticationContext = new AuthenticationContext(user);
        }
        catch (Exception exception) {
            throw new ApiKeyErrorUnauthorizedException("Cannot obtain user '" + credentials.getUserName() + "' info.", exception);
        }
        return this;
    }

    @Override
    public HTTPAuthenticationManager authorize(User user) {
        this.authenticationContext = new AuthenticationContext(user);
        return this;
    }

    @Override
    public ApiKeyManager getApiKeyManager() {
        return this.coreManager.getApiKeyManager();
    }

    @Override
    public ApiKeyServiceFactory getApiKeyServiceFactory() {
        return this.coreManager.getApiKeyManager().getApiKeyServiceFactory(this.authenticationContext);
    }
}

