/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.runtime;

import com.streamscape.Trace;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.network.http.server.authentication.runtime.ApiKeyManager;
import com.streamscape.sef.network.http.server.authentication.runtime.ApiKeyManagerImpl;
import com.streamscape.sef.network.http.server.authentication.runtime.AuthenticationContext;
import com.streamscape.sef.network.http.server.authentication.runtime.model.ApiKeySecurityBinding;
import com.streamscape.sef.network.http.server.authentication.runtime.model.Application;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApplicationService;
import com.streamscape.sef.security.User;
import java.util.List;
import java.util.Objects;

public final class HTTPAuthenticationManagerCoreImpl {
    private RuntimeContext context;
    private ApiKeyManager apiKeyManager = null;

    public HTTPAuthenticationManagerCoreImpl(RuntimeContext context) {
        this.context = context;
    }

    public void init() {
        Trace.logDebug(this, "Initializing HTTP Authentication Manager...");
        this.apiKeyManager = new ApiKeyManagerImpl(this.context);
        ((ApiKeyManagerImpl)this.apiKeyManager).init();
        this.initDefaultApplications();
        Trace.logDebug(this, "HTTP Authentication Manager initialized.");
    }

    public void destroy() {
        if (this.apiKeyManager != null) {
            ((ApiKeyManagerImpl)this.apiKeyManager).destroy();
            this.apiKeyManager = null;
        }
    }

    public RuntimeContext getRuntimeContext() {
        return this.context;
    }

    ApiKeyManager getApiKeyManager() {
        return this.apiKeyManager;
    }

    private void initDefaultApplications() {
        try {
            User user = this.getRuntimeContext().getSecurityManager().lookupUser(this.getRuntimeContext().getUserName());
            if (user == null) {
                throw new Exception("Principal user '" + this.getRuntimeContext().getUserName() + "' not found.");
            }
            ApplicationService applicationService = this.apiKeyManager.getApiKeyServiceFactory(new AuthenticationContext(user)).getApplicationService();
            Application application = new Application();
            application.setName("Quilt");
            application.setDescription("Application to access Quilt resources.");
            application.setGlobal(true);
            application.setOwner(this.getRuntimeContext().getUserName());
            application.addResource(new Application.Resource("*", "/fabric/*"));
            application.addResource(new Application.Resource("*", "/sorquilt/*"));
            application.addResource(new Application.Resource("*", "/repository/*"));
            application.addResource(new Application.Resource("*", "/ds/*"));
            application.addResource(new Application.Resource("*", "/service/*"));
            application.addResource(new Application.Resource("*", "/swagger/*"));
            application.addResource(new Application.Resource("*", "/dropbox/*"));
            application.addResource(new Application.Resource("*", "/odata/*"));
            application.addResource(new Application.Resource("DELETE|GET", "/security/apikey/token/{tokenId}"));
            application.addResource(new Application.Resource("GET", "/chart/*"));
            application.addSecurityBinding(ApiKeySecurityBinding.USER_AGENT_ON_AUTHENTICATION);
            this.createAdminApplication(applicationService, application);
            application = new Application();
            application.setName("RedSquare");
            application.setDescription("Application to access RedSquare resources.");
            application.setGlobal(true);
            application.setOwner(this.getRuntimeContext().getUserName());
            application.addResource(new Application.Resource("*", "/fabric/*"));
            application.addResource(new Application.Resource("DELETE|GET", "/security/apikey/token/{tokenId}"));
            application.addSecurityBinding(ApiKeySecurityBinding.USER_AGENT_ON_AUTHENTICATION);
            this.createAdminApplication(applicationService, application);
            application = new Application();
            application.setName("SOR");
            application.setDescription("Application to access SOR.");
            application.setGlobal(true);
            application.setOwner(this.getRuntimeContext().getUserName());
            application.addResource(new Application.Resource("*", "/sor/*"));
            application.addResource(new Application.Resource("*", "/repository/*"));
            application.addResource(new Application.Resource("*", "/ds/*"));
            application.addResource(new Application.Resource("*", "/service/*"));
            application.addResource(new Application.Resource("*", "/swagger/*"));
            application.addResource(new Application.Resource("*", "/odata/*"));
            application.addResource(new Application.Resource("DELETE", "/security/apikey/token/{tokenId}"));
            application.addResource(new Application.Resource("POST", "/sor/security/apikey/token/revoke"));
            application.addResource(new Application.Resource("POST", "/security/apikey/token/revoke"));
            application.addSecurityBinding(ApiKeySecurityBinding.USER_AGENT_ON_AUTHENTICATION);
            this.createAdminApplication(applicationService, application);
        }
        catch (Exception exception) {
            Trace.logError(this, "Creating default applications failed.");
            Trace.logException(this, exception, true);
        }
    }

    private void createAdminApplication(ApplicationService applicationService, Application application) {
        List<Application> applications = applicationService.getAll("*", application.getName(), true, true);
        if (applications.size() > 0) {
            if (!(applications.get(0).isGlobal() == application.isGlobal() && Objects.equals(applications.get(0).getDescription(), application.getDescription()) && Objects.equals(applications.get(0).getResources(), application.getResources()) && Objects.equals(applications.get(0).getSecurityBindings(), application.getSecurityBindings()))) {
                application.setApplicationId(applications.get(0).getApplicationId());
                applicationService.update(application);
            }
        } else if (application != null) {
            applicationService.create(application);
        }
    }
}

