/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.runtime;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.lib.concurrent.worker.MonitorDaemonWorker;
import com.streamscape.lib.utils.Utils;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.network.http.server.authentication.runtime.DataspaceAccessorsPool;
import com.streamscape.sef.network.http.server.authentication.runtime.SimpleDataspaceAccessorsPool;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.DaoException;
import com.streamscape.sef.pool.ObjectsPool;
import com.streamscape.sef.pool.ObjectsPoolImpl;
import com.streamscape.sef.pool.PoolObjectsCreator;
import java.util.concurrent.TimeUnit;

public class DataspaceAccessorsPoolImpl
implements DataspaceAccessorsPool {
    private String name;
    private int maxPoolSize;
    private int expirationTimeout;
    private ObjectsPool<DataspaceAccessor> objectsPool;
    private DataspaceAccessorsPool simpleDataspaceAccessorsPool;
    private MonitorDaemonWorker expirationCleaner;

    public DataspaceAccessorsPoolImpl(String name, int maxPoolSize, int expirationTimeout) {
        this.name = name;
        this.maxPoolSize = maxPoolSize;
        this.expirationTimeout = expirationTimeout;
        this.simpleDataspaceAccessorsPool = new SimpleDataspaceAccessorsPool();
    }

    @Override
    public void start() {
        PoolObjectsCreator<DataspaceAccessor> poolObjectsCreator = new PoolObjectsCreator<DataspaceAccessor>(){

            @Override
            public String getName() {
                return this.getOwnerComponentName() + "-" + this.getObjectType() + "-" + this.getComponentFullName();
            }

            @Override
            public String getOwnerComponentName() {
                return DataspaceAccessorsPoolImpl.this.name;
            }

            @Override
            public String getObjectType() {
                return "accessor";
            }

            @Override
            public String getComponentFullName() {
                return DataspaceAccessorsPoolImpl.this.name;
            }

            @Override
            public DataspaceAccessor createNewObject() throws Exception {
                return DataspaceAccessorsPoolImpl.this.simpleDataspaceAccessorsPool.get();
            }

            @Override
            public void closeObject(DataspaceAccessor accessor) {
                DataspaceAccessorsPoolImpl.this.simpleDataspaceAccessorsPool.release(accessor);
            }
        };
        this.objectsPool = new ObjectsPoolImpl<DataspaceAccessor>(this.maxPoolSize, poolObjectsCreator);
        this.objectsPool.start();
        if (this.expirationTimeout > 0) {
            try {
                this.expirationCleaner = new MonitorDaemonWorker("EXCH:DataspaceAccessorsPool." + this.name + ".Expired.Cleaner", "Cleans expired accessors.", 60000L){

                    @Override
                    protected void doExecute() throws FabricException, InterruptedException {
                        if (DataspaceAccessorsPoolImpl.this.objectsPool.getCurrentPoolSize() > 0) {
                            Trace.logDebug(this, "{}: removing expired. Pool size: {}, available size: {}.", DataspaceAccessorsPoolImpl.this.name, DataspaceAccessorsPoolImpl.this.objectsPool.getCurrentPoolSize(), DataspaceAccessorsPoolImpl.this.objectsPool.getAvailableObjectsCount());
                        }
                        DataspaceAccessorsPoolImpl.this.objectsPool.removeExpired(DataspaceAccessorsPoolImpl.this.expirationTimeout * 1000);
                    }
                };
            }
            catch (FabricException exception) {
                throw new DaoException("Failed to create expired cleaner.");
            }
            this.expirationCleaner.start();
        }
    }

    @Override
    public void stop() {
        if (this.expirationCleaner != null) {
            this.expirationCleaner.stop();
        }
        if (this.objectsPool != null) {
            this.objectsPool.stop();
        }
    }

    @Override
    public DataspaceAccessor get() throws InterruptedException {
        try {
            DataspaceAccessor accessor = this.objectsPool.get(60L, TimeUnit.SECONDS);
            try {
                if (!accessor.isClosed()) {
                    return accessor;
                }
                Trace.logInfo(this, "WARNING: Accessor {} in accessors pool is closed. Close it and create the new one.", accessor.getName());
                this.objectsPool.releaseAndRemove(accessor);
            }
            catch (Throwable exception) {
                Trace.logInfo(this, "WARNING: Accessor {} in accessors pool is not working. Close it and create the new one. " + Utils.formatExceptionWithUnrepeatedCauses(exception), accessor.getName());
                if (Trace.isDebugEnabled(this.getClass())) {
                    Trace.logException(this, exception, true);
                }
                this.objectsPool.releaseAndRemove(accessor);
            }
            return this.objectsPool.get(60L, TimeUnit.SECONDS);
        }
        catch (Throwable exception) {
            throw new DaoException("Failed to get accessor from pool.", exception);
        }
    }

    @Override
    public void release(DataspaceAccessor accessor) {
        this.objectsPool.release(accessor);
    }
}

