/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.runtime;

import com.streamscape.Trace;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.Utils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AbstractApiKeyManager;
import com.streamscape.sef.network.http.server.authentication.runtime.ApiKeyErrorException;
import com.streamscape.sef.network.http.server.authentication.runtime.ApiKeyErrorUnauthorizedException;
import com.streamscape.sef.network.http.server.authentication.runtime.ApiKeyManager;
import com.streamscape.sef.network.http.server.authentication.runtime.AuthenticationContext;
import com.streamscape.sef.network.http.server.authentication.runtime.DataspaceAccessorsPool;
import com.streamscape.sef.network.http.server.authentication.runtime.DataspaceAccessorsPoolImpl;
import com.streamscape.sef.network.http.server.authentication.runtime.TokenGenerator;
import com.streamscape.sef.network.http.server.authentication.runtime.cache.ObjectsCache;
import com.streamscape.sef.network.http.server.authentication.runtime.cache.ObjectsCacheCleaner;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.AbstractDao;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.ApiKeyDaoFactory;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.ApiKeyDefaultsDao;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.ApiKeyTokenDao;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.ApiKeyTokenDaoCache;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.ApiKeyTokenDaoCacheTrigger;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.ApiKeyTokenDaoReplicated;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.ApiKeyTokenDaoReplicationRequestHandler;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.ApplicationDao;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.ApplicationDaoCache;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.ApplicationDaoCacheTrigger;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.ApplicationDaoReplicated;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.ApplicationDaoReplicationRequestHandler;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.Criteria;
import com.streamscape.sef.network.http.server.authentication.runtime.dao.DaoFactory;
import com.streamscape.sef.network.http.server.authentication.runtime.model.ApiKeyToken;
import com.streamscape.sef.network.http.server.authentication.runtime.model.Application;
import com.streamscape.sef.network.http.server.authentication.runtime.service.AbstractService;
import com.streamscape.sef.network.http.server.authentication.runtime.service.AbstractServiceFactory;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApiKeyDefaultsService;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApiKeyDefaultsServiceImpl;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApiKeyServiceFactory;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApiKeyTokenAuthenticatorService;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApiKeyTokenAuthenticatorServiceImpl;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApiKeyTokenCleaner;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApiKeyTokenGenerator;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApiKeyTokenService;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApiKeyTokenServiceImpl;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApplicationIdGenerator;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApplicationService;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApplicationServiceImpl;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ApiKeyManagerImpl
extends AbstractApiKeyManager
implements ApiKeyManager {
    private RuntimeContext context;
    private DataspaceAccessorsPool accessorsPool;
    private TokenGenerator applicationIdGenerator;
    private TokenGenerator apiKeyTokenGenerator;
    private ApiKeyDefaultsDao apiKeyDefaultsDao;
    private DaoFactory<AbstractDao> daoStore;
    private ApplicationDao applicationDaoReplicated;
    private ApplicationDaoReplicationRequestHandler applicationDaoReplicationRequestHandler;
    private ApiKeyTokenDao apiKeyTokenDaoReplicated;
    private ApiKeyTokenDaoReplicationRequestHandler apiKeyTokenDaoReplicationRequestHandler;
    private ApplicationDao applicationDaoCache;
    private ApiKeyTokenDao apiKeyTokenDaoCache;
    private ObjectsCache<Application> applicationObjectsCache;
    private ObjectsCache<ApiKeyToken> apiKeyTokenObjectsCache;
    private ApiKeyTokenCleaner apiKeyTokenCleaner;
    private ObjectsCacheCleaner cacheCleaner;
    private List<ApiKeyDefaultsService.ApiKeyDefaultsUpdateListener> apiKeyDefaultsUpdateListeners = new ArrayList<ApiKeyDefaultsService.ApiKeyDefaultsUpdateListener>();

    public ApiKeyManagerImpl(RuntimeContext context) {
        this.context = context;
    }

    public void init() {
        Trace.logDebug(this, "Initializing API Key Manager...");
        this.initDataspaceAccessorsPool();
        ApiKeyDaoFactory daoFactory = new ApiKeyDaoFactory();
        daoFactory.setPool(this.accessorsPool);
        daoFactory.setRuntimeContext(this.context);
        final ApiKeyDefaultsService defaultsServiceInternal = this.getApiKeyDefaultsServiceInternal(this.accessorsPool);
        this.applicationObjectsCache = new ObjectsCache<Application>(Application.class);
        this.applicationObjectsCache.setExpirationTime(defaultsServiceInternal.getPropertyIntValue("api.key.applications.cache.expiration.in.sec") * 1000);
        this.applicationObjectsCache.setMaxCacheSize(defaultsServiceInternal.getPropertyIntValue("api.key.applications.cache.max.objects"));
        ApplicationDaoCacheTrigger applicationDaoCacheTrigger = new ApplicationDaoCacheTrigger(daoFactory.create(ApplicationDao.class), this.applicationObjectsCache);
        this.applicationDaoReplicated = new ApplicationDaoReplicated(applicationDaoCacheTrigger, this.context);
        this.applicationDaoReplicationRequestHandler = new ApplicationDaoReplicationRequestHandler(applicationDaoCacheTrigger);
        this.applicationDaoCache = new ApplicationDaoCache(this.applicationDaoReplicated, this.applicationObjectsCache);
        this.applicationIdGenerator = new ApplicationIdGenerator();
        this.apiKeyTokenObjectsCache = new ObjectsCache<ApiKeyToken>(ApiKeyToken.class);
        this.apiKeyTokenObjectsCache.setExpirationTime(defaultsServiceInternal.getPropertyIntValue("api.key.tokens.cache.expiration.in.sec") * 1000);
        this.apiKeyTokenObjectsCache.setMaxCacheSize(defaultsServiceInternal.getPropertyIntValue("api.key.tokens.cache.max.objects"));
        ApiKeyTokenDaoCacheTrigger apiKeyTokenCacheTrigger = new ApiKeyTokenDaoCacheTrigger(daoFactory.create(ApiKeyTokenDao.class), this.apiKeyTokenObjectsCache);
        this.apiKeyTokenDaoReplicated = new ApiKeyTokenDaoReplicated(apiKeyTokenCacheTrigger, this.context);
        this.apiKeyTokenDaoReplicationRequestHandler = new ApiKeyTokenDaoReplicationRequestHandler(apiKeyTokenCacheTrigger);
        this.apiKeyTokenDaoCache = new ApiKeyTokenDaoCache(this.apiKeyTokenDaoReplicated, this.apiKeyTokenObjectsCache);
        Trace.logDebug(this, "Cache for API Key Tokens created. Max size: {}, expiration time: {}ms.", this.apiKeyTokenObjectsCache.getMaxCacheSize(), this.apiKeyTokenObjectsCache.getExpirationTime());
        try {
            this.apiKeyTokenCleaner = new ApiKeyTokenCleaner(this.apiKeyTokenDaoReplicated, this.applicationDaoReplicated, defaultsServiceInternal.getPropertyIntValue("api.key.cleaner.run.period.in.sec"), defaultsServiceInternal.getPropertyIntValue("api.key.remove.timeout.after.deletion.in.sec"), this.context);
            this.apiKeyTokenCleaner.start();
        }
        catch (FabricException exception) {
            throw new ApiKeyErrorException("Failed to start API Key cleaner thread.", exception);
        }
        this.apiKeyTokenGenerator = new ApiKeyTokenGenerator();
        this.apiKeyDefaultsDao = daoFactory.create(ApiKeyDefaultsDao.class);
        this.daoStore = new DaoFactory<AbstractDao>(){

            @Override
            public AbstractDao create() {
                return null;
            }

            @Override
            public <T> T create(Class<T> clazz) {
                if (clazz == ApplicationDao.class) {
                    return (T)ApiKeyManagerImpl.this.applicationDaoReplicated;
                }
                if (clazz == ApiKeyTokenDao.class) {
                    return (T)ApiKeyManagerImpl.this.apiKeyTokenDaoReplicated;
                }
                if (clazz == ApiKeyDefaultsDao.class) {
                    return (T)ApiKeyManagerImpl.this.apiKeyDefaultsDao;
                }
                throw new ApiKeyErrorException("Unknown dao class '" + String.valueOf(clazz) + "'.");
            }
        };
        try {
            this.cacheCleaner = new ObjectsCacheCleaner("ApiKeyApplicationsAndTokens", defaultsServiceInternal.getPropertyIntValue("api.key.cache.expiration.check.period.in.sec") * 1000);
            this.cacheCleaner.addCache(this.applicationObjectsCache);
            this.cacheCleaner.addCache(this.apiKeyTokenObjectsCache);
            this.cacheCleaner.start();
        }
        catch (Exception exception) {
            throw new ApiKeyErrorException("Failed to start cache cleaner.", exception);
        }
        this.apiKeyDefaultsUpdateListeners.add(new ApiKeyDefaultsService.ApiKeyDefaultsUpdateListener(){

            @Override
            public void onPropertyChanged(String name) {
                if (name.equals("api.key.cleaner.run.period.in.sec")) {
                    int value = defaultsServiceInternal.getPropertyIntValue("api.key.cleaner.run.period.in.sec");
                    Trace.logInfo(this, "Updating property {} in api key cleaner thread to {} secs.", name, value);
                    try {
                        ApiKeyManagerImpl.this.apiKeyTokenCleaner.setTimeout(value * 1000);
                    }
                    catch (FabricException exception) {
                        ApiKeyManagerImpl.this.logException(exception);
                    }
                } else if (name.equals("api.key.remove.timeout.after.deletion.in.sec")) {
                    int value = defaultsServiceInternal.getPropertyIntValue("api.key.remove.timeout.after.deletion.in.sec");
                    Trace.logInfo(this, "Updating property {} in api key cleaner thread to {} secs.", name, value);
                    ApiKeyManagerImpl.this.apiKeyTokenCleaner.setRemoveTimeout(value);
                } else if (name.equals("api.key.applications.cache.expiration.in.sec")) {
                    int value = defaultsServiceInternal.getPropertyIntValue("api.key.applications.cache.expiration.in.sec");
                    Trace.logInfo(this, "Updating property {} in api applications cache to {} secs.", name, value);
                    ApiKeyManagerImpl.this.applicationObjectsCache.setExpirationTime(value);
                } else if (name.equals("api.key.applications.cache.max.objects")) {
                    int value = defaultsServiceInternal.getPropertyIntValue("api.key.applications.cache.max.objects");
                    Trace.logInfo(this, "Updating property {} in api applications cache to {}.", name, value);
                    ApiKeyManagerImpl.this.applicationObjectsCache.setMaxCacheSize(value);
                } else if (name.equals("api.key.tokens.cache.expiration.in.sec")) {
                    int value = defaultsServiceInternal.getPropertyIntValue("api.key.tokens.cache.expiration.in.sec");
                    Trace.logInfo(this, "Updating property {} in api tokens cache to {} secs.", name, value);
                    ApiKeyManagerImpl.this.apiKeyTokenObjectsCache.setExpirationTime(value);
                } else if (name.equals("api.key.tokens.cache.max.objects")) {
                    int value = defaultsServiceInternal.getPropertyIntValue("api.key.tokens.cache.max.objects");
                    Trace.logInfo(this, "Updating property {} in api tokens cache to {}.", name, value);
                    ApiKeyManagerImpl.this.apiKeyTokenObjectsCache.setMaxCacheSize(value);
                } else if (name.equals("api.key.cache.expiration.check.period.in.sec")) {
                    int value = defaultsServiceInternal.getPropertyIntValue("api.key.cache.expiration.check.period.in.sec");
                    Trace.logInfo(this, "Updating property {} in objects cache cleaner that to {} secs.", name, value);
                    try {
                        ApiKeyManagerImpl.this.cacheCleaner.setTimeout(value * 1000);
                    }
                    catch (FabricException exception) {
                        ApiKeyManagerImpl.this.logException(exception);
                    }
                } else if (name.equals("api.key.dataspace.accessors.pool.max.size") || name.equals("api.key.dataspace.accessors.pool.expiration.in.sec")) {
                    Trace.logInfo(this, "WARNING: to apply {} value changes node restart required!.", name);
                }
            }
        });
        Trace.logDebug(this, "API Key Manager initialized.");
    }

    public void destroy() {
        if (this.cacheCleaner != null) {
            this.cacheCleaner.stop();
        }
        if (this.apiKeyTokenCleaner != null) {
            this.apiKeyTokenCleaner.stop();
        }
        if (this.accessorsPool != null) {
            this.accessorsPool.stop();
        }
    }

    @Override
    public ApiKeyTokenAuthenticatorService getApiKeyTokenAuthenticatorService() {
        return new ApiKeyTokenAuthenticatorServiceImpl(this.applicationDaoCache, this.apiKeyTokenDaoCache);
    }

    @Override
    public ApiKeyServiceFactory getApiKeyServiceFactory(final AuthenticationContext authenticationContext) {
        final AbstractServiceFactory factory = new AbstractServiceFactory(){

            @Override
            protected AbstractService<?> doCreateServiceInstance(Type clazz) {
                if (ApplicationService.class == clazz) {
                    return new ApplicationServiceImpl();
                }
                if (ApiKeyTokenService.class == clazz) {
                    return new ApiKeyTokenServiceImpl();
                }
                if (ApiKeyDefaultsService.class == clazz) {
                    return new ApiKeyDefaultsServiceImpl();
                }
                throw new ApiKeyErrorException("Unknown service class '" + String.valueOf(clazz) + "'.");
            }

            @Override
            protected void doInitServiceInstance(Type clazz, AbstractService<?> service) {
                super.doInitServiceInstance(clazz, service);
                if (ApplicationService.class == clazz) {
                    ((ApplicationServiceImpl)service).setApplicationIdGenerator(ApiKeyManagerImpl.this.applicationIdGenerator);
                    ((ApplicationServiceImpl)service).setRuntimeContext(ApiKeyManagerImpl.this.context);
                }
                if (ApiKeyTokenService.class == clazz) {
                    ((ApiKeyTokenServiceImpl)service).setApiKeyTokenGenerator(ApiKeyManagerImpl.this.apiKeyTokenGenerator);
                    ((ApiKeyTokenServiceImpl)service).setApiKeyDefaultsService(this.create(ApiKeyDefaultsService.class));
                    ((ApiKeyTokenServiceImpl)service).setRuntimeContext(ApiKeyManagerImpl.this.context);
                }
                if (ApiKeyDefaultsService.class == clazz) {
                    ((ApiKeyDefaultsServiceImpl)service).setApiKeyDefaultsUpdateListeners(ApiKeyManagerImpl.this.apiKeyDefaultsUpdateListeners);
                }
            }
        };
        factory.setAuthenticationContext(authenticationContext);
        factory.setDaoFactory(this.daoStore);
        return new ApiKeyServiceFactory(){

            @Override
            public ApplicationService getApplicationService() {
                if (authenticationContext == null) {
                    throw new ApiKeyErrorUnauthorizedException("Not authorized to access Application services.");
                }
                return factory.create(ApplicationService.class);
            }

            @Override
            public ApiKeyTokenService getApiKeyTokenService() {
                if (authenticationContext == null) {
                    throw new ApiKeyErrorUnauthorizedException("Not authorized to access API Key token services.");
                }
                return factory.create(ApiKeyTokenService.class);
            }

            @Override
            public ApiKeyDefaultsService getApiKeyDefaultsService() {
                return factory.create(ApiKeyDefaultsService.class);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDataspaceAccessorsPool() {
        DataspaceAccessorsPool tmpAccessorsPool = null;
        try {
            tmpAccessorsPool = new DataspaceAccessorsPoolImpl("ApiKeyManager", 1, -1);
            tmpAccessorsPool.start();
            ApiKeyDefaultsService service = this.getApiKeyDefaultsServiceInternal(tmpAccessorsPool);
            Integer maxPoolSize = service.getPropertyIntValue("api.key.dataspace.accessors.pool.max.size");
            Integer expirationTimeout = service.getPropertyIntValue("api.key.dataspace.accessors.pool.expiration.in.sec");
            this.accessorsPool = new DataspaceAccessorsPoolImpl("ApiKeyManager", maxPoolSize, expirationTimeout);
            this.accessorsPool.start();
        }
        finally {
            if (tmpAccessorsPool != null) {
                tmpAccessorsPool.stop();
            }
        }
    }

    private ApiKeyDefaultsService getApiKeyDefaultsServiceInternal(DataspaceAccessorsPool pool) {
        ApiKeyDaoFactory daoFactory = new ApiKeyDaoFactory();
        daoFactory.setPool(pool);
        daoFactory.setRuntimeContext(this.context);
        AbstractServiceFactory serviceFactory = new AbstractServiceFactory(this){

            @Override
            protected AbstractService<?> doCreateServiceInstance(Type clazz) {
                return new ApiKeyDefaultsServiceImpl();
            }
        };
        serviceFactory.setDaoFactory(daoFactory);
        return serviceFactory.create(ApiKeyDefaultsService.class);
    }

    @Override
    protected boolean invokeApiKeyReplicationRequest(AbstractApiKeyManager.ApiKeyReplicationRequestData data) {
        Trace.logDebug(this, "Replication request on '{}' received, method name '{}'.", new Object[]{data.target, data.methodName});
        try {
            switch (data.target) {
                case API_KEY_APPLICATION: {
                    this.invokeReplicationMethod(this.applicationDaoReplicationRequestHandler, ApplicationDao.class, data.methodName, data.parameters);
                    break;
                }
                case API_KEY_TOKEN: {
                    this.invokeReplicationMethod(this.apiKeyTokenDaoReplicationRequestHandler, ApiKeyTokenDao.class, data.methodName, data.parameters);
                }
            }
        }
        catch (Exception exception) {
            this.logException(exception);
        }
        return true;
    }

    private void invokeReplicationMethod(Object object, Class<?> objectClass, String methodName, Object[] parameters) {
        List<Class> parameterClasses = Arrays.asList(Optional.ofNullable(parameters).orElse(new Object[0])).stream().map(p -> p != null ? p.getClass() : Object.class).collect(Collectors.toList());
        Method method = ClassUtils.findBestDeclaredOrInheritedMethod(objectClass, methodName, parameterClasses.toArray(new Class[0]), true);
        if (method != null) {
            try {
                method.invoke(object, parameters);
            }
            catch (Exception exception) {
                Trace.logError(this, "Invocation of method '{}' failed.", methodName);
                this.logException(exception);
            }
        } else {
            Trace.logError(this, "Method '{}' with arguments '{}' not found in object of class '{}'.", methodName, parameterClasses, objectClass);
        }
    }

    @Override
    protected AbstractApiKeyManager.ApiKeyReplicatedData getApiKeyReplicatedData() {
        AbstractApiKeyManager.ApiKeyReplicatedData result = new AbstractApiKeyManager.ApiKeyReplicatedData();
        try {
            result.applications = this.applicationDaoReplicated.select(Criteria.Builder.and(Criteria.Builder.and(Criteria.Builder.ge("DELETED_AT", 0), Criteria.Builder.eq("REPLICATED", true)), ApplicationServiceImpl.notSystemApplicationCriteria()), true);
        }
        catch (Exception exception) {
            Trace.logError(this, "Failed get replicated data for Api Key Applications.");
            this.logException(exception);
        }
        try {
            result.tokens = this.apiKeyTokenDaoReplicated.select(Criteria.Builder.and(Criteria.Builder.ge("DELETED_AT", 0), Criteria.Builder.eq("REPLICATED", true)));
        }
        catch (Exception exception) {
            Trace.logError(this, "Failed get replicated data for Api Key Applications.");
            this.logException(exception);
        }
        return result;
    }

    @Override
    protected void synchronize(AbstractApiKeyManager.ApiKeyReplicatedData apiKeyReplicatedData) {
        Trace.logInfo(this, "Synchronizing Api Key Data...");
        try {
            if (apiKeyReplicatedData != null) {
                this.synchronizeApplications(apiKeyReplicatedData);
                this.synchronizeTokens(apiKeyReplicatedData);
            } else {
                Trace.logError(this, "WARNING: apiKeyReplicatedData in synchronization request is null.");
            }
        }
        catch (Exception exception) {
            this.logException(exception);
        }
        Trace.logInfo(this, "Api Key Data synchronized.");
    }

    private void synchronizeApplications(AbstractApiKeyManager.ApiKeyReplicatedData apiKeyReplicatedData) {
        Trace.logInfo(this, "Synchronizing Api Key Applications...");
        Map<String, Application> localApplications = this.applicationDaoReplicationRequestHandler.select(Criteria.Builder.and(Criteria.Builder.and(Criteria.Builder.ge("DELETED_AT", 0), Criteria.Builder.eq("REPLICATED", true)), ApplicationServiceImpl.notSystemApplicationCriteria()), true).stream().collect(Collectors.toMap(Application::getApplicationId, application -> application));
        ArrayList<Application> localApplicationToPropagate = new ArrayList<Application>();
        for (Application application2 : apiKeyReplicatedData.applications) {
            Application localApplication = localApplications.remove(application2.getApplicationId());
            if (localApplication == null && this.context.getName().equals(application2.getMasterNode())) {
                if (apiKeyReplicatedData.applicationsToRemove == null) {
                    apiKeyReplicatedData.applicationsToRemove = new ArrayList<String>();
                }
                apiKeyReplicatedData.applicationsToRemove.add(application2.getApplicationId());
                continue;
            }
            if (application2.getDeletedAt() > 0L) {
                if (localApplication == null || localApplication.getDeletedAt() != 0L) continue;
                try {
                    Trace.logDebug(this, "Synchronization: Deleting application '{}', name '{}'.", application2.getApplicationId(), application2.getName());
                    this.applicationDaoReplicationRequestHandler.deleteByApplicationId(application2.getApplicationId());
                }
                catch (Exception exception) {
                    this.logSynchronizeApplicationException(exception, "delete", application2);
                }
                continue;
            }
            if (localApplication == null) {
                try {
                    Trace.logDebug(this, "Synchronization: Inserting application '{}', name '{}'.", application2.getApplicationId(), application2.getName());
                    this.applicationDaoReplicationRequestHandler.insert(application2);
                }
                catch (Exception exception) {
                    this.logSynchronizeApplicationException(exception, "insert", application2);
                }
                continue;
            }
            if (localApplication.getDeletedAt() == 0L && application2.getLastUpdatedAt() > localApplication.getLastUpdatedAt()) {
                try {
                    Trace.logDebug(this, "Synchronization: updating application '{}', name '{}'.", application2.getApplicationId(), application2.getName());
                    this.applicationDaoReplicationRequestHandler.updateByApplicationId(application2);
                }
                catch (Exception exception) {
                    this.logSynchronizeApplicationException(exception, "delete", application2);
                }
                continue;
            }
            if (localApplication.getDeletedAt() <= 0L && application2.getLastUpdatedAt() == localApplication.getLastUpdatedAt()) continue;
            localApplicationToPropagate.add(localApplication);
        }
        for (Application localApplication : localApplications.values()) {
            if (this.context.getName().equals(localApplication.getMasterNode())) {
                localApplicationToPropagate.add(localApplication);
                continue;
            }
            if (localApplication.getDeletedAt() == 0L) {
                try {
                    Trace.logDebug(this, "Synchronization: Deleting application '{}', name '{}'.", localApplication.getApplicationId(), localApplication.getName());
                    this.applicationDaoReplicationRequestHandler.deleteByApplicationId(localApplication.getApplicationId());
                }
                catch (Exception exception) {
                    this.logSynchronizeApplicationException(exception, "delete", localApplication);
                }
            }
            try {
                Trace.logDebug(this, "Synchronization: removing application '{}', name '{}'.", localApplication.getApplicationId(), localApplication.getName());
                this.applicationDaoReplicationRequestHandler.removeDeletedApplications(Collections.singletonList(localApplication.getApplicationId()));
            }
            catch (Exception exception) {
                this.logSynchronizeApplicationException(exception, "remove", localApplication);
            }
        }
        apiKeyReplicatedData.localApplications = localApplicationToPropagate;
        Trace.logInfo(this, "Api Key Applications synchronized.");
    }

    private void synchronizeTokens(AbstractApiKeyManager.ApiKeyReplicatedData apiKeyReplicatedData) {
        Trace.logInfo(this, "Synchronizing Api Key Tokens...");
        Map<String, ApiKeyToken> localTokens = this.apiKeyTokenDaoReplicationRequestHandler.select(Criteria.Builder.and(Criteria.Builder.ge("DELETED_AT", 0), Criteria.Builder.eq("REPLICATED", true))).stream().collect(Collectors.toMap(ApiKeyToken::getTokenId, token -> token));
        ArrayList<ApiKeyToken> localTokensToPropagate = new ArrayList<ApiKeyToken>();
        for (ApiKeyToken token2 : apiKeyReplicatedData.tokens) {
            ApiKeyToken localToken = localTokens.remove(token2.getTokenId());
            if (localToken == null && this.context.getName().equals(token2.getMasterNode())) {
                if (apiKeyReplicatedData.tokensToRemove == null) {
                    apiKeyReplicatedData.tokensToRemove = new ArrayList<String>();
                }
                apiKeyReplicatedData.tokensToRemove.add(token2.getTokenId());
                continue;
            }
            if (token2.getDeletedAt() > 0L) {
                if (localToken == null || localToken.getDeletedAt() != 0L) continue;
                try {
                    Trace.logDebug(this, "Synchronization: Deleting token '{}', name '{}'.", token2.getTokenId(), token2.getName());
                    this.apiKeyTokenDaoReplicationRequestHandler.deleteByTokenId(token2.getTokenId());
                }
                catch (Exception exception) {
                    this.logSynchronizeTokenException(exception, "delete", token2);
                }
                continue;
            }
            if (localToken == null) {
                try {
                    Trace.logDebug(this, "Synchronization: Inserting token '{}', name '{}'.", token2.getTokenId(), token2.getName());
                    this.apiKeyTokenDaoReplicationRequestHandler.insert(token2);
                }
                catch (Exception exception) {
                    this.logSynchronizeTokenException(exception, "insert", token2);
                }
                continue;
            }
            if (localToken.getDeletedAt() == 0L && token2.getLastUpdatedAt() > localToken.getLastUpdatedAt()) {
                try {
                    Trace.logDebug(this, "Synchronization: updating application '{}', name '{}'.", token2.getTokenId(), token2.getName());
                    this.apiKeyTokenDaoReplicationRequestHandler.updateByTokenId(token2);
                }
                catch (Exception exception) {
                    this.logSynchronizeTokenException(exception, "delete", token2);
                }
                continue;
            }
            if (localToken.getDeletedAt() <= 0L && token2.getLastUpdatedAt() == localToken.getLastUpdatedAt()) continue;
            localTokensToPropagate.add(localToken);
        }
        for (ApiKeyToken localToken : localTokens.values()) {
            if (this.context.getName().equals(localToken.getMasterNode())) {
                localTokensToPropagate.add(localToken);
                continue;
            }
            if (localToken.getDeletedAt() == 0L) {
                try {
                    Trace.logDebug(this, "Synchronization: Deleting api key token '{}', name '{}'.", localToken.getTokenId(), localToken.getName());
                    this.apiKeyTokenDaoReplicationRequestHandler.deleteByTokenId(localToken.getTokenId());
                }
                catch (Exception exception) {
                    this.logSynchronizeTokenException(exception, "delete", localToken);
                }
            }
            try {
                Trace.logDebug(this, "Synchronization: removing api key token '{}', name '{}'.", localToken.getTokenId(), localToken.getName());
                this.apiKeyTokenDaoReplicationRequestHandler.removeDeletedTokens(Collections.singletonList(localToken.getTokenId()));
            }
            catch (Exception exception) {
                this.logSynchronizeTokenException(exception, "remove", localToken);
            }
        }
        apiKeyReplicatedData.localTokens = localTokensToPropagate;
        Trace.logInfo(this, "Api Key Tokens synchronized.");
    }

    @Override
    protected void propagateDataToSysplex(AbstractApiKeyManager.ApiKeyReplicatedData apiKeyReplicatedData) {
        Trace.logInfo(this, "Propagating local Api Key Data to sysplex...");
        try {
            if (apiKeyReplicatedData != null) {
                this.propagateApplicationsDataToSysplex(apiKeyReplicatedData);
                this.propagateTokensDataToSysplex(apiKeyReplicatedData);
            } else {
                Trace.logError(this, "WARNING: apiKeyReplicatedData in propagate request is null.");
            }
        }
        catch (Exception exception) {
            this.logException(exception);
        }
        Trace.logInfo(this, "Local Api Key Data propagated to sysplex.");
    }

    private void propagateApplicationsDataToSysplex(AbstractApiKeyManager.ApiKeyReplicatedData apiKeyReplicatedData) {
        if (apiKeyReplicatedData.localApplications != null) {
            for (Application localApplication : apiKeyReplicatedData.localApplications) {
                if (localApplication.getDeletedAt() > 0L) {
                    Trace.logDebug(this, "Synchronization: Invoke replication request to delete application '{}', name '{}'.", localApplication.getApplicationId(), localApplication.getName());
                    ((ApplicationDaoReplicated)this.applicationDaoReplicated).invokeReplication("deleteByApplicationId", localApplication.getApplicationId());
                    continue;
                }
                if (apiKeyReplicatedData.applications.stream().filter(a -> a.getApplicationId().equals(localApplication.getApplicationId())).findFirst().isPresent()) {
                    Trace.logDebug(this, "Synchronization: Invoke replication request to update application '{}', name '{}'.", localApplication.getApplicationId(), localApplication.getName());
                    ((ApplicationDaoReplicated)this.applicationDaoReplicated).invokeReplication("updateByApplicationId", localApplication);
                    continue;
                }
                Trace.logDebug(this, "Synchronization: Invoke replication request to insert application id '{}', name '{}'.", localApplication.getApplicationId(), localApplication.getName());
                ((ApplicationDaoReplicated)this.applicationDaoReplicated).invokeReplication("insert", localApplication);
            }
        }
        if (apiKeyReplicatedData.applicationsToRemove != null && apiKeyReplicatedData.applicationsToRemove.size() > 0) {
            Trace.logDebug(this, "Synchronization: Invoke replication request to remove applications '{}'.", apiKeyReplicatedData.applicationsToRemove);
            ((ApplicationDaoReplicated)this.applicationDaoReplicated).invokeReplication("removeDeletedApplications", apiKeyReplicatedData.applicationsToRemove);
        }
    }

    private void propagateTokensDataToSysplex(AbstractApiKeyManager.ApiKeyReplicatedData apiKeyReplicatedData) {
        if (apiKeyReplicatedData.localTokens != null) {
            for (ApiKeyToken localToken : apiKeyReplicatedData.localTokens) {
                if (localToken.getDeletedAt() > 0L) {
                    Trace.logDebug(this, "Synchronization: Invoke replication request to delete token '{}', name '{}'.", localToken.getTokenId(), localToken.getName());
                    ((ApiKeyTokenDaoReplicated)this.apiKeyTokenDaoReplicated).invokeReplication("deleteByTokenId", localToken.getTokenId());
                    continue;
                }
                if (apiKeyReplicatedData.tokens.stream().filter(t -> t.getTokenId().equals(localToken.getTokenId())).findFirst().isPresent()) {
                    Trace.logDebug(this, "Synchronization: Invoke replication request to update token '{}', name '{}'.", localToken.getTokenId(), localToken.getName());
                    ((ApiKeyTokenDaoReplicated)this.apiKeyTokenDaoReplicated).invokeReplication("updateByTokenId", localToken);
                    continue;
                }
                Trace.logDebug(this, "Synchronization: Invoke replication request to insert token id '{}', name '{}'.", localToken.getTokenId(), localToken.getName());
                ((ApiKeyTokenDaoReplicated)this.apiKeyTokenDaoReplicated).invokeReplication("insert", localToken);
            }
        }
        if (apiKeyReplicatedData.tokensToRemove != null && apiKeyReplicatedData.tokensToRemove.size() > 0) {
            Trace.logDebug(this, "Synchronization: Invoke replication request to remove tokens '{}'.", apiKeyReplicatedData.tokensToRemove);
            ((ApiKeyTokenDaoReplicated)this.apiKeyTokenDaoReplicated).invokeReplication("removeDeletedTokens", apiKeyReplicatedData.tokensToRemove);
        }
    }

    private void logSynchronizeApplicationException(Exception exception, String operation, Application application) {
        Trace.logError(this, "Failed to synchronized Api Key Applications. Failed to {} application id '{}', name '{}'.", operation, application.getApplicationId(), application.getName());
        this.logException(exception);
    }

    private void logSynchronizeTokenException(Exception exception, String operation, ApiKeyToken token) {
        Trace.logError(this, "Failed to synchronize Api Key Tokens. Failed to {} token id '{}', name '{}'.", operation, token.getTokenId(), token.getName());
        this.logException(exception);
    }

    private void logException(Exception exception) {
        Trace.logError(this, Utils.formatExceptionWithUnrepeatedCauses(exception));
        if (Trace.isDebugEnabled(this.getClass())) {
            Trace.logException(this, exception, true);
        }
    }
}

