/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.oauth2.servlet;

import com.streamscape.sef.network.http.server.authentication.HTTPCredentials;
import com.streamscape.sef.network.http.server.authentication.RuntimeAuthenticator;
import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthAccessToken;
import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthCode;
import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthErrorException;
import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthRefreshToken;
import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthTokenProvider;
import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthUtils;
import com.streamscape.sef.network.http.server.authentication.oauth2.request.OAuthTokenRequest;
import com.streamscape.sef.network.http.server.authentication.oauth2.response.OAuthTokenResponse;
import com.streamscape.sef.network.http.server.authentication.oauth2.servlet.AbstractOAuthServlet;
import com.streamscape.sef.network.http.server.authentication.oauth2.types.GrantType;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class OAuthTokenServlet
extends AbstractOAuthServlet {
    @Override
    protected void doProcessRequest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException, OAuthErrorException {
        OAuthTokenRequest request = new OAuthTokenRequest(req);
        GrantType grantType = request.getGrantType();
        if (grantType == GrantType.PASSWORD) {
            this.processPasswordGrantType(req, res, request);
        } else if (grantType == GrantType.AUTHORIZATION_CODE) {
            this.processAuthorizationCodeGrantType(req, res, request);
        } else if (grantType == GrantType.REFRESH_TOKEN) {
            this.processRefreshTokenGrantType(req, res, request);
        }
    }

    protected void processPasswordGrantType(HttpServletRequest req, HttpServletResponse res, OAuthTokenRequest request) throws OAuthErrorException, ServletException, IOException {
        RuntimeAuthenticator runtimeAuthenticator = (RuntimeAuthenticator)this.getServletContext().getAttribute(RuntimeAuthenticator.ATTRIBUTE);
        HTTPCredentials credentials = HTTPCredentials.buildDigest(request.getUsername(), request.getPassword());
        try {
            runtimeAuthenticator.authenticate(credentials);
        }
        catch (Exception exception) {
            throw new OAuthErrorException("invalid_client", "Authentication failed for user: " + request.getUsername());
        }
        OAuthAccessToken token = this.getProvider().createTokenByPasswordGrant(request);
        OAuthTokenResponse.build(token).reply(res);
    }

    protected void processAuthorizationCodeGrantType(HttpServletRequest req, HttpServletResponse res, OAuthTokenRequest request) throws OAuthErrorException, ServletException, IOException {
        OAuthTokenProvider provider = this.getProvider();
        OAuthCode code = provider.getCode(request.getCode());
        if (code == null || code.isExpired()) {
            throw new OAuthErrorException("invalid_client", "code is invalid or expired.");
        }
        OAuthAccessToken token = code.getToken();
        if (!OAuthUtils.equalsIgnoreCase(code.getRedirectUri(), request.getRedirectURI())) {
            throw new OAuthErrorException("invalid_client", "redirect_uri mismatch.");
        }
        if (!OAuthUtils.equals(token.getClientId(), request.getClientId())) {
            throw new OAuthErrorException("invalid_client", "client_id mismatch.");
        }
        token = provider.createTokenByCodeGrant(code);
        OAuthTokenResponse.build(token).reply(res);
    }

    protected void processRefreshTokenGrantType(HttpServletRequest req, HttpServletResponse res, OAuthTokenRequest request) throws OAuthErrorException, ServletException, IOException {
        OAuthTokenProvider provider = this.getProvider();
        OAuthRefreshToken refreshToken = provider.getRefreshToken(request.getRefreshToken());
        if (refreshToken == null || refreshToken.isExpired()) {
            throw new OAuthErrorException("invalid_client", "refresh token is invalid or expired.");
        }
        OAuthAccessToken token = provider.createTokenByRefreshTokenGrant(refreshToken);
        OAuthTokenResponse.build(token).reply(res);
    }
}

