/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.oauth2.servlet;

import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthAccessToken;
import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthErrorException;
import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthRefreshToken;
import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthTokenProvider;
import com.streamscape.sef.network.http.server.authentication.oauth2.request.OAuthRevokeRequest;
import com.streamscape.sef.network.http.server.authentication.oauth2.servlet.AbstractOAuthServlet;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class OAuthRevokeServlet
extends AbstractOAuthServlet {
    @Override
    protected void doProcessRequest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException, OAuthErrorException {
        OAuthRevokeRequest request = new OAuthRevokeRequest(req);
        if (OAuthTokenProvider.isAccessToken(request.getToken())) {
            this.revokeAccessToken(req, res, request.getToken(), request.getClientId());
        } else if (OAuthTokenProvider.isRefreshToken(request.getToken())) {
            this.revokeRefreshToken(req, res, request.getToken(), request.getClientId());
        } else {
            throw new OAuthErrorException("invalid_request", "Unknown token type, not access or refresh token.");
        }
    }

    protected void revokeAccessToken(HttpServletRequest req, HttpServletResponse res, String token, String client_id) throws OAuthErrorException {
        OAuthTokenProvider provider = this.getProvider();
        OAuthAccessToken accessToken = provider.getAccessToken(token);
        if (accessToken == null || accessToken.isExpired()) {
            res.setStatus(200);
            return;
        }
        if (accessToken.getClientId() != null && !accessToken.getClientId().equals(client_id)) {
            throw new OAuthErrorException("invalid_client", "Specified access token doesn't match to specified client_id.");
        }
        accessToken.setExpiresIn(-1L);
        res.setStatus(200);
    }

    protected void revokeRefreshToken(HttpServletRequest req, HttpServletResponse res, String token, String client_id) throws OAuthErrorException {
        OAuthTokenProvider provider = this.getProvider();
        OAuthRefreshToken refreshToken = provider.getRefreshToken(token);
        if (refreshToken == null || refreshToken.isExpired()) {
            res.setStatus(200);
            return;
        }
        if (refreshToken.getAccessToken().getClientId() != null && !refreshToken.getAccessToken().getClientId().equals(refreshToken.getAccessToken().getClientId())) {
            throw new OAuthErrorException("invalid_client", "Specified refresh token doesn't match to specified client_id.");
        }
        refreshToken.setExpiresIn(-1L);
        refreshToken.getAccessToken().setExpiresIn(-1L);
        res.setStatus(200);
    }
}

