/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.authentication.oauth2.servlet;

import com.streamscape.Trace;
import com.streamscape.sef.network.http.server.authentication.HTTPCredentials;
import com.streamscape.sef.network.http.server.authentication.RuntimeAuthenticator;
import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthAccessToken;
import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthCode;
import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthErrorException;
import com.streamscape.sef.network.http.server.authentication.oauth2.OAuthTokenProvider;
import com.streamscape.sef.network.http.server.authentication.oauth2.request.OAuthAuthenticateRequest;
import com.streamscape.sef.network.http.server.authentication.oauth2.request.OAuthAuthorizeRequest;
import com.streamscape.sef.network.http.server.authentication.oauth2.response.OAuthCodeResponse;
import com.streamscape.sef.network.http.server.authentication.oauth2.response.OAuthResponse;
import com.streamscape.sef.network.http.server.authentication.oauth2.response.OAuthTokenResponse;
import com.streamscape.sef.network.http.server.authentication.oauth2.servlet.AbstractOAuthServlet;
import com.streamscape.sef.network.http.server.authentication.oauth2.servlet.HtmlTemplate;
import com.streamscape.sef.network.http.server.authentication.oauth2.types.ResponseType;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class OAuthAuthorizeServlet
extends AbstractOAuthServlet {
    private HtmlTemplate template;

    @Override
    public void init() throws ServletException {
        super.init();
        String filename = "com/streamscape/sef/network/http/server/servlet/html/oauth2authentication.html";
        try {
            byte[] bytes = HTTPUtils.getResourceFromJar(filename);
            if (bytes == null) {
                throw new Exception("Null content returned.");
            }
            this.template = new HtmlTemplate(new String(bytes));
        }
        catch (Exception exception) {
            Trace.logError(this, "Failed to load oauth authorize file '" + filename + "'.");
            Trace.logException(this, exception, false);
        }
        if (this.template == null) {
            this.template = new HtmlTemplate("<html>\n<head><title>Streamscape authentication page</title></head>\n<body>\n<h3>Streamscape authentication form</h3>\n<form id=\"loginform\" action=\"/security/oauth2/authorize\" method=\"post\">\nLogin:\n<input type=\"text\" name=\"login\" id=\"login\"/><br>\nPassword:\n<input type=\"password\" name=\"password\" id=\"password\"/><br>\n<input type=\"hidden\" id=\"client_id\" name=\"client_id\" value=\"{client_id}\"/>\n<input type=\"hidden\" id=\"client_secret\" name=\"client_secret\" value=\"{client_secret}\"/>\n<input type=\"hidden\" id=\"redirect_uri\" name=\"redirect_uri\" value=\"{redirect_uri}\"/>\n<input type=\"hidden\" id=\"response_type\" name=\"response_type\" value=\"{response_type}\"/>\n<input type=\"hidden\" id=\"state\" name=\"state\" value=\"{state}\"/>\n<input type=\"submit\" name=\"authorize\" id=\"authorize\" value=\"Authorize\"/>\n</form>\n</body>\n</html>\n");
        }
        this.template.setTemplateFields("client_id", "client_secret", "redirect_uri", "response_type", "state");
        try {
            this.template.compile();
        }
        catch (Exception exception) {
            Trace.logError(this, "Failed to compile oauth authorize html template.");
            Trace.logException(this, exception, false);
            throw exception;
        }
    }

    @Override
    protected void doProcessRequest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException, OAuthErrorException {
        if (req.getMethod().equalsIgnoreCase("GET")) {
            this.processOAuthAuthorizeRequest(req, res);
        } else if (req.getMethod().equalsIgnoreCase("POST")) {
            this.processOAuthAuthenticateRequest(req, res);
        }
    }

    protected void processOAuthAuthorizeRequest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            OAuthAuthorizeRequest request = new OAuthAuthorizeRequest(req);
            ServletOutputStream answer = res.getOutputStream();
            this.printAuthenticationPage(request, answer);
            answer.close();
        }
        catch (OAuthErrorException exception) {
            Trace.logError(this, "OAuth authorize request exception: " + exception.getMessage());
            this.processException(req, res, exception);
        }
    }

    protected void printAuthenticationPage(OAuthAuthorizeRequest request, ServletOutputStream answer) throws IOException {
        HtmlTemplate.Builder builder = this.template.createBuilder();
        builder.setFieldValue("client_id", request.getClientId());
        builder.setFieldValue("client_secret", request.getClientSecret());
        builder.setFieldValue("redirect_uri", request.getRedirectURI());
        builder.setFieldValue("response_type", request.getResponseType().toString());
        builder.setFieldValue("state", request.getState());
        builder.build(answer);
    }

    protected void processOAuthAuthenticateRequest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException, OAuthErrorException {
        RuntimeAuthenticator runtimeAuthenticator = (RuntimeAuthenticator)this.getServletContext().getAttribute(RuntimeAuthenticator.ATTRIBUTE);
        OAuthAuthenticateRequest request = new OAuthAuthenticateRequest(req);
        HTTPCredentials credentials = HTTPCredentials.buildDigest(request.getUsername(), request.getPassword());
        try {
            runtimeAuthenticator.authenticate(credentials);
        }
        catch (Exception exception) {
            throw new OAuthErrorException("access_denied", exception.getMessage(), null, request.getRedirectURI(), request.getResponseType());
        }
        OAuthTokenProvider provider = this.getProvider();
        if (request.getResponseType() == ResponseType.TOKEN) {
            try {
                OAuthAccessToken token = provider.createTokenByTokenRequest(request);
                OAuthTokenResponse.build(token).setRedirectURI(request.getRedirectURI()).setResponseFormat(request.getResponseType() == ResponseType.CODE ? OAuthResponse.ResponseFormat.QUERY : OAuthResponse.ResponseFormat.FRAGMENT).reply(res);
            }
            catch (OAuthErrorException exception) {
                exception.setRedirectUri(request.getRedirectURI());
                exception.setResponseType(request.getResponseType());
                throw exception;
            }
        } else if (request.getResponseType() == ResponseType.CODE) {
            OAuthCode code = provider.createCode(request);
            OAuthCodeResponse.build(code).reply(res);
        }
    }
}

